#! /bin/bash

classes=`find ./ -name "*.class" | wc -l`
genclasses=`find ./ -name "*.class" | grep "classes" | wc -l`
jfiles=`find ./ -name "*.java" | wc -l`
genfiles=`find ./ -name "*.java" | grep "classes" | wc -l`
exfiles=`find ./ -name "*.java" | grep "examples" | wc -l`

csfiles=`find ../DemeterF-CS -name "*.cs" | wc -l`

echo " $classes : Classes"
echo " $genclasses : Generated Classes"
echo " $jfiles : Java Files"
echo " $genfiles : Generated Java Files"
echo " $exfiles : Example Java Files"
echo 
echo " $csfiles : C# Files"

handjfiles=`find ./ -name "*.java" | grep -v "classes" | grep -v "examples"`
behfiles=`find ./ -name "*.beh"`

totlines=0
lines=0

for i in $handjfiles $behfiles; do
    lns=`cat $i | wc -l`
    totlines=$((totlines+lns))
    nclns=`egrep -v '^ *$' $i | wc -l`
    lines=$((lines+nclns))
done

echo " $totlines : Total Hand Written Java/BEH Lines"
echo " $lines : Non-blank Hand Written Java/BEH Lines"

alljfiles=`find ./ -name "*.java"`

totlines=0
lines=0

for i in $alljfiles; do
    lns=`cat $i | wc -l`
    totlines=$((totlines+lns))
    nclns=`egrep -v '^ *$' $i | wc -l`
    lines=$((lines+nclns))
done

echo " $totlines : Total Java Lines"
echo " $lines : Non-blank Java Lines"

csfiles=`find ../DemeterF-CS -name "*.cs"`

totlines=0
lines=0

for i in $csfiles; do
    lns=`cat $i | wc -l`
    totlines=$((totlines+lns))
    nclns=`egrep -v '^ *$' $i | wc -l`
    lines=$((lines+nclns))
done

echo " $totlines : Total C# Lines"
echo " $lines : Non-blank C# Lines"