using System;
using edu.neu.ccs.demeterf.lib;

public class ListTest {
    static Random rand = new Random();
    class TestB : List<int>.Build{
        public override int build(int i){ return rand.Next(100); }
    }
    class TestC : List<int>.Comp{
        public override bool comp(int i, int j){ return i < j; }
    }
    static long millis(DateTime st){
        TimeSpan tm = DateTime.Now - st;
        return (tm.Seconds*1000+tm.Milliseconds);
    }
    public static void Main2(String[] args){
        List<int> lst = List<int>.buildlist(new TestB(), 10);
        List<int>.Comp c = new TestC();
        Console.WriteLine("   List: "+lst);
        DateTime st = DateTime.Now;
        //for(int i = 0; i < 20; i++)lst.mergeSort(c);
        Console.WriteLine("  Merge: "+lst.mergeSort(c));//millis(st));
                
        st = DateTime.Now;
        //for(int i = 0; i < 20; i++)lst.sort(c);
        Console.WriteLine(" Insert: "+lst.sort(c));//millis(st));
    }

    public static void Main(String[] args){
        List<String> l = List<String>.create("A","B","C","D","E");
        foreach(String s in l)Console.Write(s+":");
        Console.WriteLine("\n\n"+l.reverse().map(new Mapper()));
    }

    class Mapper : List<string>.Map<string>{
        public override string map(string s){ return "'"+s+"'"; }
    }
}