using System;
using System.Reflection;
using genlib = System.Collections.Generic;
using edu.neu.ccs.demeterf.dispatch;
using edu.neu.ccs.demeterf.lib;

namespace edu.neu.ccs.demeterf.util{
    public class Util {
        public static bool skipPrivate = true;
        public static bool allowNull = false;

        public static BindingFlags ReflectFlags = BindingFlags.Instance 
                                                | BindingFlags.Public 
                                                | BindingFlags.NonPublic;
        public static Type objectType = typeof(Object);
        public static void print(String s) { Console.Write(s); }
        public static void println(String s) { Console.WriteLine(s); }

        public static Type[] builtInTypes = new Type[]
            {typeof(bool), typeof(short), typeof(int), typeof(long),
             typeof(byte),typeof(sbyte),typeof(char),typeof(string),
             typeof(float),typeof(double),typeof(decimal),
             typeof(ident),typeof(verbatim)};

        public static genlib.Dictionary<Type,bool> builtIns = new genlib.Dictionary<Type,bool>();
        static Util(){ foreach(Type t in builtInTypes) builtIns.Add(t,true); }

        public static FieldInfo[] getFieldArray(Type t){
            return t.GetFields(ReflectFlags);
        }

        private static genlib.Dictionary<Type, List<FieldInfo>>
            memo = new genlib.Dictionary<Type, List<FieldInfo>>();

        public static List<FieldInfo> getFuncFields(Type t){
            lock(memo){
                if(memo.ContainsKey(t))return memo[t];
            
                FieldInfo[] fields = getFieldArray(t);
                List<FieldInfo> lst = List<FieldInfo>.create();
                foreach(FieldInfo f in fields)
                    if((!skipPrivate || !f.IsPrivate) && !f.IsStatic)
                        lst = lst.push(f);
                
                lst = lst.reverse();
                memo.Add(t, lst);
                return lst;
            }
        }


        // Manage the BuiltIn Types
        public static bool isBuiltIn(Type t){ return builtIns.ContainsKey(t); }
        public static void addBuiltIn(Type t){ builtIns.Add(t,true); }
        public static void addBuiltIns(params Type[] ts) { foreach(Type t in ts)addBuiltIn(t); }


        // Add the Argument (if there is one) to the end of the array
        public static Object[] addArg(Object[] o, Option arg) {
            Object[] r = o;
            if(arg.some()) {
                r = new Object[o.Length+1];
                r[o.Length] = arg.get();
                for(int i = 0; i < o.Length; i++)
                    r[i] = o[i];
            }
            return r;
        }

        // Generic Function Object Application
        public static Object applyFObj(Object f, Object[] o, MethodDB<MethodInfo> db, String meth, int def) {
            Type[] ts = typesFromObjects(o, o.Length);
            DBEntry<MethodInfo> mtch = db.matchEntryFast(ts);

            if(mtch == null){
                if(def < 0)
                    throw new Exception("\n  DemeterF: Did Not Find a Match for: \n      "+
                        signature(f.GetType(), meth, o, o.Length)+"\n");
                return o[def];
            }
            return mtch.getMethod().Invoke(f,objectSubset(o,mtch.numArgs()));
        }

        public static void nullFieldError(FieldInfo f){
            throw new Exception("\n  DemeterF: Null Field Found:  "+
                f.FieldType+"."+f.Name+"\n");
        }

        // Type Array from an Object Array [Map :)]
        public static Type[] typesFromObjects(Object[] o, int len) {
            Type[] ts = new Type[len];
            for(int i = 0; i < len; i++)
                ts[i] = o[i].GetType();
            return ts;
        }

        // Object Array from another Object Array
        public static Object[] objectSubset(Object[] o, int len){
            Object[] os = new Object[len];
            for(int i = 0; i < len; i++)
                os[i] = o[i];
            return os;
        }

        // Signature Printing Helper
        public static String signature<M>(DBEntry<M> e){
            return signature(e.declaringType(), e.getName(),e.getArgs(), e.numArgs());
        }
        /** Signature Printing Helper */
        public static String signature(Type t, String name, Object[] os, int max){
            return signature(t, name, typesFromObjects(os, max), max);
        }
        /** Signature Printing Helper */
        public static String signature(Type t, String name, Type[] ts, int max){
            String s = t.Name+"."+name+"(";
            for(int i = 0; i < max; i++){
                s += (ts == null)?"null":(ts[i].Name);
                if(i < max-1)s += (", ");
            }
            return s+")";
        }
    }
}
