

using System;
using System.Threading;

namespace edu.neu.ccs.demeterf.parallel{
    using System.Reflection;
    using edu.neu.ccs.demeterf;
    using edu.neu.ccs.demeterf.util;
    using edu.neu.ccs.demeterf.lib;

    /** Traverses an object structure in <b>Parallel</b>, using a
     *   function object.  Java threads are used to fork each
     *   subtraversal, synchronizing on their return.  Because of the
     *   way the DemeterF traversal is written, this is rather simple.
     */
    public class ParTraversal : Traversal{
        bool parallel = true;
        /** Create a parameterized Traversal that goes Everywhere */
        public ParTraversal(FC f) : this(f, Control.everywhere()) {}
        /** Create a Traversal with Selective edge/field Bypassing */
        public ParTraversal(FC f, Control c) : base(f, c) {}
        /** Create a Traversal with a Builder that goes Everywhere */
    
        List<object> mt = List<object>.create();
        protected List<object> traverseFields(Type c, object o, List<FieldInfo> fl, int len, Option arg, bool par){
            bool hasArg = arg.some();
            if(len == 0)return mt;
            if(parallel)parallel = false;
        
            FieldInfo f = fl.top();
            //if(!f.isAccessible())f.setAccessible(true);
            object tret = f.GetValue(o);
            if(len == 1){
                if(!control.skip(c, f.Name) && !Util.isBuiltIn(tret.GetType()))
                    return mt.push(traverse<object>(tret,(hasArg)?applyAugment(new object[]{o, arg.get()},f):
                                                    arg));
                return mt.push(tret);
            }
            if(par){
                SubTrav t = new SubTrav(tret,arg,this);
                t.start();
                List<object> rest = traverseFields(c,o,fl.pop(),len-1,arg,par);
                t.waitDone();
                return rest.push(t.result());
            }else{
                Option farg = (hasArg)?applyAugment(new object[]{o, arg.get()},f):arg;
                return traverseFields(c,o,fl.pop(),len-1,arg,par)
                    .push((!control.skip(c, f.Name) && !Util.isBuiltIn(tret.GetType()))?
                          this.traverse<object>(tret,farg):tret);
            }
        }
        protected override Ret traverse<Ret>(object o, Option arg){
            Type c = o.GetType();
            if(control.isBuiltIn(c))
                return (Ret)applyBuilder(Util.addArg(new object[]{o},arg),true);
            else{
                List<FieldInfo> fl = Util.getFuncFields(c);
                List<object> r = traverseFields(c,o,fl,fl.length(),arg,parallel);
                object[] ret = r.push((Ret)o).toArray(new object[fl.length()+1]);
                return (Ret)applyBuilder(Util.addArg(ret, arg),false);
            }
        }
    
        /** Represents a traversal <i>continuation</i> (kind of), so that the return
         *   value can be stored and the parent signaled. This one applies the <code>
         *   traversal()</code> function.*/
        class SubTrav{
            static int nums = 1;
            int mynum;
            object tobj;
            ParTraversal trav;
            Option arg;
            object res;
            bool done = false;
            Thread current;

            public SubTrav(object o, Option a, ParTraversal t) { tobj = o; trav = t; arg = a; mynum = nums++; current = new Thread(run); }
            public void start(){ current.Start(); }
            public void run(){
                setDone(trav.traverse<object>(tobj,arg));
                //System.Console.WriteLine("THREAD: "+mynum+" DONE");
            }
            public void setDone(object r){
                lock(this){
                    res = r; done = true;
                }
            }
            public void waitDone(){
                lock(this){
                    if(!done)current.Join();
                }
            }
            public object result(){ return res; }
        }
    }

}