using System;
using System.Collections.Generic;

using Fields = edu.neu.ccs.demeterf.Fields;

namespace edu.neu.ccs.demeterf.lib{
          
    /** Wrapping class for Sets, so that the elements are not
     *    forced to be <tt>IComparable</tt>. */
    public class Wrap<X> : IComparable<Wrap<X>>{
        protected readonly X x;
        private readonly Comparison<X> comp;

        public class xF : Fields.any{}

        public X GetX(){ return x; }
        
        /** Simple Comparator for comparable elements */
        public static int CComp(X a, X b){ return ((IComparable<X>)a).CompareTo(b); }
        /** Simple Comparator for Sorting Entries */
        public class LComp : List<Wrap<X>>.Comp{
            public override bool comp(Wrap<X> a, Wrap<X> b){
                return a.CompareTo(b) <= 0;
            }
        }
        
        /** Create a Wrap from a comparable element */
        public Wrap(X xx) : this(xx, CComp) {}
        /** Create a Wrap from an element with a comparator */
        public Wrap(X xx, Comparison<X> c){ x = xx; comp = c; }
        /** Implement the IComparable Interface */
        public int CompareTo(Wrap<X> w){ return comp(x,w.x); }
        /** Canonical "equals" */
        public override bool Equals(Object o){
            if(!(o is Wrap<X>))return false;
            return x.Equals(((Wrap<X>)o).x);
        }
        /** Canonical ToString */
        public override String ToString(){ return x.ToString(); }
    }
}