using System;
namespace edu.neu.ccs.demeterf.lib{

    public class RBLeaf<X> : RBTree<X> where X : IComparable<X>{
        public RBLeaf(){}
        public override String ToString(){ return "RBLeaf("+")"; }
        public override bool Equals(Object o){ return (o is RBLeaf<X>); }
    
        public override bool isLeaf(){ return true; }
        public override bool isBlack(){ return true; }
        public override bool isRed(){ return false; }
        public override bool contains(X x, Comparison<X> comp){ return false; }
        public override bool containsAll(RBTree<X> x, Comparison<X> comp){ return x.isLeaf(); }
        public override X find(X x, Comparison<X> comp){ throw new Exception("Leaf.find() No Elements!"); }
        public override RBTree<X> remove(X x, Comparison<X> comp){ return this; }
        public override RBTree<X> replace(X x, Comparison<X> comp){ return this; }

        public override int size(){ return 0; }

        public override List<X> toList(){ return new Empty<X>(); }
    
        public override RBNode<X> asNode(){ throw new Exception("Leaf.asNode(): Not a Node!"); }
        internal override RBTree<X> makeBlack(){ return this; }
        internal override RBTree<X> makeRed(){  throw new Exception("Leaf.makeRed() : Cannot be Red!"); }
        public override X pred(){ throw new Exception("Leaf.pred(): No Predicessor!"); }
        public override X succ(){ throw new Exception("Leaf.succ(): No successor!"); }
        public override X min(){ throw new Exception("Leaf.pred(): No Minimum!"); }
        public override X max(){ throw new Exception("Leaf.pred(): No Maximum!"); }
    
        internal override RBTree<X> del(X x, Comparison<X> comp){ return this; }
        internal override RBTree<X> ins(X x, Comparison<X> comp){ return node(red(), x, this, this); }    

        public override int GetHashCode(){ return 1321; }        
    }

}
