namespace edu.neu.ccs.demeterf.lib{

using System;
using System.Collections.Generic;

/** Interface representation of PESepList<Syn, X>, a possibly empty separated list */
public interface PESepList<Syn, X>{

    /** Is this list Empty? */
    bool isEmpty();
    /** Get the first element, if it exists */
    X top();
    /** Return a list without the first element */
    SepList<Syn,X> pop();
    
    /** Does this list currently contain Syntax? */
    bool hasSyntax();
    /** Get the first instance of syntax, if it exists */
    Syn topSyntax();
    
    /** Reverse this PESepList */
    SepList<Syn,X> reverse(SepList<Syn,X> acc, Syn s);
    
    /** Return this list as a SepList<Syn,X> */
    SepList<Syn,X> toSepList();
    /** Convert this (possibly empty) SepList into a regular List */
    List<X> toList();
    
    /** The Length of This List */
    int length();
    /** Lookup the i^th item in this List */
    X lookup(int i);
    /** To String, with a separator and prefix */
    String ToString();
}

}