using System;
using System.Collections.Generic;

using Fields = edu.neu.ccs.demeterf.Fields;

namespace edu.neu.ccs.demeterf.lib{


/** Represents a Map of comparable Keys to any old Values, implemented with RBTrees.
 *    The Key requires a Comparison<Key>, but if Key is Comparable, you can simply
 *    supply the type to the createor functions. Also see <tt>Map.Entry</tt>. */
public class ListMap<Key, Val>{
    protected readonly List<Entry<Key,Val>> list;
    private readonly Comparison<Key> comp;
    
    /** Field Class */
    public class listF : Fields.any{}

    class Transformer<NV> : List<Entry<Key,Val>>.Map<Entry<Key,NV>>{
        List<Val>.Map<NV> tr;
        Comparison<Key> comp;
        public Transformer(List<Val>.Map<NV> trr, Comparison<Key> c){ tr = trr; comp = c; }
        public override Entry<Key,NV> map(Entry<Key,Val> e){
            return Entry<Key,NV>.create(e.GetKey(), tr.map(e.GetVal()), comp);
        }
    }
    /** Transform Each of the Keys */
    public ListMap<Key,NVal> transformValues<NVal>(List<Val>.Map<NVal> tr){
        return ListMap<Key,NVal>.create(toList().map(new Transformer<NVal>(tr,comp)),comp);
    }
    
    /** Create an Empty Map of *Comparable* Elements. */
    private ListMap() : this(List<Entry<Key,Val>>.create(), Entry<Key,Val>.CComp) { }
    /** Create an Empty Map using the given Comparison to compare elements. */
    private ListMap(Comparison<Key> c) : this(List<Entry<Key,Val>>.create(), c) { }
    /** Create a Map from the given list of Entries using the given Comparison. */    
    private ListMap(Comparison<Key> c, List<Entry<Key,Val>> l){ list = l; comp = c; }
    
    /** Create a Map from the given list of Entries. The <tt>Key</tt> <b>must</b> implement
     *    <tt>IComparable&lt;Key&gt;</tt>*/
    public ListMap(List<Entry<Key,Val>> l) : this(l, Entry<Key,Val>.CComp) { }
    /** Create a Map from the given list of Entries. The <tt>Key</tt> <b>must</b> implement
     *    <tt>IComparable&lt;Key&gt;</tt>*/
    public ListMap(List<Entry<Key,Val>> l, Comparison<Key> c)
        : this(c,l.removeDuplicates(new Entry<Key,Val>.EComp(c)).sort(new Entry<Key,Val>.LComp(c)))
        { }
    
    /** Create an Empty Map of *IComparable* Elements. */
    public static ListMap<Key,Val> create<Key>() where Key : IComparable<Key> { return new ListMap<Key,Val>(); }
    /** Create an Empty Map using the given Comparison to compare elements. */
    public static ListMap<Key,Val> create(Comparison<Key> c){
        return new ListMap<Key,Val>(c);    
    }
    /** Create a Map from the given list of Entries, with the given Comparison. */    
    public static ListMap<Key,Val> create(List<Entry<Key,Val>> l, Comparison<Key> c){
        return new ListMap<Key,Val>(l,c);
    }
    /** Create a Map from the given list of Entries using the given Comparison. */    
    public static ListMap<Key,Val> create<Key>(List<Entry<Key,Val>> es) where Key : IComparable<Key> {
        return ListMap<Key,Val>.create(es, Entry<Key,Val>.CComp);
    }
    /** Create a Map from the given list of Key's and Values. */    
    public static ListMap<Key,Val> create<Key>(List<Key> ks, List<Val> vs) where Key : IComparable<Key> {
        return ListMap<Key,Val>.create(ks,vs, Entry<Key,Val>.CComp);
    }
    
    class Zipper<K,V> : List<K>.Zip<V, Entry<K,V>>{
        Comparison<K> c;
        public Zipper(Comparison<K> cc){ c = cc; }
        public override Entry<K,V> zip(K k, V v){ return Entry<K,V>.create(k, v, c); }
    }
    /** Create a Map from the given list of Entries using the given Comparison. */    
    public static ListMap<Key,Val> create(List<Key> ks, List<Val> vs, Comparison<Key> c){
        return create(ks.zip(new Zipper<Key,Val>(c), vs), c);
    }
    
    /** Create a Map that uses Hashcode to compare Keys. */
    public static ListMap<Key,Val> hashMap(){
        return new ListMap<Key,Val>(Map<Key,Val>.HashComp);
    }
    /** Create a Map from the given Entry List that uses Hashcode to compare Keys. */
    public static ListMap<Key,Val> hashMap(List<Entry<Key,Val>> l){
        return new ListMap<Key,Val>(l, Map<Key,Val>.HashComp);
    }
    /** Create a Map from the given Key and Value Lists that uses Hashcode to compare Keys. */
    public static ListMap<Key,Val> hashMap(List<Key> ks, List<Val> vs){
        return create(ks,vs, Map<Key,Val>.HashComp);
    }
    /** Create a Map from the given Java HashMap. */
    public static ListMap<Key,Val> hashMap(IEnumerable<KeyValuePair<Key, Val>> hash){
        ListMap<Key,Val> m = ListMap<Key,Val>.hashMap();
        foreach(KeyValuePair<Key, Val> ent in hash)
            m = m.put(ent.Key, ent.Value);
        return m;
    }
        
    /** Create a Map from the given List of Entries using the current Comparison. */
    private ListMap<Key,Val> make(List<Entry<Key,Val>> l){ return new ListMap<Key,Val>(l,comp); }
    
    /** Return the number of elements in this Map */
    public int size(){ return list.length(); }
    /** Does this Map contain the given Key? */
    public bool containsKey(Key k){ return list.contains(new Entry<Key,Val>.KPred(k,comp)); }
    /** Is this Map Empty? */
    public bool isEmpty(){ return list.isEmpty(); }
    /** Return a new Map with the given Mapping (Entry) added. */
    public ListMap<Key,Val> put(Key k, Val v){
        if(containsKey(k))return this;
        return make(list.insert(Entry<Key,Val>.create(k,v,comp), new Entry<Key,Val>.LComp(comp))); }
    /** Return a new Map with the given Mapping added or updated if it exists. */
    public ListMap<Key,Val> remap(Key k, Val v){
        Entry<Key,Val> e = Entry<Key,Val>.create(k,v,comp);
        return make(!containsKey(k)?list.insert(e, new Entry<Key,Val>.LComp(comp)):
                    list.replace(new Entry<Key,Val>.KPred(k,comp),e));
    }
    /** Get the Value that the given Key is mapped to. */
    public Val get(Key k){ return list.find(new Entry<Key,Val>.KPred(k,comp)).GetVal(); }
    /** Return a new Map that does not include the given key */
    public ListMap<Key,Val> remove(Key k){ return make(list.remove(new Entry<Key,Val>.KPred(k,comp))); }
    
    class InList : List<Entry<Key,Val>>.Pred{
        List<Entry<Key,Val>> l;
        Comparison<Key> c;

        public InList(List<Entry<Key,Val>> ll, Comparison<Key> cc){ l = ll; c = cc; }
        public override bool huh(Entry<Key,Val> e){ return l.contains(new Entry<Key,Val>.KPred(e.GetKey(),c)); }
    }
    /** Merge the given Map into this one, ignoring duplicate mappings. */
    public ListMap<Key,Val> merge(ListMap<Key,Val> s){
        return make(list.insert(s.list.filter(new InList(list,comp)), new Entry<Key,Val>.LComp(comp)));
    }
    
    class Merger : List<Entry<Key,Val>>.Fold<List<Entry<Key,Val>>>{
        Map<Key,Val>.Merge m;
        Comparison<Key> comp;
        public Merger(Map<Key,Val>.Merge mm, Comparison<Key> c){ m = mm; comp = c; }
        public override List<Entry<Key,Val>> fold(Entry<Key,Val> e, List<Entry<Key,Val>> l){
            if(!l.contains(new Entry<Key,Val>.KPred(e.GetKey(),comp)))
                return l.insert(e, new Entry<Key,Val>.LComp(comp));
            return l.replace(new Entry<Key,Val>.KPred(e.GetKey(),comp),Entry<Key,Val>.create(e.GetKey(),m.merge(e.GetVal(),
                       l.find(new Entry<Key,Val>.KPred(e.GetKey(),comp)).GetVal()),comp));
        }
    }
    /** Merge the given Map into this one, using the given Merge function object
     *    to merge the elements of matching Keys */
    public ListMap<Key,Val> merge(ListMap<Key,Val> s, Map<Key,Val>.Merge m){
        return make(s.list.fold(new Merger(m,comp), list));
    }
    /** Merge the given Map into this one, using the given Merge function object
     *    to merge the elements of matching Keys */
    public ListMap<Key,Val> merge(Key k, Val v, Map<Key,Val>.Merge m){
        Entry<Key,Val> e = Entry<Key,Val>.create(k,v,comp); 
        if(!containsKey(k))return make(list.insert(e, new Entry<Key,Val>.LComp(comp)));
        return make(list.replace(new Entry<Key,Val>.KPred(k,comp),
                                 Entry<Key,Val>.create(e.GetKey(),
                                                       m.merge(v,list.find(new Entry<Key,Val>.KPred(k,comp))
                                                               .GetVal()),comp)));
    }
    
    class Keyer : List<Entry<Key,Val>>.Map<Key>{
        public override Key map(Entry<Key,Val> e){ return e.GetKey(); }
    }
    /** Reutrn a List of the Keys contained in this Map. */
    public List<Key> keys(){ return toList().map(new Keyer()); }
    
    class Valer : List<Entry<Key,Val>>.Map<Val>{
        public override Val map(Entry<Key,Val> e){ return e.GetVal(); }
    }
    /** Reutrn a List of the Values contained in this Map. */
    public List<Val> values(){ return toList().map(new Valer()); }
    /** Return all the Entries in this Map as a list, in Key order. */
    public List<Entry<Key,Val>> toList(){ return list; }
    /** Support foreach over elements */
    public IEnumerator<Entry<Key,Val>> GetEnumerator(){ return toList().GetEnumerator(); }
    /** Produce a String representation of this Map. */
    public override String ToString(){ return "[ "+toList().ToString(" ","")+" ]"; }
    
    /** Convert this Map into a java.util.Map */
    public Dictionary<Key, Val> toDictionary(){
        Dictionary<Key,Val> m = new Dictionary<Key,Val>();
        foreach(Entry<Key,Val> e in this)m.Add(e.GetKey(), e.GetVal());
        return m;
    }
    
    /** Retur this Maps HashCode */
    public override int GetHashCode(){ return 3*list.sort(new Entry<Key,Val>.LComp(comp)).GetHashCode(); }

    /** Is this map equal to the given object */
    public override bool Equals(Object o){
        if(!(o is ListMap<Key,Val>))return false;
        ListMap<Key,Val> m = (ListMap<Key,Val>)o;
        return list.Equals(m.list);
    }
}

}