using System;

using Fields = edu.neu.ccs.demeterf.Fields;

namespace edu.neu.ccs.demeterf.lib{

/** Class representing Map Entries (key/value Pairs).
 *    Use <tt>Entry.create(Key, Val)</tt> and <tt>Entry.create(Key, Val, Comparator<Key>)</tt>
 *    to create Entries when needed. You shouldn't really need to create them, unles you want
 *    to build a Map from an array or a List. */
public class Entry<Key,Val> : IComparable<Entry<Key,Val>>{
    protected readonly Key key;
    protected readonly Val val;
    private readonly Comparison<Key> comp;
    
    /** Create an Entry from a Key/Value Pair*/
    public Entry(Key k, Val v) : this(k,v,Entry<Key,Val>.CComp) { }
    private Entry(Key k, Val v, Comparison<Key> c){
        key = k; val = v; comp = c; 
    }
    
    public int CompareTo(Entry<Key, Val> e) { return comp(key,e.key); }
    /** Standard Equality */
    public override bool Equals(Object o){
        if(!(o is Entry<Key,Val>))return false;
        Entry<Key,Val> e = (Entry<Key,Val>)o;
        return (key.Equals(e.key) &&
                val.Equals(e.val));
    }
    
    /** Simple Comparator for comparable elements */
    internal static int CComp(Key a, Key b){ return ((IComparable<Key>)a).CompareTo(b); }
    /** Simple Comparator for comparable elements */
    internal static int HashComp(Key a, Key b){ return b.GetHashCode()-a.GetHashCode(); }
    
    /** Simple Comparator for Sorting Entries */
    internal class LComp : List<Entry<Key,Val>>.Comp{
        Comparison<Key> c;
        public LComp(Comparison<Key> cc){ c = cc; }
        public override bool comp(Entry<Key,Val> a, Entry<Key,Val> b){
            return c(a.GetKey(), b.GetKey()) <= 0;
        }
    }
    /** Simple Comparator for Entry/Key Equality */
    internal class EComp : List<Entry<Key,Val>>.Comp{
        Comparison<Key> c;
        public EComp(Comparison<Key> cc){ c = cc; }
        public override bool comp(Entry<Key,Val> a, Entry<Key,Val> b){
            return c(a.GetKey(), b.GetKey()) == 0;
        }
    }
    /** Simple Comparator for Entry/Key Equality */
    internal class KPred : List<Entry<Key,Val>>.Pred{
        Key key;
        Comparison<Key> c;
        public KPred(Key k, Comparison<Key> cc){ key = k; c = cc; }
        public override bool huh(Entry<Key,Val> e){
            return c(key, e.GetKey()) == 0;
        }
    }
    
    /** Field Class for key */
    public class keyF : Fields.any{}
    /** Field Class for val */
    public class valF : Fields.any{}
    
    /** Getter for Entry.key */
    public Key GetKey(){ return key; }
    /** Getter for Entry.val */
    public Val GetVal(){ return val; }
    
    /** Return a String representation of this Entry.  Essentially "(Key -> Val)"*/
    public override String ToString(){ return "("+key+" -> "+val+")"; }
    /** Create an Entry with a Comparable Key, and a Value. */
    public static Entry<Key,Val> create<Key>(Key k, Val v) where Key : IComparable<Key>
        { return new Entry<Key,Val>(k,v, Entry<Key,Val>.CComp); }
    /** Create an Entry with a Key, Value, and a Comparator for Keys. */
    public static Entry<Key,Val> create(Key k, Val v, Comparison<Key> c)
    { return new Entry<Key,Val>(k,v,c);  }
    
    /** Return the HashCode of htis Entry */
    public override int GetHashCode(){ return key.GetHashCode(); }
}

}
