namespace edu.neu.ccs.demeterf.lib{

using System;
using System.Collections.Generic;

/** Representation of EmptyS<Syn, X>, an empty separated list */
public class EmptyS<Syn, X> : SepList<Syn, X>, PESepList<Syn,X>{

    /** Construct a(n) EmptyS<Syn, X> Instance */
    public EmptyS(){}
    
    /** Is the given object Equal to this EmptyS? */
    public override bool Equals(Object o){
        if(!(o is EmptyS<Syn,X>))return false;
        if(o == this)return true;
        EmptyS<Syn, X> oo = (EmptyS<Syn, X>)o;
        return true;
    }

    /** Is this list Empty? */
    public override bool isEmpty(){ return true; }
    /** Get the first element, if it exists */
    public override X top(){ throw new Exception("Bad Top"); }
    /** Get the first element, if it exists */
    public override SepList<Syn,X> pop(){ throw new Exception("Bad Pop"); }
    
    /** Does this list currently contain Syntax? */
    public override bool hasSyntax(){ return false; }
    /** Get the first instance of syntax, if it exists */
    public override Syn topSyntax(){ throw new Exception("No TopSyntax"); }
    
    /** Return this list as a SepList<Syn,X> */
    public SepList<Syn,X> toSepList(){ return this; }
    /** Convert this (empty) SepList into a regular List */
    public override List<X> toList(){ return List<X>.create(); }
    
    /** Push a new element on this SepList */
    public override SepList<Syn,X> push(X x, Syn s){ return new NESepList<Syn,X>(x,this); }
    /** Reverse this SepList */
    public override SepList<Syn,X> reverse(){ return this; }
    /** Reverse this SepList */
    public override SepList<Syn,X> reverse(SepList<Syn,X> acc, Syn s){ return acc; }
    
    /** The Length of This List */
    public override int length(){ return 0; }
    /** Lookup the i^th item in this List */
    public override X lookup(int i){ throw new Exception("Bad Lookup"); }
    /** To String, with a separator and prefix */
    public override String ToString(){ return ""; }
}

}