namespace edu.neu.ccs.demeterf.lib{

using System;
using System.Collections.Generic;

/** Represents the Empty List. You should not use the constructor. To create an
 *    empty list please use List.create<T>().  You Can usually get away without
 *    the type parameter depending on the context. */
public class Empty<X> : List<X> {
    public Empty():base(0){}
  
    public override X top(){ throw new Exception("Bad Top"); }
    public override List<X> pop(){ throw new Exception("Bad Pop"); }
    public override bool isEmpty(){ return true; }
    public override bool Equals(Object o){ return (o is Empty<X>); }
    public override int GetHashCode(){ return 11314233; }
    public override List<X> append(List<X> l){ return l; }
    public override List<X> append(X t){ return this.push(t); }
    public override bool contains(X t){ return false; }
    public override bool contains(Pred p){ return false; }
    public override bool containsAny(List<X> l){ return false; }
    public override bool containsAny(List<X> l, Comp c){ return false; }
    public override bool containsAll(List<X> l){ return l.isEmpty(); }
    public override bool containsAll(List<X> l, Comp c){ return l.isEmpty(); }
    public override String ToString(String sep, String pre){ return ""; }
    public override String ToString(Stringer s){ return ""; }
    public override List<X> filter(Pred p){ return this; }
    public override Y foldl<Y>(Fold<Y> f, Y b){ return b; }
    public override Y foldr<Y>(Fold<Y> f, Y b){ return b; }
}

}