namespace edu.neu.ccs.demeterf.lib{

using System;
using System.Collections.Generic;

/** Representation of ConsS<Syn, X>, a non-empty separated list that has syntax */
public class ConsS<Syn, X> : PESepList<Syn,X>{
    protected readonly Syn syntax;
    protected readonly X first;
    protected readonly PESepList<Syn, X> rest;

    /** Construct a(n) ConsS<Syn, X> Instance */
    public ConsS(Syn syntax, X first, PESepList<Syn, X> rest){
        this.syntax = syntax;
        this.first = first;
        this.rest = rest;
    }
    /** Is the given object Equal to this ConsS? */
    public override bool Equals(Object o){
        if(!(o is ConsS<Syn, X>))return false;
        if(o == this)return true;
        ConsS<Syn, X> oo = (ConsS<Syn, X>)o;
        return (((Object)syntax).Equals(oo.syntax))&&(((Object)first).Equals(oo.first))&&(((Object)rest).Equals(oo.rest));
    }

    /** Field Class for ConsS.syntax */
    public class syntaxF : edu.neu.ccs.demeterf.Fields.any{}
    /** Field Class for ConsS.first */
    public class firstF : edu.neu.ccs.demeterf.Fields.any{}
    /** Field Class for ConsS.rest */
    public class restF : edu.neu.ccs.demeterf.Fields.any{}

    /** Is this list Empty? */
    public bool isEmpty(){ return false; }
    /** Get the first element, if it exists */
    public X top(){ return first; }
    /** Get the first element, if it exists */
    public SepList<Syn,X> pop(){ return rest.toSepList(); }
    
    /** Does this list currently contain Syntax? */
    public bool hasSyntax(){ return true; }
    /** Get the first instance of syntax, if it exists */
    public Syn topSyntax(){ return syntax; }
    
    /** Reverse this PESepList */
    public SepList<Syn,X> reverse(SepList<Syn,X> acc, Syn s){
        return rest.reverse(acc.push(first, syntax), syntax);
    }
    /** Return this list as a SepList<Syn,X> */
    public SepList<Syn,X> toSepList(){ return new NESepList<Syn,X>(first,rest); }
    /** Convert this (non-empty) SepList into a regular List */
    public List<X> toList(){ return rest.toList().push(first); }
    
    /** The Length of This List */
    public int length(){ return 1+rest.length(); }
    /** Lookup the i^th item in this List */
    public X lookup(int i){ return i==0?first:rest.lookup(i-1); }
    /** To String, with a separator and prefix */
    public override String ToString(){ return syntax+" "+first+rest; }
}

}