namespace edu.neu.ccs.demeterf.lib{

using System;
using System.Collections.Generic;
using Fields = edu.neu.ccs.demeterf.Fields;

/** Represents a Lisp style cons list.  You should not use the constructor, use List.push(...)
 *    to add an element to the front of the list.  It is left public so that the parser
 *    generator can parse different lists if needed. */
public class Cons<X> : List<X>{
    protected readonly X first;
    protected readonly List<X> rest;
    
    public Cons(X f, List<X> r):base(r.length()+1){ first = f; rest = r; }
    
    public override X top(){ return first; }
    public override List<X> pop(){ return rest; }
    public override bool isEmpty(){ return false; }
    
    public class firstF : Fields.any{}
    public class restF : Fields.any{}
    
    public X GetFirst(){ return first; }
    public List<X> GetRest(){ return rest; }


    public override bool Equals(Object o){
        if(! (o is Cons<X>))return false;
        List<X> c = (List<X>)o;
        if(c.length() != length())return false;
        foreach(X x in this){
            if(!x.Equals(c.top()))return false;
            c = c.pop();
        }
        return true;
    }

    public override int GetHashCode(){
        int hash = List<X>.create().GetHashCode();
        int mult = 1;
        foreach(X x in this){
            hash += x.GetHashCode()*mult;
            mult *= 5;
        }
        return hash;
    }
}

}