namespace edu.neu.ccs.demeterf.http{

using edu.neu.ccs.demeterf.http.server;
using edu.neu.ccs.demeterf.http.classes;
using edu.neu.ccs.demeterf.lib;
using System;

/** Test Server response class */
[Server]
public class Test{
    [Port]
    readonly int PORT = 9000;
    
    [Path("/html")]
    public HTTPResp htmlResp(HTTPReq req)
    { return HTTPResp.htmlResponse("<html>\n"+
            "<head><title>Sample Page</title></head>\n"+
            "<body><b>HELLO</b> <i>There</i></body><html>"); }
    
    [Path("/text")]
    public HTTPResp textResp(HTTPReq req)
    { return HTTPResp.textResponse("Plain Text Response"); }
    
    [Path("/urlargs")]
    public HTTPResp urlResp(HTTPReq req)
    { return mapToHTML(req.urlArgs()); }

     [Path("/headers")]
    public HTTPResp headerResp(HTTPReq req)
    { return mapToHTML(req.getHeaders()); }
    
    [Path()] // DEFAULT
    public HTTPResp defaultResp(HTTPReq req){
        return HTTPResp.error("ERROR: Unknown Request");
    }
    
    class Folder : List<Entry<String,String>>.Fold<String>{
        public override String fold(Entry<String,String> e, String r){
            return "<b>"+e.GetKey()+"</b> : <i>"+e.GetVal()+"</i><br/>"+r;
        }
    }

    HTTPResp mapToHTML(Map<String,String> m){
        return HTTPResp.htmlResponse("<html>"+ m.toList().fold(new Folder(),"</html>"));
    }
    
    static void p(String s){ Console.WriteLine(s); }
    public static void Main(String[] args) {
        p("Starting Server\n");
        Factory.setVerbose(true);
        ServerThread server = Factory.create(new Test());
        p("Hit enter to shutdown");
        Console.ReadLine();
        server.shutdown();
    }
}

}
