using System;
using System.Reflection;
using edu.neu.ccs.demeterf.util;
using edu.neu.ccs.demeterf.lib;


namespace edu.neu.ccs.demeterf.dispatch {
    public class MethodDB<M>{
        List<DBEntry<M>> methods;
        private MethodDB(List<DBEntry<M>> db) { methods = db; }

        public static MethodDB<MethodInfo> createMDB(Type t, String name){
            List<DBEntry<MethodInfo>> lst = List<DBEntry<MethodInfo>>.create();
            while(t != Util.objectType) {
                MethodInfo[] ms = t.GetMethods(Util.ReflectFlags);
                foreach(MethodInfo m in ms)
                    if(m.Name == name)
                        lst = lst.push(new DBEntry<MethodInfo>(m, t, m.Name, parameterTypes(m.GetParameters()), m.ReturnType));
                t = t.BaseType;
            }
            return new MethodDB<MethodInfo>(lst);
        }
        public static MethodDB<ConstructorInfo> createCDB(Type t) {
            List<DBEntry<ConstructorInfo>> lst = List<DBEntry<ConstructorInfo>>.create();
            ConstructorInfo[] cs = t.GetConstructors(Util.ReflectFlags);
            foreach(ConstructorInfo c in cs)
                lst = lst.push(new DBEntry<ConstructorInfo>(c, t, "<init>", parameterTypes(c.GetParameters()), t));
            return new MethodDB<ConstructorInfo>(lst);
        }

        static Type[] parameterTypes(ParameterInfo[] ps) {
            Type[] ts = new Type[ps.Length];
            for(int i = 0; i < ps.Length; i++)
                ts[i] = ps[i].ParameterType;
            return ts;
        }

        public List<DBEntry<M>> reduce(Type[] args) {
            return methods.filter(new TypePred<M>(args));
        }
        public DBEntry<M> matchEntry(Type[] args){
            List<DBEntry<M>> es = matchEntrys(args);
            return (es.isEmpty()?null:es.top());
        }
        public List<DBEntry<M>> matchEntrys(Type[] args) {
            return reduce(args).sort(new TypeSort<M>());
        }

        public List<DBEntry<M>> getMethods(){ return methods; }

        /** !Quickly! return the most specific (first) Match from the entries.
         * Returns <code>null</code> if none is found. */
        public DBEntry<M> matchEntryFast(Type[] args){
            return matchEntryFast<M>(args, args.Length, methods);
        }
        private static DBEntry<M> matchEntryFast<M>(Type[] args, int len, List<DBEntry<M>> db){
            if(db.isEmpty())return null;
            DBEntry<M> e = db.top();
            if(applicable(args,len,e))
                return matchEntryFast<M>(args, len, db.pop(), e);
            return matchEntryFast<M>(args, len, db.pop());
        }
        private static bool applicable<M>(Type[] args, int len, DBEntry<M> e){
            if(e.numArgs() > len)return false;
            for(int i = 0; i < e.numArgs(); i++)
                if(!e.arg(i).IsAssignableFrom(args[i]))return false;
            return true;
        }
        private static DBEntry<M> matchEntryFast<M>(Type[] args, int len, List<DBEntry<M>> db, DBEntry<M> bst){
            if(db.isEmpty())return bst;
            DBEntry<M> e = db.top();
            if(applicable(args,len,e) && TypeSort<M>.compare(e, bst))
                return matchEntryFast<M>(args, len, db.pop(), e);
            return matchEntryFast<M>(args, len, db.pop(), bst);
        }
    }

    class TypeSort<M> : List<DBEntry<M>>.Comp{
        public override bool comp(DBEntry<M> e1, DBEntry<M> e2){
            return compare(e1,e2);
        }
        public static bool compare(DBEntry<M> e1, DBEntry<M> e2){
            int min = Math.Min(e1.numArgs(), e2.numArgs());
            for(int i = 0; i < min; i++){
                if(!e1.arg(i).Equals(e2.arg(i)))
                    return !(e1.arg(i).IsAssignableFrom(e2.arg(i)));
            }
            return (e1.numArgs() > e2.numArgs());
        }
    }

    class TypePred<M> : List<DBEntry<M>>.Pred {
        Type[] args;
        public TypePred(Type[] a) { args = a; }
        public override bool huh(DBEntry<M> e) {
            if(e.numArgs() > args.Length) return false;
            for(int i = 0; i < e.numArgs(); i++)
                if(!e.arg(i).IsAssignableFrom(args[i]))
                    return false;
            return true;
        }
    }
}
