  ;; Simple home-made list example
  
  (require "apf.scm")

  ;; Define our structures...
  (abstract List (Cons Empty))
  (concrete Empty ("*"))
  (concrete Cons ((first number) (rest List)))
  
  ;; Some useful "functions"
  (define Sum (union-id [(Empty) (e) 0]
                        [(Cons number number) (c f r) (+ f r)]))
  (define Len (union-func (funcset [(number) (n) 1])
                          Sum))
  
  ;; A Data Instance
  (define aList (parse-string 'List "4 2 7 1 *"))
  
  ;; Compute a little through the traversal
  (traverse-b aList Len)
  (traverse-b aList Sum)
  
  ;; A builder for to-string
  (define StrB (union-id
                [(number) (n) (number->string n)]
                [(Cons string string) (c f r) (string-append "(" f " " r ")")]
                [(Empty) (e) "()"]))
  
  
  ;; Wrap the traversal into a simpler method
  (define (List->string lst)
    (traverse-b lst StrB))

  ;; This looks better, right?
  (List->string aList)
  
  ;; Test Function for the Bc Builder...
  (List->string (traverse-b aList (union-Bc [(number) (n) (+ n 1)])))

  ;; Do the accumulator style length function
  (traverse-ba aList
               (union-id [(Cons object number) (c f r) r]
                         [(Empty number) (e n) n])
               (union-idA [(Cons Cons.rest number) (c f n) (add1 n)]) 0)