; Extraction of benchmark results.

(define (readline port)
  (do ((c (read-char port) (read-char port))
       (chars '() (cons c chars)))
      ((or (eof-object? c)
           (char=? c #\newline))
       (list->string (reverse chars)))))

(define (readlines port)
  (do ((c (peek-char port) (peek-char port))
       (lines '() (cons (readline port) lines)))
      ((eof-object? c)
       (reverse lines))))

; If s1 is a substring of s2, then returns the least integer m
; such that (string=? s1 (substring s2 m (+ m (string-length s1)))).
; Otherwise returns #f.

(define (substring? s1 s2)
  (let ((n1 (string-length s1))
        (n2 (string-length s2)))
    (let ((n (- n2 n1)))
      (let loop ((m 0))
        (if (<= m n)
            (if (substring=? s1 s2 m (+ m n1))
                m
                (loop (+ m 1)))
            #f)))))

(define (substring=? s1 s2 m n)
  (and (<= (string-length s1) (- n m))
       (<= n (string-length s2))
       (do ((i 0 (+ i 1))
            (m m (+ m 1)))
           ((or (= m n)
                (not (char=? (string-ref s1 i)
                             (string-ref s2 m))))
            (= m n)))))

(define (right-justify x n . port)
  (let ((p (open-output-string))
        (port (if (null? port) (current-output-port) (car port))))
    (display x p)
    (let* ((s (get-output-string p))
           (m (string-length s)))
      (if (< m n)
          (display (string-append (make-string (- n m) #\space) s) port)
          (display (substring s 0 n) port)))))

(define (left-justify x n . port)
  (let ((p (open-output-string))
        (port (if (null? port) (current-output-port) (car port))))
    (display x p)
    (let* ((s (get-output-string p))
           (m (string-length s)))
      (if (< m n)
          (display (string-append s (make-string (- n m) #\space)) port)
          (display (substring s 0 n) port)))))

(define (summarize f)
  (define (summarize in . rest)
    (define (bad-arguments)
      (error "Bad arguments to summarize-results"
             (cons in rest)))
    (cond ((string? in)
           (call-with-input-file
            in
            (lambda (in) (apply summarize in rest))))
          ((input-port? in)
           (cond ((null? rest)
                  (summarize in (current-output-port)))
                 ((string? (car rest))
                  (call-with-output-file
                   (car rest)
                   (lambda (out)
                     (summarize in out))))
                 ((output-port? (car rest))
                  (f (readlines in) (car rest)))
                 (else
                  (bad-arguments))))
          (else
           (bad-arguments))))
  summarize)

; Gambit-C

(define (gambit-results lines out)
  (let ((system-key "Benchmarking ")
        (test-key "Testing ")
        (test-key-tail " under Gambit-C")
        (cpu-key " ms cpu time")
        (real-key " ms real time")
        (gc-key " collections accounting for ")
        (ms-key " ms")
        (space-key "    ")
        (error-key "Error: ")
        (wrong-key "*** wrong result ***"))
    (let ((n-system-key (string-length system-key))
          (n-test-key (string-length test-key))
          (n-cpu-key (string-length cpu-key))
          (n-real-key (string-length real-key))
          (n-gc-key (string-length gc-key))
          (n-ms-key (string-length ms-key))
          (n-space-key (string-length space-key))
          (n-error-key (string-length error-key))
          (n-wrong-key (string-length wrong-key))
          (name-width 20)
          (timing-width 10))
      (let loop ((lines lines)
                 (real ""))
        (if (null? lines)
            (newline out)
            (let ((line (car lines)))
              (cond ((substring=? system-key line 0 n-system-key)
                     (display line out)
                     (newline out)
                     (newline out)
                     (display "benchmark                  cpu      real        gc"
                              out)
                     (newline out))
                    ((substring=? test-key line 0 n-test-key)
                     (newline out)
                     (let ((name (substring line
                                            n-test-key
                                            (substring? test-key-tail line))))
                       (left-justify name name-width out)))
                    ((substring? gc-key line)
                     (let ((x (substring line
                                         (+ n-gc-key (substring? gc-key line))
                                         (substring? ms-key line))))
                       (right-justify x timing-width out)))
                    ((substring? cpu-key line)
                     (let ((x (substring line
                                         n-space-key
                                         (substring? cpu-key line))))
                       (right-justify x timing-width out)
                       (right-justify real timing-width out)))
                    ((substring? real-key line)
                     (let ((x (substring line
                                         n-space-key
                                         (substring? real-key line))))
                       (set! real x)))
                    ((substring=? error-key line 0 n-error-key)
                     (display line out)
                     (newline out)
                     (display (make-string name-width #\space) out))
                    ((substring=? wrong-key line 0 n-wrong-key)
                     (display "    " out)
                     (display line out)
                     (newline out)
                     (display (make-string name-width #\space) out)))
              (loop (cdr lines) real)))))))

; Chez Scheme.

(define (chez-results lines out)
  (let ((system-key "Benchmarking ")
        (test-key "Testing ")
        (test-key-tail " under Chez-Scheme")
        (cpu-key " ms elapsed cpu time")
        (real-key " ms elapsed real time")
        (space-key "    ")
        (error-key "Error: ")
        (wrong-key "*** wrong result ***"))
    (let ((n-system-key (string-length system-key))
          (n-test-key (string-length test-key))
          (n-cpu-key (string-length cpu-key))
          (n-real-key (string-length real-key))
          (n-space-key (string-length space-key))
          (n-error-key (string-length error-key))
          (n-wrong-key (string-length wrong-key))
          (name-width 20)
          (timing-width 10))
      (let loop ((lines lines))
        (if (null? lines)
            (newline out)
            (let ((line (car lines)))
              (cond ((substring=? system-key line 0 n-system-key)
                     (display line out)
                     (newline out)
                     (newline out)
                     (display "benchmark                  cpu      real" out)
                     (newline out))
                    ((substring=? test-key line 0 n-test-key)
                     (newline out)
                     (let ((name (substring line
                                            n-test-key
                                            (substring? test-key-tail line))))
                       (left-justify name name-width out)))
                    ((substring? cpu-key line)
                     (let ((x (substring line
                                         n-space-key
                                         (substring? cpu-key line))))
                       (right-justify x timing-width out)))
                    ((substring? real-key line)
                     (let ((x (substring line
                                         n-space-key
                                         (substring? real-key line))))
                       (right-justify x timing-width out)))
                    ((substring=? error-key line 0 n-error-key)
                     (display line out)
                     (newline out)
                     (display (make-string name-width #\space) out))
                    ((substring=? wrong-key line 0 n-wrong-key)
                     (display "    " out)
                     (display line out)
                     (newline out)
                     (display (make-string name-width #\space) out)))
              (loop (cdr lines))))))))

(define (larceny-results lines out)
  (let ((system-key "Benchmarking ")
        (test-key "Testing ")
        (test-key-tail " under Larceny")
        (cpu-key "User: ")
        (real-key "Elapsed time...: ")
        (gc-key "Elapsed GC time: ")
        (ms-key " ms")
        (error-key "Error: ")
        (wrong-key "*** wrong result ***"))
    (let ((n-system-key (string-length system-key))
          (n-test-key (string-length test-key))
          (n-cpu-key (string-length cpu-key))
          (n-real-key (string-length real-key))
          (n-gc-key (string-length gc-key))
          (n-ms-key (string-length ms-key))
          (n-error-key (string-length error-key))
          (n-wrong-key (string-length wrong-key))
          (name-width 20)
          (timing-width 10))
      (let loop ((lines lines))
        (if (null? lines)
            (newline out)
            (let ((line (car lines)))
              (cond ((substring=? system-key line 0 n-system-key)
                     (display line out)
                     (newline out)
                     (newline out)
                     (display
                      "benchmark                  cpu      real        gc"
                      out)
                     (newline out))
                    ((substring=? test-key line 0 n-test-key)
                     (newline out)
                     (let ((name (substring line
                                            n-test-key
                                            (substring? test-key-tail line))))
                       (left-justify name name-width out)))
                    ((substring=? real-key line 0 n-real-key)
                     (let* ((n1 (substring? ms-key line))
                            (n2 (substring? cpu-key line))
                            (s  (substring line n2 (string-length line)))
                            (n3 (substring? ms-key s))
                            (x (substring line n-real-key n1))
                            (y (substring s n-cpu-key n3)))
                       (right-justify y timing-width out)
                       (right-justify x timing-width out)))
                    ((substring=? gc-key line 0 n-gc-key)
                     (let* ((n1 (substring? ms-key line))
                            (x (substring line n-gc-key n1)))
                       (right-justify x timing-width out)))
                    ((substring=? error-key line 0 n-error-key)
                     (display line out)
                     (newline out)
                     (display (make-string name-width #\space) out))
                    ((substring=? wrong-key line 0 n-wrong-key)
                     (display line out)
                     (newline out)
                     (display (make-string name-width #\space) out)))
              (loop (cdr lines))))))))
