#!/bin/bash

set -o xtrace
set -o errexit

function maybe_mv () {
    if [ -e "$1" ]; then
        mv $1 $2
    fi
}

TEMPSCM=${TEMPSCM:-${HOME}/package-temp.scm}

# The nightly builds use svn checkout instead of svn export. Thus you
# need to remove the .svn directories that are littered in the tree.
find . -name .svn -type d | xargs rm -rf

# Remove README-COMMON-LARCENY.txt from the non Common Larceny
# distributions; make it README-FIRST.txt in Common Larceny.
if [ -e Larceny.fasl ]; then
    maybe_mv README-COMMON-LARCENY.txt README-FIRST.txt
    maybe_mv dotnet.heap.exe CommonLarceny.exe

    # Common Larceny needs some files from src to be set aside and then
    # restored:
    for file in src/Build/nbuild-param \
                src/Lib/Common/toplevel \
                src/Lib/Arch/IL/toplevel-target; do
        mkdir -p aside/`dirname $file`
        for ext in sch fasl exe; do
            maybe_mv $file.$ext aside/$file.$ext
        done
    done
else
    rm -f README-COMMON-LARCENY.txt
fi

# Remove the src directory, since that's not part of the binary distribution.
rm -rf src

# Remove the test directory, since that's not part of the binary distribution.
rm -rf test

# Remove the bin directory, since we don't use that yet
rm -rf bin

# Remove the setup script, since that's confusing
rm -f setup.sch

# Remove the larceny-np script, since that's confusing
if [ -e larceny.np ]; then
    rm -f larceny-np
fi

# Remove the include directory from the non-Petit distributions.
if [ ! -e petit.bin ] && [ ! -e petit-larceny.bin ] && [ ! -e petit.bin.exe ];
  then
    rm -rf include
fi

# For Petit:
if [ -e petit.bin ] || [ -e petit-larceny.bin ] || [ -e petit.bin.exe ]
#    remove the .o files
then find . -name '*.o' -type f | xargs rm -f
#    remove the generated .c files
     rm -f petit.bin.c petit-larceny.bin.c twobit.bin.c HEAPDATA.c
#      (this loop detects Scheme->C generated files)
     for f in `find . -name '*.c' | sed -e 's/.c$//' ` ; do 
	 if [ -e $f.sch ] ; then rm $f.c; fi; 
     done
fi

# For Common Larceny:
if [ -e Larceny.fasl ]; then
    mv aside/src .
    rmdir aside

    find . -name '*.lap'        \
        -o -name '*.lop'        \
        -o -name '*.manifest'   \
        -o -name '*.il'         \
        -o -name '*.code-il'    \
        -o -name '*.asm-il'     \
        | xargs rm -f
fi

# For systems with FFI support, we want to compile certain libraries
# that use the foreign-ctools library ahead of time.
#    (Felix is not going to do this for Petit systems for v0.94
#    because it is not clear if we can safely distribute the .so files
#    that compile-file on Petit Larceny generates.  So basically we're
#    just doing it for the native distributions.)
if [ -e larceny.bin ] || [ -e larceny.bin.exe ]
then 
# The important files for the v0.94 release is
# lib/Experimental/socket.sch, lib/Experimental/unix.sch, and
# lib/Standard/file-system.sch, because Snow relies on them for
# directory listing and tcpip support.
#
# These files tend to assume that their syntax dependencies will be
# handled automagically by require, so the safest way to compile them
# is to first load the file (so that the syntactic environment will be
# extended with any necessary dependencies) and then compile the file.
cat > ${TEMPSCM} <<EOF
(for-each (lambda (f) (load f) (compile-file f)) 
          (list "lib/Experimental/socket.sch" 
                "lib/Experimental/unix.sch" 
                "lib/Standard/file-system.sch"))
(exit)
EOF
    ./larceny -- ${TEMPSCM}

# The important files for the v0.95 release are the ERR5RS/R6RS
# standard libraries.  We have documentation on how to build them in
# doc/HOWTO-BUILD; the below is adapted from the steps there.
cat > ${TEMPSCM} <<EOF
(current-directory "lib/R6RS")
(require 'r6rsmode)
(larceny:compile-r6rs-runtime)
(exit)
EOF
    ./larceny -- ${TEMPSCM}

fi

# Files generated by foreign-ctools.  (Arguably foreign-ctools should
# be cleaning up after itself.)
rm -f larceny-c-info.c larceny-c-info-output larceny-c-info
