; Copyright 1998 Lars T Hansen.
;
; $Id: macro-expand.sch 2869 2006-04-21 17:43:53Z pnkfelix $
;
; Macro expander interface for the interpreter and the top-level
; environment.  This file is loaded after Twobit's macro expander.

($$trace "macro-expand")

; The procedure stored in MACRO-EXPANDER takes an expression and an
; environment and returns the expanded expression.  Normally
; user code does not install a macro expander; the expander must
; produce the same output as Larceny's normal expander.

(define macro-expander
  (make-parameter "macro-expander"
                  (lambda (form environment)
                    (twobit-expand form (environment-syntax-environment environment)))
                  procedure?))

; Exported to the user environment.

(define (toplevel-macro-expand expr . rest)
  (let ((env (if (null? rest)
                 (interaction-environment)
                 (car rest))))
    (make-readable
     ((macro-expander) expr env))))

; TWOBIT-SORT is used by Twobit's macro expander.

(define (twobit-sort less? list)
  (sort list less?))

; These names are generated by the macro expander.

(define name:CAR '.car)
(define name:CDR '.cdr)
(define name:CALL '.call)
  
; eof

