(define (map/separated item-proc separator-proc items)
  (if (null? items) 
      '()
      (cons (item-proc (car items))
            (let loop ((args (cdr items)))
              (if (null? args) 
                  '()
                  (cons (separator-proc)
                        (cons (item-proc (car args))
                              (loop (cdr args)))))))))

(define (for-each/separated item-proc separator-proc items)
  (if (pair? items) 
      (begin
        (item-proc (car items))
        (let loop ((args (cdr items)))
          (if (pair? args)
              (begin
                (separator-proc)
                (item-proc (car args))
                (loop (cdr args))))))))

(define (read/map f)
  (let ((next (read)))
    (if (eof-object? next)
        '()
        (cons (f next) (read/map f)))))

(define (read/for-each f)
  (let ((next (read)))
    (if (eof-object? next)
        (unspecified)
        (begin (f next) (read/map f)))))

;; Growable vector (see util-structs.sch)

(define (make-gvector default)
  (make-growable-vector (make-vector 8 default) default))
(define (gvector-ref gv i)
  (ensure-gvector-length gv (+ 1 i))
  (vector-ref (growable-vector.elements gv) i))
(define (gvector-set! gv i value)
  (ensure-gvector-length gv (+ 1 i))
  (vector-set! (growable-vector.elements gv) i value))
(define (ensure-gvector-length gv size)
  (let ((elements (growable-vector.elements gv)))
    (let loop ((target-size (vector-length elements)))
      (if (< target-size size)
          (loop (* 2 target-size))
          (growable-vector.elements! 
           gv
           (vector-copy-from-to elements
                                (make-vector target-size (growable-vector.default gv))
                                (vector-length elements)))))))
(define (vector-copy-from-to src dst len)
  (let loop ((i 0))
    (if (< i len)
        (begin (vector-set! dst i (vector-ref src i))
               (loop (+ i 1)))
        dst)))
(define (gvector-length gv)
  (vector-length (growable-vector.elements gv)))
