; Portions  International Organization for Standardization 1986
; Permission to copy in any form is granted for use with
; conforming SGML systems and applications as defined in
; ISO 8879, provided this notice is included in all copies.

; Pilfered from the HTML 4.01 spec.

(define html-entities
  '(("quot" 34)	     ; "
    ("amp" 38)       ; &
    ("lt" 60)        ; <
    ("gt" 62)        ; >
    ("nbsp" 160)     ; no-break space = non-breaking space
    ("iexcl" 161)    ; inverted exclamation mark
    ("cent" 162)     ; cent sign
    ("pound" 163)    ; pound sign
    ("curren" 164)   ; currency sign
    ("yen" 165)	     ; yen sign = yuan sign
    ("brvbar" 166)   ; broken bar = broken vertical bar
    ("sect" 167)     ; section sign
    ("uml" 168)	     ; diaeresis = spacing diaeresis
    ("copy" 169)     ; copyright sign
    ("ordf" 170)     ; feminine ordinal indicator
    ("laquo" 171)    ; left-pointing double angle quotation mark = left pointing guillemet
    ("not" 172)	     ; not sign
    ("shy" 173)	     ; soft hyphen = discretionary hyphen
    ("reg" 174)	     ; registered sign = registered trade mark sign
    ("macr" 175)     ; macron = spacing macron = overline = APL overbar
    ("deg" 176)	     ; degree sign
    ("plusmn" 177)   ; plus-minus sign = plus-or-minus sign
    ("sup2" 178)     ; superscript two = superscript digit two = squared
    ("sup3" 179)     ; superscript three = superscript digit three = cubed
    ("acute" 180)    ; acute accent = spacing acute
    ("micro" 181)    ; micro sign
    ("para" 182)     ; pilcrow sign = paragraph sign
    ("middot" 183)   ; middle dot = Georgian comma = Greek middle dot
    ("cedil" 184)    ; cedilla = spacing cedilla
    ("sup1" 185)     ; superscript one = superscript digit one
    ("ordm" 186)     ; masculine ordinal indicator
    ("raquo" 187)    ; right-pointing double angle quotation mark = right pointing guillemet
    ("frac14" 188)   ; vulgar fraction one quarter = fraction one quarter
    ("frac12" 189)   ; vulgar fraction one half = fraction one half
    ("frac34" 190)   ; vulgar fraction three quarters = fraction three quarters
    ("iquest" 191)   ; inverted question mark = turned question mark
    ("Agrave" 192)   ; latin capital letter A with grave = latin capital letter A grave
    ("Aacute" 193)   ; latin capital letter A with acute
    ("Acirc" 194)    ; latin capital letter A with circumflex
    ("Atilde" 195)   ; latin capital letter A with tilde
    ("Auml" 196)     ; latin capital letter A with diaeresis
    ("Aring" 197)    ; latin capital letter A with ring above = latin capital letter A ring
    ("AElig" 198)    ; latin capital letter AE = latin capital ligature AE
    ("Ccedil" 199)   ; latin capital letter C with cedilla
    ("Egrave" 200)   ; latin capital letter E with grave
    ("Eacute" 201)   ; latin capital letter E with acute
    ("Ecirc" 202)    ; latin capital letter E with circumflex
    ("Euml" 203)     ; latin capital letter E with diaeresis
    ("Igrave" 204)   ; latin capital letter I with grave
    ("Iacute" 205)   ; latin capital letter I with acute
    ("Icirc" 206)    ; latin capital letter I with circumflex
    ("Iuml" 207)     ; latin capital letter I with diaeresis
    ("ETH" 208)	     ; latin capital letter ETH
    ("Ntilde" 209)   ; latin capital letter N with tilde
    ("Ograve" 210)   ; latin capital letter O with grave
    ("Oacute" 211)   ; latin capital letter O with acute
    ("Ocirc" 212)    ; latin capital letter O with circumflex
    ("Otilde" 213)   ; latin capital letter O with tilde
    ("Ouml" 214)     ; latin capital letter O with diaeresis
    ("times" 215)    ; multiplication sign
    ("Oslash" 216)   ; latin capital letter O with stroke = latin capital letter O slash
    ("Ugrave" 217)   ; latin capital letter U with grave
    ("Uacute" 218)   ; latin capital letter U with acute
    ("Ucirc" 219)    ; latin capital letter U with circumflex
    ("Uuml" 220)     ; latin capital letter U with diaeresis
    ("Yacute" 221)   ; latin capital letter Y with acute
    ("THORN" 222)    ; latin capital letter THORN
    ("szlig" 223)    ; latin small letter sharp s = es
    ("agrave" 224)   ; latin small letter a with grave = latin small letter a grave
    ("aacute" 225)   ; latin small letter a with acute
    ("acirc" 226)    ; latin small letter a with circumflex
    ("atilde" 227)   ; latin small letter a with tilde
    ("auml" 228)     ; latin small letter a with diaeresis
    ("aring" 229)    ; latin small letter a with ring above = latin small letter a ring
    ("aelig" 230)    ; latin small letter ae = latin small ligature ae
    ("ccedil" 231)   ; latin small letter c with cedilla
    ("egrave" 232)   ; latin small letter e with grave
    ("eacute" 233)   ; latin small letter e with acute
    ("ecirc" 234)    ; latin small letter e with circumflex
    ("euml" 235)     ; latin small letter e with diaeresis
    ("igrave" 236)   ; latin small letter i with grave
    ("iacute" 237)   ; latin small letter i with acute
    ("icirc" 238)    ; latin small letter i with circumflex
    ("iuml" 239)     ; latin small letter i with diaeresis
    ("eth" 240)	     ; latin small letter eth
    ("ntilde" 241)   ; latin small letter n with tilde
    ("ograve" 242)   ; latin small letter o with grave
    ("oacute" 243)   ; latin small letter o with acute
    ("ocirc" 244)    ; latin small letter o with circumflex
    ("otilde" 245)   ; latin small letter o with tilde
    ("ouml" 246)     ; latin small letter o with diaeresis
    ("divide" 247)   ; division sign
    ("oslash" 248)   ; latin small letter o with stroke, = latin small letter o slash
    ("ugrave" 249)   ; latin small letter u with grave
    ("uacute" 250)   ; latin small letter u with acute
    ("ucirc" 251)    ; latin small letter u with circumflex
    ("uuml" 252)     ; latin small letter u with diaeresis
    ("yacute" 253)   ; latin small letter y with acute
    ("thorn" 254)    ; latin small letter thorn
    ("yuml" 255)))   ; latin small letter y with diaeresis

(define (html-entity-equivalent name)
  (cond ((char=? (string-ref name 0) #\#)
	 (let ((n (if (char-ci=? (string-ref name 1) #\x)
		      (string->number (substring name 2 (string-length name))
				      16)
		      (string->number (substring name 1 (string-length name))
				      10))))
	   (if (and n (< n 256))
	       (string (integer->char n))
	       (string-append "&" name ";"))))
	((assoc name html-entities)
	 => (lambda (probe)
	      (string (integer->char (cadr probe)))))
	(else
	 (string-append "&" name ";"))))
	 
