;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; $Id: reader.sch 6172 2009-04-06 02:19:13Z will $
;
; Prototype parser for R6RS syntax with Larceny extensions.
;
; The scanner's state machine and the recursive descent parser
; were generated by Will Clinger's LexGen and ParseGen, so the
; parser can be extended or customized by regenerating those
; parts.
;
; LexGen and ParseGen are available at
; http://www.ccs.neu.edu/home/will/Research/SW2006/*.tar.gz
;
; FIXME: some things are not yet implemented:
;
;     #!...!#    (unimportant)
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; FIXME:
;
; This file contains several R6RS notations that could cause
; problems for cross-compilation:
;
; #\nul, #\backspace, #\tab, #\linefeed, #\vtab, and #\page.
;
; Larceny v0.93 and MzScheme v370 recognizes those notations.
;
; MzScheme v370 does not recognize #\alarm, #\esc, or #\delete,
; so they have been removed from this file.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Larceny -- Scheme reader.
;
; install-reader takes no arguments
;
; install-reader assigns the following variables:
;
;       read
;       readtable-ref
;       readtable-set!
;       datum->source-location
;       datum-source-locations-clear!
;
; FIXME:  The readtable-ref and readtable-set! operations don't
; do anything except warn that they don't do anything.
;
; FIXME:  The old interface for obtaining source code locations,
; consisting of datum->source-location and datum->source-locations-clear!,
; is no longer supported.  The new interface is
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Source code locations.
;
;     (get-datum-with-source-locations input-port keep-source-locations?)
;
; If keep-source-locations? is false, then this procedure behaves
; just like get-datum.
;
; If keep-source-locations? is true, then this procedure returns
; two values.  The first return value is the value that would be
; returned by get-datum.  The second return value is an assocation
; list that maps every subform to the half-open interval consisting
; of its starting and ending positions, where each position is a
; vector of the form #(i j k), where
;
;     i is the 0-origin character position
;     j is the 0-origin line number
;     k is the 0-origin column number

($$trace "reader")

(define (install-reader)

  (define (deprecated-error who)
    (assertion-violation who "operation no longer supported"))

  (define (deprecated-warning who)
    (display "WARNING: " (current-error-port))
    (display who (current-error-port))
    (display " is no longer supported" (current-error-port)))

  (set! read
        (lambda p
          (let ((p (if (pair? p)
                       (car p)
                       (current-input-port))))
            (get-datum p))))

  (set! readtable-ref
        (lambda (char)
          (deprecated-error 'readtable-ref)))
 
  (set! readtable-set!
        (lambda (char l)
          (deprecated-error 'readtable-set!)))

  (set! datum->source-location
    (lambda (obj)
      (deprecated-warning 'datum->source-location)
      0))

  (set! datum-source-locations-clear!
    (lambda ()
      (deprecated-warning 'datum-source-locations-clear!)
      #t))
 
  #t)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Source code locations.
;
; Represented as a vector of three elements #(i j k) where
;     i is the 0-origin character position
;     j is the 0-origin line number
;     k is the 0-origin column number
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (make-source-location input-port)
  (let* ((i (port-position-nocache input-port))
         (j (port-lines-read input-port))
         (k (- i (port-line-start input-port))))
    (vector i j k)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; This is the real parser.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (get-datum input-port)
  (get-datum-with-source-locations input-port #f))

(define (get-datum-with-source-locations input-port keep-source-locations?)

  ; Constants and local variables.

  (let* (; Constants.

         ; initial length of string_accumulator

         (initial_accumulator_length 64)

         ; Encodings of error messages.

         (errLongToken 1)                 ; extremely long token
         (errIncompleteToken 2)      ; any lexical error, really
         (errIllegalHexEscape 3)                 ; illegal \x...
         (errIllegalNamedChar 4)                 ; illegal #\...
         (errIllegalString 5)                   ; illegal string
         (errIllegalSymbol 6)                   ; illegal symbol
         (errNoDelimiter 7)      ; missing delimiter after token
         (errSquareBracket 8)     ; square bracket when disabled
         (errBug 9)            ; bug in reader, shouldn't happen
         (errLexGenBug 10)                         ; can't happen

         ; Named characters that MzScheme doesn't yet recognize.

         (char:alarm  (integer->char 7))
         (char:esc    (integer->char 27))
         (char:delete (integer->char 127))

         ; Important but unnamed non-Ascii characters.

         (char:nel    (integer->char #x85))
         (char:ls     (integer->char #x2028))

         ; State for one-token buffering in lexical analyzer.

         (kindOfNextToken 'z1)      ; valid iff nextTokenIsReady
         (nextTokenIsReady #f)

         (tokenValue "")  ; string associated with current token

         ; A string buffer for the characters of the current token.
         ; Resized as necessary.

         (string_accumulator (make-string initial_accumulator_length))

         ; Number of characters in string_accumulator.

         (string_accumulator_length 0)

         ; Source location for the start of the current token.

         (locationStart
          (if keep-source-locations?
              (make-source-location input-port)
              '#(0 0 0)))

         ; Stack of source locations.

         (locationStack '())

         ; Association list of data and their source locations.

         (locations '())

        )

    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ;
    ; Hand-coding scanner0 makes a small but worthwhile difference.
    ;
    ; The most common characters are spaces, parentheses, newlines,
    ; semicolons, and lower case Ascii letters.
    ;
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  
    ; Scanning for the start of a token.

    (define (scanner0)
      (define (loop c)
        (cond ((not (char? c))
               (accept 'eofobj))
              ((or (char=? c #\space)
                   (char=? c #\newline))
               (read-char input-port)
               (loop (peek-char input-port)))
              ((char=? c #\;)
               (scanner1))
              (else
               (if keep-source-locations?
                   (set! locationStart
                         (make-source-location input-port)))
               (state0 c))))
      (loop (peek-char input-port)))

    ; Consuming a semicolon comment.

    (define (scanner1)
      (define (loop c)
        (cond ((not (char? c))
               (accept 'eofobj))
              ((char=? c #\newline)
               (scanner0))
              (else
               (loop (read-char input-port)))))
      (loop (read-char input-port)))
  
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ;
    ; LexGen generated the code for the state machine.
    ;
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  
  (define (state0 c)
    (case c
      ((#\`) (consumeChar) (accept 'backquote))
      ((#\') (consumeChar) (accept 'quote))
      ((#\]) (consumeChar) (accept 'rbracket))
      ((#\[) (consumeChar) (accept 'lbracket))
      ((#\)) (consumeChar) (accept 'rparen))
      ((#\() (consumeChar) (accept 'lparen))
      ((#\tab #\newline #\vtab #\page #\return #\space)
       (consumeChar)
       (begin
         (set! string_accumulator_length 0)
         (state0 (scanChar))))
      ((#\;) (consumeChar) (state201 (scanChar)))
      ((#\#) (consumeChar) (state200 (scanChar)))
      ((#\0 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state131 (scanChar)))
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\@
        #\|)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\+) (consumeChar) (state61 (scanChar)))
      ((#\-) (consumeChar) (state60 (scanChar)))
      ((#\1) (consumeChar) (state57 (scanChar)))
      ((#\.) (consumeChar) (state56 (scanChar)))
      ((#\,) (consumeChar) (state5 (scanChar)))
      ((#\") (consumeChar) (state4 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (> (char->integer c) 127)
                   (let ((cat (char-general-category c)))
                     (memq cat
                           '(Lu Ll
                                Lt
                                Lm
                                Lo
                                Mn
                                Nl
                                No
                                Pd
                                Pc
                                Po
                                Sc
                                Sm
                                Sk
                                So
                                Co)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if (eof-object? c)
               (begin (consumeChar) (accept 'eofobj))
               (if ((lambda (c) (and (char? c) (char-whitespace? c)))
                    c)
                   (begin
                     (consumeChar)
                     (begin
                       (set! string_accumulator_length 0)
                       (state0 (scanChar))))
                   (if ((lambda (c)
                          (and (char? c) (char=? c (integer->char 133))))
                        c)
                       (begin
                         (consumeChar)
                         (begin
                           (set! string_accumulator_length 0)
                           (state0 (scanChar))))
                       (scannerError errIncompleteToken))))))))
  (define (state1 c)
    (case c
      ((#\") (consumeChar) (accept 'string))
      ((#\newline #\return)
       (consumeChar)
       (state4 (scanChar)))
      ((#\\) (consumeChar) (state3 (scanChar)))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state1 (scanChar)))
      (else
       (if (char? c)
           (begin (consumeChar) (state4 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (char=? c (integer->char 8232))))
                c)
               (begin (consumeChar) (state4 (scanChar)))
               (if ((lambda (c)
                      (and (char? c) (char=? c (integer->char 133))))
                    c)
                   (begin (consumeChar) (state4 (scanChar)))
                   (scannerError errIncompleteToken)))))))
  (define (state2 c)
    (case c
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state1 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state3 c)
    (case c
      ((#\a
        #\b
        #\t
        #\n
        #\v
        #\f
        #\r
        #\"
        #\\
        #\newline
        #\return
        #\space)
       (consumeChar)
       (state4 (scanChar)))
      ((#\x) (consumeChar) (state2 (scanChar)))
      (else
       (if (char? c)
           (begin (consumeChar) (state4 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (char=? c (integer->char 8232))))
                c)
               (begin (consumeChar) (state4 (scanChar)))
               (if ((lambda (c)
                      (and (char? c) (char=? c (integer->char 133))))
                    c)
                   (begin (consumeChar) (state4 (scanChar)))
                   (scannerError errIncompleteToken)))))))
  (define (state4 c)
    (case c
      ((#\") (consumeChar) (accept 'string))
      ((#\newline #\return)
       (consumeChar)
       (state4 (scanChar)))
      ((#\\) (consumeChar) (state3 (scanChar)))
      (else
       (if (char? c)
           (begin (consumeChar) (state4 (scanChar)))
           (if ((lambda (c)
                  (and (char? c) (char=? c (integer->char 8232))))
                c)
               (begin (consumeChar) (state4 (scanChar)))
               (if ((lambda (c)
                      (and (char? c) (char=? c (integer->char 133))))
                    c)
                   (begin (consumeChar) (state4 (scanChar)))
                   (scannerError errIncompleteToken)))))))
  (define (state5 c)
    (case c
      ((#\@) (consumeChar) (accept 'splicing))
      (else (accept 'comma))))
  (define (state6 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\f) (consumeChar) (state10 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state7 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\n) (consumeChar) (state6 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'number))))))
  (define (state8 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\i #\I) (consumeChar) (state29 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state9 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\0) (consumeChar) (state8 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state10 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\.) (consumeChar) (state9 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state11 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\n) (consumeChar) (state10 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state12 c)
    (case c
      ((#\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\a) (consumeChar) (state11 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state13 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state20 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state14 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\i #\I) (consumeChar) (state29 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state14 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state15 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state14 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state16 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\i #\I) (consumeChar) (state29 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state16 (scanChar)))
      ((#\|) (consumeChar) (state15 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state17 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state16 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state18 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\+ #\-) (consumeChar) (state17 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state16 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state19 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state161 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state160 (scanChar)))
      ((#\|) (consumeChar) (state157 (scanChar)))
      ((#\%) (consumeChar) (state68 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state20 c)
    (case c
      ((#\a
        #\b
        #\c
        #\g
        #\h
        #\j
        #\k
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\G
        #\H
        #\J
        #\K
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\i #\I) (consumeChar) (state29 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state20 (scanChar)))
      ((#\#) (consumeChar) (state19 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state18 (scanChar)))
      ((#\|) (consumeChar) (state15 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state21 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state162 (scanChar)))
      ((#\%) (consumeChar) (state68 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state22 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\i #\I) (consumeChar) (state29 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state22 (scanChar)))
      ((#\#) (consumeChar) (state21 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state23 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state22 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state24 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state165 (scanChar)))
      ((#\/) (consumeChar) (state164 (scanChar)))
      ((#\.) (consumeChar) (state161 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state160 (scanChar)))
      ((#\|) (consumeChar) (state157 (scanChar)))
      ((#\%) (consumeChar) (state68 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state25 c)
    (case c
      ((#\a
        #\b
        #\c
        #\g
        #\h
        #\j
        #\k
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\G
        #\H
        #\J
        #\K
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\i #\I) (consumeChar) (state29 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state25 (scanChar)))
      ((#\#) (consumeChar) (state24 (scanChar)))
      ((#\/) (consumeChar) (state23 (scanChar)))
      ((#\.) (consumeChar) (state20 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state18 (scanChar)))
      ((#\|) (consumeChar) (state15 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state26 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\j
        #\k
        #\l
        #\m
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\+
        #\-
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\I) (consumeChar) (state29 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state25 (scanChar)))
      ((#\.) (consumeChar) (state13 (scanChar)))
      ((#\n) (consumeChar) (state12 (scanChar)))
      ((#\i) (consumeChar) (state7 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state27 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\f) (consumeChar) (state31 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state28 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\n) (consumeChar) (state27 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state29 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'number))))))
  (define (state30 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\0) (consumeChar) (state29 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state31 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\.) (consumeChar) (state30 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state32 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\n) (consumeChar) (state31 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state33 c)
    (case c
      ((#\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\a) (consumeChar) (state32 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state34 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state41 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state35 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state35 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'number))))))
  (define (state36 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state35 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state37 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state37 (scanChar)))
      ((#\|) (consumeChar) (state36 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'number))))))
  (define (state38 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state37 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state39 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\+ #\-) (consumeChar) (state38 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state37 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state40 c)
    (case c
      ((#\#) (consumeChar) (state181 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state180 (scanChar)))
      ((#\|) (consumeChar) (state177 (scanChar)))
      ((#\%) (consumeChar) (state68 (scanChar)))
      (else (accept 'number))))
  (define (state41 c)
    (case c
      ((#\a
        #\b
        #\c
        #\g
        #\h
        #\i
        #\j
        #\k
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\G
        #\H
        #\I
        #\J
        #\K
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state41 (scanChar)))
      ((#\#) (consumeChar) (state40 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state39 (scanChar)))
      ((#\|) (consumeChar) (state36 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'number))))))
  (define (state42 c)
    (case c
      ((#\#) (consumeChar) (state182 (scanChar)))
      ((#\%) (consumeChar) (state68 (scanChar)))
      (else (accept 'number))))
  (define (state43 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state43 (scanChar)))
      ((#\#) (consumeChar) (state42 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'number))))))
  (define (state44 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state43 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state45 c)
    (case c
      ((#\#) (consumeChar) (state185 (scanChar)))
      ((#\/) (consumeChar) (state184 (scanChar)))
      ((#\.) (consumeChar) (state181 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state180 (scanChar)))
      ((#\|) (consumeChar) (state177 (scanChar)))
      ((#\%) (consumeChar) (state68 (scanChar)))
      (else (accept 'number))))
  (define (state46 c)
    (case c
      ((#\a
        #\b
        #\c
        #\g
        #\h
        #\i
        #\j
        #\k
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\G
        #\H
        #\I
        #\J
        #\K
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\+
        #\-
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state46 (scanChar)))
      ((#\#) (consumeChar) (state45 (scanChar)))
      ((#\/) (consumeChar) (state44 (scanChar)))
      ((#\.) (consumeChar) (state41 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state39 (scanChar)))
      ((#\|) (consumeChar) (state36 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'number))))))
  (define (state47 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\j
        #\k
        #\l
        #\m
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\+
        #\-
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state46 (scanChar)))
      ((#\.) (consumeChar) (state34 (scanChar)))
      ((#\n) (consumeChar) (state33 (scanChar)))
      ((#\i) (consumeChar) (state28 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state48 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\+ #\-) (consumeChar) (state47 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state46 (scanChar)))
      ((#\.) (consumeChar) (state34 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state49 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\.)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state49 (scanChar)))
      ((#\@) (consumeChar) (state48 (scanChar)))
      ((#\+ #\-) (consumeChar) (state26 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'number))))))
  (define (state50 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state49 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state51 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\.)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state51 (scanChar)))
      ((#\|) (consumeChar) (state50 (scanChar)))
      ((#\@) (consumeChar) (state48 (scanChar)))
      ((#\+ #\-) (consumeChar) (state26 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'number))))))
  (define (state52 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state51 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state53 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\+ #\-) (consumeChar) (state52 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state51 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state54 c)
    (case c
      ((#\@) (consumeChar) (state188 (scanChar)))
      ((#\+ #\-) (consumeChar) (state167 (scanChar)))
      ((#\#) (consumeChar) (state126 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state125 (scanChar)))
      ((#\|) (consumeChar) (state122 (scanChar)))
      ((#\%) (consumeChar) (state68 (scanChar)))
      (else (accept 'number))))
  (define (state55 c)
    (case c
      ((#\a
        #\b
        #\c
        #\g
        #\h
        #\i
        #\j
        #\k
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\G
        #\H
        #\I
        #\J
        #\K
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\.)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state55 (scanChar)))
      ((#\#) (consumeChar) (state54 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state53 (scanChar)))
      ((#\|) (consumeChar) (state50 (scanChar)))
      ((#\@) (consumeChar) (state48 (scanChar)))
      ((#\+ #\-) (consumeChar) (state26 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'number))))))
  (define (state56 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state55 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'period))))))
  (define (state57 c)
    (case c
      ((#\@) (consumeChar) (state188 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state131 (scanChar)))
      ((#\#) (consumeChar) (state130 (scanChar)))
      ((#\/) (consumeChar) (state129 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state125 (scanChar)))
      ((#\|) (consumeChar) (state122 (scanChar)))
      ((#\.) (consumeChar) (state120 (scanChar)))
      ((#\+ #\-) (consumeChar) (state58 (scanChar)))
      (else (accept 'number))))
  (define (state58 c)
    (case c
      ((#\I) (consumeChar) (accept 'number))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state166 (scanChar)))
      ((#\.) (consumeChar) (state154 (scanChar)))
      ((#\n) (consumeChar) (state153 (scanChar)))
      ((#\i) (consumeChar) (state148 (scanChar)))
      (else (accept 'id))))
  (define (state59 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state193 (scanChar)))
      ((#\#) (consumeChar) (state192 (scanChar)))
      ((#\/) (consumeChar) (state191 (scanChar)))
      ((#\@) (consumeChar) (state188 (scanChar)))
      ((#\-) (consumeChar) (state167 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state145 (scanChar)))
      ((#\|) (consumeChar) (state142 (scanChar)))
      ((#\.) (consumeChar) (state140 (scanChar)))
      ((#\+) (consumeChar) (state58 (scanChar)))
      (else (accept 'number))))
  (define (state60 c)
    (case c
      ((#\-) (consumeChar) (accept 'id))
      ((#\I) (consumeChar) (accept 'number))
      ((#\0 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state193 (scanChar)))
      ((#\.) (consumeChar) (state139 (scanChar)))
      ((#\n) (consumeChar) (state138 (scanChar)))
      ((#\i) (consumeChar) (state133 (scanChar)))
      ((#\: #\>) (consumeChar) (state68 (scanChar)))
      ((#\1) (consumeChar) (state59 (scanChar)))
      (else (accept 'id))))
  (define (state61 c)
    (case c
      ((#\I) (consumeChar) (accept 'number))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state193 (scanChar)))
      ((#\.) (consumeChar) (state139 (scanChar)))
      ((#\n) (consumeChar) (state138 (scanChar)))
      ((#\i) (consumeChar) (state133 (scanChar)))
      ((#\:) (consumeChar) (state68 (scanChar)))
      (else (accept 'id))))
  (define (state62 c)
    (case c
      ((#\" #\\) (consumeChar) (state63 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state63 c)
    (case c
      ((#\") (consumeChar) (accept 'xstring))
      ((#\\) (consumeChar) (state62 (scanChar)))
      (else (begin (consumeChar) (state63 (scanChar))))))
  (define (state64 c)
    (case c
      ((#\%) (consumeChar) (state68 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state65 c)
    (case c
      ((#\;) (consumeChar) (state68 (scanChar)))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state65 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state66 c)
    (case c
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state65 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state67 c)
    (case c
      ((#\x) (consumeChar) (state66 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c) (char<=? c (integer->char 127))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (scannerError errIncompleteToken)))))
  (define (state68 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\!
        #\$
        #\%
        #\&
        #\*
        #\/
        #\:
        #\<
        #\=
        #\>
        #\?
        #\^
        #\_
        #\~
        #\|
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\+
        #\-
        #\.
        #\@)
       (consumeChar)
       (state68 (scanChar)))
      ((#\\) (consumeChar) (state67 (scanChar)))
      ((#\#) (consumeChar) (state64 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c)
                   (let ((cat (char-general-category c)))
                     (memq cat '(Nd Mc Me)))))
            c)
           (begin (consumeChar) (state68 (scanChar)))
           (if ((lambda (c)
                  (and (char? c)
                       (> (char->integer c) 127)
                       (let ((cat (char-general-category c)))
                         (memq cat
                               '(Lu Ll
                                    Lt
                                    Lm
                                    Lo
                                    Mn
                                    Nl
                                    No
                                    Pd
                                    Pc
                                    Po
                                    Sc
                                    Sm
                                    Sk
                                    So
                                    Co)))))
                c)
               (begin (consumeChar) (state68 (scanChar)))
               (accept 'id))))))
  (define (state69 c)
    (case c
      ((#\@) (consumeChar) (accept 'unsyntaxsplicing))
      (else (accept 'unsyntax))))
  (define (state70 c)
    (case c
      ((#\() (consumeChar) (accept 'bvecstart))
      (else (scannerError errIncompleteToken))))
  (define (state71 c)
    (case c
      ((#\8) (consumeChar) (state70 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state72 c)
    (case c
      ((#\u) (consumeChar) (state71 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state73 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z)
       (consumeChar)
       (state73 (scanChar)))
      (else (accept 'character))))
  (define (state74 c)
    (case c
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state74 (scanChar)))
      (else (accept 'character))))
  (define (state75 c)
    (case c
      ((#\a #\b #\c #\d #\e #\f #\A #\B #\C #\D #\E #\F)
       (consumeChar)
       (state75 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state74 (scanChar)))
      ((#\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z)
       (consumeChar)
       (state73 (scanChar)))
      (else (accept 'character))))
  (define (state76 c)
    (case c
      ((#\x) (consumeChar) (state75 (scanChar)))
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z)
       (consumeChar)
       (state73 (scanChar)))
      (else
       (if (char? c)
           (begin (consumeChar) (accept 'character))
           (scannerError errIncompleteToken)))))
  (define (state77 c)
    (case c
      ((#\i #\I #\e #\E)
       (consumeChar)
       (state116 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state78 c)
    (case c
      ((#\+ #\-) (consumeChar) (state115 (scanChar)))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state83 (scanChar)))
      ((#\#) (consumeChar) (state77 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state79 c)
    (case c
      ((#\@) (consumeChar) (state109 (scanChar)))
      ((#\+ #\-) (consumeChar) (state103 (scanChar)))
      ((#\#) (consumeChar) (state79 (scanChar)))
      (else (accept 'number))))
  (define (state80 c)
    (case c
      ((#\@) (consumeChar) (state109 (scanChar)))
      ((#\+ #\-) (consumeChar) (state103 (scanChar)))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state80 (scanChar)))
      ((#\#) (consumeChar) (state79 (scanChar)))
      (else (accept 'number))))
  (define (state81 c)
    (case c
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state80 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state82 c)
    (case c
      ((#\@) (consumeChar) (state109 (scanChar)))
      ((#\+ #\-) (consumeChar) (state103 (scanChar)))
      ((#\#) (consumeChar) (state82 (scanChar)))
      ((#\/) (consumeChar) (state81 (scanChar)))
      (else (accept 'number))))
  (define (state83 c)
    (case c
      ((#\@) (consumeChar) (state109 (scanChar)))
      ((#\+ #\-) (consumeChar) (state103 (scanChar)))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state83 (scanChar)))
      ((#\#) (consumeChar) (state82 (scanChar)))
      ((#\/) (consumeChar) (state81 (scanChar)))
      (else (accept 'number))))
  (define (state84 c)
    (case c
      ((#\f) (consumeChar) (state88 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state85 c)
    (case c
      ((#\n) (consumeChar) (state84 (scanChar)))
      (else (accept 'number))))
  (define (state86 c)
    (case c
      ((#\i) (consumeChar) (accept 'number))
      ((#\@) (consumeChar) (state109 (scanChar)))
      ((#\+ #\-) (consumeChar) (state103 (scanChar)))
      (else (accept 'number))))
  (define (state87 c)
    (case c
      ((#\0) (consumeChar) (state86 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state88 c)
    (case c
      ((#\.) (consumeChar) (state87 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state89 c)
    (case c
      ((#\n) (consumeChar) (state88 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state90 c)
    (case c
      ((#\a) (consumeChar) (state89 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state91 c)
    (case c
      ((#\f) (consumeChar) (state95 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state92 c)
    (case c
      ((#\n) (consumeChar) (state91 (scanChar)))
      (else (accept 'number))))
  (define (state93 c)
    (case c
      ((#\i) (consumeChar) (accept 'number))
      (else (scannerError errIncompleteToken))))
  (define (state94 c)
    (case c
      ((#\0) (consumeChar) (state93 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state95 c)
    (case c
      ((#\.) (consumeChar) (state94 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state96 c)
    (case c
      ((#\n) (consumeChar) (state95 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state97 c)
    (case c
      ((#\a) (consumeChar) (state96 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state98 c)
    (case c
      ((#\i) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state98 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state99 c)
    (case c
      ((#\i) (consumeChar) (accept 'number))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state99 (scanChar)))
      ((#\#) (consumeChar) (state98 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state100 c)
    (case c
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state99 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state101 c)
    (case c
      ((#\i) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state101 (scanChar)))
      ((#\/) (consumeChar) (state100 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state102 c)
    (case c
      ((#\i) (consumeChar) (accept 'number))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state102 (scanChar)))
      ((#\#) (consumeChar) (state101 (scanChar)))
      ((#\/) (consumeChar) (state100 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state103 c)
    (case c
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state102 (scanChar)))
      ((#\n) (consumeChar) (state97 (scanChar)))
      ((#\i) (consumeChar) (state92 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state104 c)
    (case c
      ((#\#) (consumeChar) (state182 (scanChar)))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state104 (scanChar)))
      (else (accept 'number))))
  (define (state105 c)
    (case c
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state104 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state106 c)
    (case c
      ((#\#) (consumeChar) (state106 (scanChar)))
      ((#\/) (consumeChar) (state105 (scanChar)))
      (else (accept 'number))))
  (define (state107 c)
    (case c
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state107 (scanChar)))
      ((#\#) (consumeChar) (state106 (scanChar)))
      ((#\/) (consumeChar) (state105 (scanChar)))
      (else (accept 'number))))
  (define (state108 c)
    (case c
      ((#\n) (consumeChar) (state173 (scanChar)))
      ((#\i) (consumeChar) (state169 (scanChar)))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state107 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state109 c)
    (case c
      ((#\+ #\-) (consumeChar) (state108 (scanChar)))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state107 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state110 c)
    (case c
      ((#\i) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state110 (scanChar)))
      ((#\@) (consumeChar) (state109 (scanChar)))
      ((#\+ #\-) (consumeChar) (state103 (scanChar)))
      (else (accept 'number))))
  (define (state111 c)
    (case c
      ((#\i) (consumeChar) (accept 'number))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state111 (scanChar)))
      ((#\#) (consumeChar) (state110 (scanChar)))
      ((#\@) (consumeChar) (state109 (scanChar)))
      ((#\+ #\-) (consumeChar) (state103 (scanChar)))
      (else (accept 'number))))
  (define (state112 c)
    (case c
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state111 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state113 c)
    (case c
      ((#\i) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state113 (scanChar)))
      ((#\/) (consumeChar) (state112 (scanChar)))
      ((#\@) (consumeChar) (state109 (scanChar)))
      ((#\+ #\-) (consumeChar) (state103 (scanChar)))
      (else (accept 'number))))
  (define (state114 c)
    (case c
      ((#\i) (consumeChar) (accept 'number))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state114 (scanChar)))
      ((#\#) (consumeChar) (state113 (scanChar)))
      ((#\/) (consumeChar) (state112 (scanChar)))
      ((#\@) (consumeChar) (state109 (scanChar)))
      ((#\+ #\-) (consumeChar) (state103 (scanChar)))
      (else (accept 'number))))
  (define (state115 c)
    (case c
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state114 (scanChar)))
      ((#\n) (consumeChar) (state90 (scanChar)))
      ((#\i) (consumeChar) (state85 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state116 c)
    (case c
      ((#\+ #\-) (consumeChar) (state115 (scanChar)))
      ((#\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F)
       (consumeChar)
       (state83 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state117 c)
    (case c
      ((#\d #\D) (consumeChar) (state195 (scanChar)))
      ((#\b #\B #\o #\O #\x #\X)
       (consumeChar)
       (state116 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state118 c)
    (case c
      ((#\+ #\-) (consumeChar) (state194 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state131 (scanChar)))
      ((#\.) (consumeChar) (state119 (scanChar)))
      ((#\#) (consumeChar) (state117 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state119 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state120 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state120 c)
    (case c
      ((#\@) (consumeChar) (state188 (scanChar)))
      ((#\+ #\-) (consumeChar) (state167 (scanChar)))
      ((#\#) (consumeChar) (state126 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state125 (scanChar)))
      ((#\|) (consumeChar) (state122 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state120 (scanChar)))
      (else (accept 'number))))
  (define (state121 c)
    (case c
      ((#\@) (consumeChar) (state188 (scanChar)))
      ((#\+ #\-) (consumeChar) (state167 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state121 (scanChar)))
      (else (accept 'number))))
  (define (state122 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state121 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state123 c)
    (case c
      ((#\@) (consumeChar) (state188 (scanChar)))
      ((#\+ #\-) (consumeChar) (state167 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state123 (scanChar)))
      ((#\|) (consumeChar) (state122 (scanChar)))
      (else (accept 'number))))
  (define (state124 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state123 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state125 c)
    (case c
      ((#\+ #\-) (consumeChar) (state124 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state123 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state126 c)
    (case c
      ((#\@) (consumeChar) (state188 (scanChar)))
      ((#\+ #\-) (consumeChar) (state167 (scanChar)))
      ((#\#) (consumeChar) (state126 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state125 (scanChar)))
      ((#\|) (consumeChar) (state122 (scanChar)))
      (else (accept 'number))))
  (define (state127 c)
    (case c
      ((#\@) (consumeChar) (state188 (scanChar)))
      ((#\+ #\-) (consumeChar) (state167 (scanChar)))
      ((#\#) (consumeChar) (state127 (scanChar)))
      (else (accept 'number))))
  (define (state128 c)
    (case c
      ((#\@) (consumeChar) (state188 (scanChar)))
      ((#\+ #\-) (consumeChar) (state167 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state128 (scanChar)))
      ((#\#) (consumeChar) (state127 (scanChar)))
      (else (accept 'number))))
  (define (state129 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state128 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state130 c)
    (case c
      ((#\@) (consumeChar) (state188 (scanChar)))
      ((#\+ #\-) (consumeChar) (state167 (scanChar)))
      ((#\#) (consumeChar) (state130 (scanChar)))
      ((#\/) (consumeChar) (state129 (scanChar)))
      ((#\.) (consumeChar) (state126 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state125 (scanChar)))
      ((#\|) (consumeChar) (state122 (scanChar)))
      (else (accept 'number))))
  (define (state131 c)
    (case c
      ((#\@) (consumeChar) (state188 (scanChar)))
      ((#\+ #\-) (consumeChar) (state167 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state131 (scanChar)))
      ((#\#) (consumeChar) (state130 (scanChar)))
      ((#\/) (consumeChar) (state129 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state125 (scanChar)))
      ((#\|) (consumeChar) (state122 (scanChar)))
      ((#\.) (consumeChar) (state120 (scanChar)))
      (else (accept 'number))))
  (define (state132 c)
    (case c
      ((#\f) (consumeChar) (state136 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state133 c)
    (case c
      ((#\n) (consumeChar) (state132 (scanChar)))
      (else (accept 'number))))
  (define (state134 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\@) (consumeChar) (state188 (scanChar)))
      ((#\+ #\-) (consumeChar) (state167 (scanChar)))
      (else (accept 'number))))
  (define (state135 c)
    (case c
      ((#\0) (consumeChar) (state134 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state136 c)
    (case c
      ((#\.) (consumeChar) (state135 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state137 c)
    (case c
      ((#\n) (consumeChar) (state136 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state138 c)
    (case c
      ((#\a) (consumeChar) (state137 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state139 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state140 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state140 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\@) (consumeChar) (state188 (scanChar)))
      ((#\+ #\-) (consumeChar) (state167 (scanChar)))
      ((#\#) (consumeChar) (state146 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state145 (scanChar)))
      ((#\|) (consumeChar) (state142 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state140 (scanChar)))
      (else (accept 'number))))
  (define (state141 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\@) (consumeChar) (state188 (scanChar)))
      ((#\+ #\-) (consumeChar) (state167 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state141 (scanChar)))
      (else (accept 'number))))
  (define (state142 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state141 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state143 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\@) (consumeChar) (state188 (scanChar)))
      ((#\+ #\-) (consumeChar) (state167 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state143 (scanChar)))
      ((#\|) (consumeChar) (state142 (scanChar)))
      (else (accept 'number))))
  (define (state144 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state143 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state145 c)
    (case c
      ((#\+ #\-) (consumeChar) (state144 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state143 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state146 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\@) (consumeChar) (state188 (scanChar)))
      ((#\+ #\-) (consumeChar) (state167 (scanChar)))
      ((#\#) (consumeChar) (state146 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state145 (scanChar)))
      ((#\|) (consumeChar) (state142 (scanChar)))
      (else (accept 'number))))
  (define (state147 c)
    (case c
      ((#\f) (consumeChar) (state151 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state148 c)
    (case c
      ((#\n) (consumeChar) (state147 (scanChar)))
      (else (accept 'number))))
  (define (state149 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      (else (scannerError errIncompleteToken))))
  (define (state150 c)
    (case c
      ((#\0) (consumeChar) (state149 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state151 c)
    (case c
      ((#\.) (consumeChar) (state150 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state152 c)
    (case c
      ((#\n) (consumeChar) (state151 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state153 c)
    (case c
      ((#\a) (consumeChar) (state152 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state154 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state155 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state155 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state161 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state160 (scanChar)))
      ((#\|) (consumeChar) (state157 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state155 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state156 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state156 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state157 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state156 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state158 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state158 (scanChar)))
      ((#\|) (consumeChar) (state157 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state159 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state158 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state160 c)
    (case c
      ((#\+ #\-) (consumeChar) (state159 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state158 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state161 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state161 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state160 (scanChar)))
      ((#\|) (consumeChar) (state157 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state162 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state162 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state163 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state163 (scanChar)))
      ((#\#) (consumeChar) (state162 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state164 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state163 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state165 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state165 (scanChar)))
      ((#\/) (consumeChar) (state164 (scanChar)))
      ((#\.) (consumeChar) (state161 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state160 (scanChar)))
      ((#\|) (consumeChar) (state157 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state166 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state166 (scanChar)))
      ((#\#) (consumeChar) (state165 (scanChar)))
      ((#\/) (consumeChar) (state164 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state160 (scanChar)))
      ((#\|) (consumeChar) (state157 (scanChar)))
      ((#\.) (consumeChar) (state155 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state167 c)
    (case c
      ((#\I) (consumeChar) (accept 'number))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state166 (scanChar)))
      ((#\.) (consumeChar) (state154 (scanChar)))
      ((#\n) (consumeChar) (state153 (scanChar)))
      ((#\i) (consumeChar) (state148 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state168 c)
    (case c
      ((#\f) (consumeChar) (state171 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state169 c)
    (case c
      ((#\n) (consumeChar) (state168 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state170 c)
    (case c
      ((#\0) (consumeChar) (accept 'number))
      (else (scannerError errIncompleteToken))))
  (define (state171 c)
    (case c
      ((#\.) (consumeChar) (state170 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state172 c)
    (case c
      ((#\n) (consumeChar) (state171 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state173 c)
    (case c
      ((#\a) (consumeChar) (state172 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state174 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state175 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state175 c)
    (case c
      ((#\#) (consumeChar) (state181 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state180 (scanChar)))
      ((#\|) (consumeChar) (state177 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state175 (scanChar)))
      (else (accept 'number))))
  (define (state176 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state176 (scanChar)))
      (else (accept 'number))))
  (define (state177 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state176 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state178 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state178 (scanChar)))
      ((#\|) (consumeChar) (state177 (scanChar)))
      (else (accept 'number))))
  (define (state179 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state178 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state180 c)
    (case c
      ((#\+ #\-) (consumeChar) (state179 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state178 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state181 c)
    (case c
      ((#\#) (consumeChar) (state181 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state180 (scanChar)))
      ((#\|) (consumeChar) (state177 (scanChar)))
      (else (accept 'number))))
  (define (state182 c)
    (case c
      ((#\#) (consumeChar) (state182 (scanChar)))
      (else (accept 'number))))
  (define (state183 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state183 (scanChar)))
      ((#\#) (consumeChar) (state182 (scanChar)))
      (else (accept 'number))))
  (define (state184 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state183 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state185 c)
    (case c
      ((#\#) (consumeChar) (state185 (scanChar)))
      ((#\/) (consumeChar) (state184 (scanChar)))
      ((#\.) (consumeChar) (state181 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state180 (scanChar)))
      ((#\|) (consumeChar) (state177 (scanChar)))
      (else (accept 'number))))
  (define (state186 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state186 (scanChar)))
      ((#\#) (consumeChar) (state185 (scanChar)))
      ((#\/) (consumeChar) (state184 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state180 (scanChar)))
      ((#\|) (consumeChar) (state177 (scanChar)))
      ((#\.) (consumeChar) (state175 (scanChar)))
      (else (accept 'number))))
  (define (state187 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state186 (scanChar)))
      ((#\.) (consumeChar) (state174 (scanChar)))
      ((#\n) (consumeChar) (state173 (scanChar)))
      ((#\i) (consumeChar) (state169 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state188 c)
    (case c
      ((#\+ #\-) (consumeChar) (state187 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state186 (scanChar)))
      ((#\.) (consumeChar) (state174 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state189 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state189 (scanChar)))
      ((#\@) (consumeChar) (state188 (scanChar)))
      ((#\+ #\-) (consumeChar) (state167 (scanChar)))
      (else (accept 'number))))
  (define (state190 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state190 (scanChar)))
      ((#\#) (consumeChar) (state189 (scanChar)))
      ((#\@) (consumeChar) (state188 (scanChar)))
      ((#\+ #\-) (consumeChar) (state167 (scanChar)))
      (else (accept 'number))))
  (define (state191 c)
    (case c
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state190 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state192 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\#) (consumeChar) (state192 (scanChar)))
      ((#\/) (consumeChar) (state191 (scanChar)))
      ((#\@) (consumeChar) (state188 (scanChar)))
      ((#\+ #\-) (consumeChar) (state167 (scanChar)))
      ((#\.) (consumeChar) (state146 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state145 (scanChar)))
      ((#\|) (consumeChar) (state142 (scanChar)))
      (else (accept 'number))))
  (define (state193 c)
    (case c
      ((#\i #\I) (consumeChar) (accept 'number))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state193 (scanChar)))
      ((#\#) (consumeChar) (state192 (scanChar)))
      ((#\/) (consumeChar) (state191 (scanChar)))
      ((#\@) (consumeChar) (state188 (scanChar)))
      ((#\+ #\-) (consumeChar) (state167 (scanChar)))
      ((#\e #\E #\s #\S #\f #\F #\d #\D #\l #\L)
       (consumeChar)
       (state145 (scanChar)))
      ((#\|) (consumeChar) (state142 (scanChar)))
      ((#\.) (consumeChar) (state140 (scanChar)))
      (else (accept 'number))))
  (define (state194 c)
    (case c
      ((#\I) (consumeChar) (accept 'number))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state193 (scanChar)))
      ((#\.) (consumeChar) (state139 (scanChar)))
      ((#\n) (consumeChar) (state138 (scanChar)))
      ((#\i) (consumeChar) (state133 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state195 c)
    (case c
      ((#\+ #\-) (consumeChar) (state194 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state131 (scanChar)))
      ((#\.) (consumeChar) (state119 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state196 c)
    (case c
      ((#\i #\I #\e #\E)
       (consumeChar)
       (state195 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state197 c)
    (case c
      ((#\#) (consumeChar) (state196 (scanChar)))
      ((#\+ #\-) (consumeChar) (state194 (scanChar)))
      ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
       (consumeChar)
       (state131 (scanChar)))
      ((#\.) (consumeChar) (state119 (scanChar)))
      (else (scannerError errIncompleteToken))))
  (define (state198 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z
        #\0
        #\1
        #\2
        #\3
        #\4
        #\5
        #\6
        #\7
        #\8
        #\9
        #\-)
       (consumeChar)
       (state198 (scanChar)))
      (else (accept 'miscflag))))
  (define (state199 c)
    (case c
      ((#\a
        #\b
        #\c
        #\d
        #\e
        #\f
        #\g
        #\h
        #\i
        #\j
        #\k
        #\l
        #\m
        #\n
        #\o
        #\p
        #\q
        #\r
        #\s
        #\t
        #\u
        #\v
        #\w
        #\x
        #\y
        #\z
        #\A
        #\B
        #\C
        #\D
        #\E
        #\F
        #\G
        #\H
        #\I
        #\J
        #\K
        #\L
        #\M
        #\N
        #\O
        #\P
        #\Q
        #\R
        #\S
        #\T
        #\U
        #\V
        #\W
        #\X
        #\Y
        #\Z)
       (consumeChar)
       (state198 (scanChar)))
      (else (accept 'xcomment))))
  (define (state200 c)
    (case c
      ((#\&) (consumeChar) (accept 'xbox))
      ((#\.) (consumeChar) (accept 'xsharpdot))
      ((#\`) (consumeChar) (accept 'quasisyntax))
      ((#\') (consumeChar) (accept 'syntax))
      ((#\() (consumeChar) (accept 'vecstart))
      ((#\t #\T #\f #\F)
       (consumeChar)
       (accept 'boolean))
      ((#\;) (consumeChar) (accept 'commentdatum))
      ((#\|) (consumeChar) (accept 'comment))
      ((#\!) (consumeChar) (state199 (scanChar)))
      ((#\d #\D) (consumeChar) (state197 (scanChar)))
      ((#\i #\I #\e #\E)
       (consumeChar)
       (state118 (scanChar)))
      ((#\b #\B #\o #\O #\x #\X)
       (consumeChar)
       (state78 (scanChar)))
      ((#\\) (consumeChar) (state76 (scanChar)))
      ((#\v) (consumeChar) (state72 (scanChar)))
      ((#\,) (consumeChar) (state69 (scanChar)))
      ((#\%) (consumeChar) (state68 (scanChar)))
      ((#\") (consumeChar) (state63 (scanChar)))
      (else
       (if ((lambda (c)
              (and (char? c) (char=? c (integer->char 16))))
            c)
           (begin (consumeChar) (accept 'xfaslp))
           (if ((lambda (c)
                  (and (char? c) (char=? c (integer->char 7))))
                c)
               (begin (consumeChar) (accept 'xfaslg))
               (if ((lambda (c)
                      (and (char? c) (char=? c (integer->char 6))))
                    c)
                   (begin (consumeChar) (accept 'xfaslf))
                   (if ((lambda (c)
                          (and (char? c) (char=? c (integer->char 3))))
                        c)
                       (begin (consumeChar) (accept 'xfaslc))
                       (if ((lambda (c)
                              (and (char? c) (char=? c (integer->char 2))))
                            c)
                           (begin (consumeChar) (accept 'xfaslb))
                           (scannerError errIncompleteToken)))))))))
  (define (state201 c)
    (case c
      (else
       (if ((lambda (c)
              (and (char? c)
                   (not (char=? c (integer->char 10)))))
            c)
           (begin (consumeChar) (state201 (scanChar)))
           (begin
             (set! string_accumulator_length 0)
             (state0 (scanChar)))))))
  (define (state202 c)
    (case c
      (else
       (begin
         (set! string_accumulator_length 0)
         (state0 (scanChar))))))
  (define (state203 c)
    (case c (else (accept 'comment))))
  (define (state204 c)
    (case c (else (accept 'commentdatum))))
  (define (state205 c)
    (case c (else (accept 'boolean))))
  (define (state206 c)
    (case c (else (accept 'number))))
  (define (state207 c)
    (case c (else (accept 'character))))
  (define (state208 c)
    (case c (else (accept 'vecstart))))
  (define (state209 c)
    (case c (else (accept 'bvecstart))))
  (define (state210 c)
    (case c (else (accept 'syntax))))
  (define (state211 c)
    (case c (else (accept 'quasisyntax))))
  (define (state212 c)
    (case c (else (accept 'unsyntaxsplicing))))
  (define (state213 c)
    (case c (else (accept 'xfaslb))))
  (define (state214 c)
    (case c (else (accept 'xfaslc))))
  (define (state215 c)
    (case c (else (accept 'xfaslf))))
  (define (state216 c)
    (case c (else (accept 'xfaslg))))
  (define (state217 c)
    (case c (else (accept 'xfaslp))))
  (define (state218 c)
    (case c (else (accept 'xsharpdot))))
  (define (state219 c)
    (case c (else (accept 'xbox))))
  (define (state220 c)
    (case c (else (accept 'xstring))))
  (define (state221 c)
    (case c (else (accept 'eofobj))))
  (define (state222 c)
    (case c (else (accept 'id))))
  (define (state223 c)
    (case c (else (accept 'lparen))))
  (define (state224 c)
    (case c (else (accept 'rparen))))
  (define (state225 c)
    (case c (else (accept 'lbracket))))
  (define (state226 c)
    (case c (else (accept 'rbracket))))
  (define (state227 c)
    (case c (else (accept 'quote))))
  (define (state228 c)
    (case c (else (accept 'backquote))))
  (define (state229 c)
    (case c (else (accept 'splicing))))
  (define (state230 c)
    (case c (else (accept 'string))))

    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ;
    ; End of state machine generated by LexGen.
    ;
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ;
    ; ParseGen generated the code for the strong LL(1) parser.
    ;
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  
(define (parse-outermost-datum)
  (case (next-token)
    ((boolean
       number
       xfaslc
       xfaslf
       character
       string
       xstring
       id
       miscflag
       bvecstart
       xfaslb
       vecstart
       lparen
       lbracket
       quote
       backquote
       comma
       splicing
       syntax
       quasisyntax
       unsyntax
       unsyntaxsplicing
       xbox
       xfaslg
       xfaslp
       xsharpdot)
     (let ((ast1 (parse-datum))) (identity ast1)))
    ((eofobj) (begin (consume-token!) (makeEOF)))
    (else
     (parse-error
       '<outermost-datum>
       '(backquote
          boolean
          bvecstart
          character
          comma
          eofobj
          id
          lbracket
          lparen
          miscflag
          number
          quasisyntax
          quote
          splicing
          string
          syntax
          unsyntax
          unsyntaxsplicing
          vecstart
          xbox
          xfaslb
          xfaslc
          xfaslf
          xfaslg
          xfaslp
          xsharpdot
          xstring)))))

(define (parse-datum)
  (case (next-token)
    ((xsharpdot)
     (begin
       (consume-token!)
       (let ((ast1 (parse-datum))) (sharpDot ast1))))
    ((xfaslp)
     (begin
       (consume-token!)
       (let ((ast1 (parse-datum))) (list2proc ast1))))
    ((xfaslg)
     (begin
       (consume-token!)
       (let ((ast1 (parse-symbol))) (sym2global ast1))))
    ((xbox unsyntaxsplicing
           unsyntax
           quasisyntax
           syntax
           splicing
           comma
           backquote
           quote
           lbracket
           lparen
           vecstart
           xfaslb
           bvecstart)
     (let ((ast1 (parse-location)))
       (let ((ast2 (parse-structured)))
         (makeStructured ast1 ast2))))
    ((miscflag) (begin (consume-token!) (makeFlag)))
    ((id) (begin (consume-token!) (makeSym)))
    ((xstring)
     (begin (consume-token!) (makeXString)))
    ((string) (begin (consume-token!) (makeString)))
    ((character) (begin (consume-token!) (makeChar)))
    ((xfaslf) (begin (consume-token!) (makeFlonum)))
    ((xfaslc) (begin (consume-token!) (makeCompnum)))
    ((number) (begin (consume-token!) (makeNum)))
    ((boolean) (begin (consume-token!) (makeBool)))
    (else
     (parse-error
       '<datum>
       '(backquote
          boolean
          bvecstart
          character
          comma
          id
          lbracket
          lparen
          miscflag
          number
          quasisyntax
          quote
          splicing
          string
          syntax
          unsyntax
          unsyntaxsplicing
          vecstart
          xbox
          xfaslb
          xfaslc
          xfaslf
          xfaslg
          xfaslp
          xsharpdot
          xstring)))))

(define (parse-structured)
  (case (next-token)
    ((bvecstart xfaslb)
     (let ((ast1 (parse-bytevector))) (identity ast1)))
    ((vecstart)
     (let ((ast1 (parse-vector))) (identity ast1)))
    ((lparen
       lbracket
       quote
       backquote
       comma
       splicing
       syntax
       quasisyntax
       unsyntax
       unsyntaxsplicing
       xbox)
     (let ((ast1 (parse-list))) (identity ast1)))
    (else
     (parse-error
       '<structured>
       '(backquote
          bvecstart
          comma
          lbracket
          lparen
          quasisyntax
          quote
          splicing
          syntax
          unsyntax
          unsyntaxsplicing
          vecstart
          xbox
          xfaslb)))))

(define (parse-string)
  (case (next-token)
    ((xstring)
     (begin (consume-token!) (makeXString)))
    ((string) (begin (consume-token!) (makeString)))
    (else (parse-error '<string> '(string xstring)))))

(define (parse-symbol)
  (case (next-token)
    ((id) (begin (consume-token!) (makeSym)))
    (else (parse-error '<symbol> '(id)))))

(define (parse-list)
  (case (next-token)
    ((xbox unsyntaxsplicing
           unsyntax
           quasisyntax
           syntax
           splicing
           comma
           backquote
           quote)
     (let ((ast1 (parse-abbreviation)))
       (identity ast1)))
    ((lbracket)
     (begin
       (consume-token!)
       (let ((ast1 (parse-blst2))) (identity ast1))))
    ((lparen)
     (begin
       (consume-token!)
       (let ((ast1 (parse-list2))) (identity ast1))))
    (else
     (parse-error
       '<list>
       '(backquote
          comma
          lbracket
          lparen
          quasisyntax
          quote
          splicing
          syntax
          unsyntax
          unsyntaxsplicing
          xbox)))))

(define (parse-list2)
  (case (next-token)
    ((boolean
       number
       xfaslc
       xfaslf
       character
       string
       xstring
       id
       miscflag
       bvecstart
       xfaslb
       vecstart
       lparen
       lbracket
       quote
       backquote
       comma
       splicing
       syntax
       quasisyntax
       unsyntax
       unsyntaxsplicing
       xbox
       xfaslg
       xfaslp
       xsharpdot)
     (let ((ast1 (parse-datum)))
       (let ((ast2 (parse-list3))) (cons ast1 ast2))))
    ((rparen) (begin (consume-token!) (emptyList)))
    (else
     (parse-error
       '<list2>
       '(backquote
          boolean
          bvecstart
          character
          comma
          id
          lbracket
          lparen
          miscflag
          number
          quasisyntax
          quote
          rparen
          splicing
          string
          syntax
          unsyntax
          unsyntaxsplicing
          vecstart
          xbox
          xfaslb
          xfaslc
          xfaslf
          xfaslg
          xfaslp
          xsharpdot
          xstring)))))

(define (parse-list3)
  (case (next-token)
    ((rparen
       period
       xsharpdot
       xfaslp
       xfaslg
       xbox
       unsyntaxsplicing
       unsyntax
       quasisyntax
       syntax
       splicing
       comma
       backquote
       quote
       lbracket
       lparen
       vecstart
       xfaslb
       bvecstart
       miscflag
       id
       xstring
       string
       character
       xfaslf
       xfaslc
       number
       boolean)
     (let ((ast1 (parse-data)))
       (let ((ast2 (parse-list4)))
         (pseudoAppend ast1 ast2))))
    (else
     (parse-error
       '<list3>
       '(backquote
          boolean
          bvecstart
          character
          comma
          id
          lbracket
          lparen
          miscflag
          number
          period
          quasisyntax
          quote
          rparen
          splicing
          string
          syntax
          unsyntax
          unsyntaxsplicing
          vecstart
          xbox
          xfaslb
          xfaslc
          xfaslf
          xfaslg
          xfaslp
          xsharpdot
          xstring)))))

(define (parse-list4)
  (case (next-token)
    ((period)
     (begin
       (consume-token!)
       (let ((ast1 (parse-datum)))
         (if (eq? (next-token) 'rparen)
             (begin (consume-token!) (identity ast1))
             (parse-error '<list4> '(rparen))))))
    ((rparen) (begin (consume-token!) (emptyList)))
    (else (parse-error '<list4> '(period rparen)))))

(define (parse-blst2)
  (case (next-token)
    ((boolean
       number
       xfaslc
       xfaslf
       character
       string
       xstring
       id
       miscflag
       bvecstart
       xfaslb
       vecstart
       lparen
       lbracket
       quote
       backquote
       comma
       splicing
       syntax
       quasisyntax
       unsyntax
       unsyntaxsplicing
       xbox
       xfaslg
       xfaslp
       xsharpdot)
     (let ((ast1 (parse-datum)))
       (let ((ast2 (parse-blst3))) (cons ast1 ast2))))
    ((rbracket) (begin (consume-token!) (emptyList)))
    (else
     (parse-error
       '<blst2>
       '(backquote
          boolean
          bvecstart
          character
          comma
          id
          lbracket
          lparen
          miscflag
          number
          quasisyntax
          quote
          rbracket
          splicing
          string
          syntax
          unsyntax
          unsyntaxsplicing
          vecstart
          xbox
          xfaslb
          xfaslc
          xfaslf
          xfaslg
          xfaslp
          xsharpdot
          xstring)))))

(define (parse-blst3)
  (case (next-token)
    ((rbracket
       period
       xsharpdot
       xfaslp
       xfaslg
       xbox
       unsyntaxsplicing
       unsyntax
       quasisyntax
       syntax
       splicing
       comma
       backquote
       quote
       lbracket
       lparen
       vecstart
       xfaslb
       bvecstart
       miscflag
       id
       xstring
       string
       character
       xfaslf
       xfaslc
       number
       boolean)
     (let ((ast1 (parse-data)))
       (let ((ast2 (parse-blst4)))
         (pseudoAppend ast1 ast2))))
    (else
     (parse-error
       '<blst3>
       '(backquote
          boolean
          bvecstart
          character
          comma
          id
          lbracket
          lparen
          miscflag
          number
          period
          quasisyntax
          quote
          rbracket
          splicing
          string
          syntax
          unsyntax
          unsyntaxsplicing
          vecstart
          xbox
          xfaslb
          xfaslc
          xfaslf
          xfaslg
          xfaslp
          xsharpdot
          xstring)))))

(define (parse-blst4)
  (case (next-token)
    ((period)
     (begin
       (consume-token!)
       (let ((ast1 (parse-datum)))
         (if (eq? (next-token) 'rbracket)
             (begin (consume-token!) (identity ast1))
             (parse-error '<blst4> '(rbracket))))))
    ((rbracket) (begin (consume-token!) (emptyList)))
    (else (parse-error '<blst4> '(period rbracket)))))

(define (parse-abbreviation)
  (case (next-token)
    ((quote backquote
            comma
            splicing
            syntax
            quasisyntax
            unsyntax
            unsyntaxsplicing
            xbox)
     (let ((ast1 (parse-abbrev-prefix)))
       (let ((ast2 (parse-datum))) (list ast1 ast2))))
    (else
     (parse-error
       '<abbreviation>
       '(backquote
          comma
          quasisyntax
          quote
          splicing
          syntax
          unsyntax
          unsyntaxsplicing
          xbox)))))

(define (parse-abbrev-prefix)
  (case (next-token)
    ((xbox) (begin (consume-token!) (symBox)))
    ((unsyntaxsplicing)
     (begin (consume-token!) (symUnsyntax-splicing)))
    ((unsyntax)
     (begin (consume-token!) (symUnsyntax)))
    ((quasisyntax)
     (begin (consume-token!) (symQuasisyntax)))
    ((syntax) (begin (consume-token!) (symSyntax)))
    ((splicing)
     (begin (consume-token!) (symSplicing)))
    ((comma) (begin (consume-token!) (symUnquote)))
    ((backquote)
     (begin (consume-token!) (symBackquote)))
    ((quote) (begin (consume-token!) (symQuote)))
    (else
     (parse-error
       '<abbrev-prefix>
       '(backquote
          comma
          quasisyntax
          quote
          splicing
          syntax
          unsyntax
          unsyntaxsplicing
          xbox)))))

(define (parse-vector)
  (case (next-token)
    ((vecstart)
     (begin
       (consume-token!)
       (let ((ast1 (parse-data)))
         (if (eq? (next-token) 'rparen)
             (begin (consume-token!) (list2vector ast1))
             (parse-error '<vector> '(rparen))))))
    (else (parse-error '<vector> '(vecstart)))))

(define (parse-bytevector)
  (case (next-token)
    ((xfaslb)
     (begin (consume-token!) (makeCodevector)))
    ((bvecstart)
     (begin
       (consume-token!)
       (let ((ast1 (parse-octets)))
         (if (eq? (next-token) 'rparen)
             (begin (consume-token!) (list2bytevector ast1))
             (parse-error '<bytevector> '(rparen))))))
    (else
     (parse-error '<bytevector> '(bvecstart xfaslb)))))

(define (parse-data)
  (case (next-token)
    ((boolean
       number
       xfaslc
       xfaslf
       character
       string
       xstring
       id
       miscflag
       bvecstart
       xfaslb
       vecstart
       lparen
       lbracket
       quote
       backquote
       comma
       splicing
       syntax
       quasisyntax
       unsyntax
       unsyntaxsplicing
       xbox
       xfaslg
       xfaslp
       xsharpdot)
     (let ((ast1 (parse-datum)))
       (let ((ast2 (parse-data))) (cons ast1 ast2))))
    ((rparen period rbracket) (emptyList))
    (else
     (parse-error
       '<data>
       '(backquote
          boolean
          bvecstart
          character
          comma
          id
          lbracket
          lparen
          miscflag
          number
          period
          quasisyntax
          quote
          rbracket
          rparen
          splicing
          string
          syntax
          unsyntax
          unsyntaxsplicing
          vecstart
          xbox
          xfaslb
          xfaslc
          xfaslf
          xfaslg
          xfaslp
          xsharpdot
          xstring)))))

(define (parse-octets)
  (case (next-token)
    ((number)
     (let ((ast1 (parse-octet)))
       (let ((ast2 (parse-octets))) (cons ast1 ast2))))
    ((rparen) (emptyList))
    (else (parse-error '<octets> '(number rparen)))))

(define (parse-octet)
  (case (next-token)
    ((number) (begin (consume-token!) (makeOctet)))
    (else (parse-error '<octet> '(number)))))

(define (parse-location)
  (case (next-token)
    ((xbox unsyntaxsplicing
           unsyntax
           quasisyntax
           syntax
           splicing
           comma
           backquote
           quote
           lbracket
           lparen
           vecstart
           xfaslb
           bvecstart)
     (sourceLocation))
    (else
     (parse-error
       '<location>
       '(backquote
          bvecstart
          comma
          lbracket
          lparen
          quasisyntax
          quote
          splicing
          syntax
          unsyntax
          unsyntaxsplicing
          vecstart
          xbox
          xfaslb)))))

    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ;
    ; End of LL(1) parser generated by ParseGen.
    ;
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ;
    ; Lexical analyzer.
    ;
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  
    ; next-token and consume-token! are called by the parser.
  
    ; Returns the current token.
  
    (define (next-token)
      (if nextTokenIsReady
          kindOfNextToken
          (begin (set! string_accumulator_length 0)
                 (scanner0))))
  
    ; Consumes the current token.
  
    (define (consume-token!)
      (set! nextTokenIsReady #f))
  
    ; Called by the lexical analyzer's state machine.
  
    (define (scannerError msg)
      (define msgtxt
        (cond ((= msg errLongToken)
               "amazingly long token")
              ((= msg errIncompleteToken)
               "incomplete or illegal token")
              ((= msg errIllegalHexEscape)
               "illegal hex escape")
              ((= msg errIllegalNamedChar)
               "illegal character syntax")
              ((= msg errIllegalString)
               "illegal string syntax")
              ((= msg errIllegalSymbol)
               "illegal symbol syntax")
              ((= msg errNoDelimiter)
               "missing delimiter")
              ((= msg errSquareBracket)
               "square brackets are disabled")
              ((= msg errLexGenBug)
               "bug in lexical analyzer (generated)")
              (else "bug in lexical analyzer")))
      (let* ((c (scanChar))
             (next (if (char? c) (string c) ""))
             (line (+ 1 (port-lines-read input-port)))
             (msgtxt (string-append msgtxt
                                    " in line "
                                    (number->string line)))
             (msgtxt (string-append msgtxt
                                    ": "
                                    (substring string_accumulator
                                               0
                                               string_accumulator_length)
                                    next)))

        ; must avoid infinite loop on current input port
        ;
        ; FIXME: the R6RS says the exception must (in some cases)
        ; be both &lexical and &i/o-read, but the &i/o-read
        ; part appears to have been a mistake.

        (consumeChar)
        (raise-r6rs-exception
         (make-lexical-violation)
         'get-datum
          (string-append "lexical error: " msgtxt " ")
          input-port))
      (next-token))
  
    ; Accepts a token of the given kind, returning that kind.
    ;
    ; For some kinds of tokens, a value for the token must also
    ; be recorded in tokenValue.  Most of those tokens must be
    ; followed by a delimiter.
    ;
    ; Some magical tokens require special processing.
  
    (define (accept t)
      (case t

       ((comment)
        ; The token is #|, which starts a nested comment.
        (scan-nested-comment)
        (next-token))

       ((commentdatum)
        ; The token is #; so parse and ignore the next datum.
        (parse-datum)
        (next-token))

       ((id boolean number character string miscflag period)

        (set! tokenValue
              (substring string_accumulator
                         0 string_accumulator_length))

        (cond ((and (eq? t 'miscflag)
                    (string=? tokenValue "#!r6rs"))
               (set-mode! 'r6rs)
               (next-token))

              ((or (delimiter? (scanChar))
                   (eq? t 'string))
               (set! kindOfNextToken t)
               (set! nextTokenIsReady #t)
               t)

              (else
               (scannerError errNoDelimiter))))

       ; FIXME: Do we really need to disable square brackets?

       ((lbracket)
        (if (read-square-bracket-as-paren)
            (begin (set! kindOfNextToken t)
                   (set! nextTokenIsReady #t)
                   t)
            (scannerError errSquareBracket)))
       (else
        (set! kindOfNextToken t)
        (set! nextTokenIsReady #t)
        t)))

    ; Having seen a #| token, scans and discards the entire comment.

    (define (scan-nested-comment)
      (define (loop depth)
        (let ((c (scanChar)))
          (cond ((= depth 0) #t)
                ((eof-object? c)
                 (scannerError errIncompleteToken))
                ((char=? c #\#)
                 (consumeChar)
                 (if (char=? (scanChar) #\|)
                     (begin (consumeChar) (loop (+ depth 1)))
                     (loop depth)))
                ((char=? c #\|)
                 (consumeChar)
                 (if (char=? (scanChar) #\#)
                     (begin (consumeChar) (loop (- depth 1)))
                     (loop depth)))
                (else
                 (consumeChar)
                 (loop depth)))))
      (loop 1))


    ; Most reader modes are now port-specific.
    ; Some, but not all, can be changed by reading a flag.

    (define (set-mode! m)
      (let ()
        (case m
         ((r6rs)
          (set-port-switches input-port
                             port-folds-case! #f
                             io/port-allows-larceny-weirdness!     #f
                             io/port-allows-traditional-weirdness! #f
                             io/port-allows-mzscheme-weirdness!    #f
                             io/port-recognizes-javadot-symbols!   #f))

         ((err5rs)
          (set-port-switches input-port
                             io/port-allows-larceny-weirdness! #t))

         ((r5rs)
          (set-port-switches input-port
                             port-folds-case! #t
                             io/port-allows-larceny-weirdness! #t))

         ((fasl larceny)
          (set-port-switches input-port
                             port-folds-case! #f
                             io/port-allows-larceny-weirdness! #t))

         ((fold-case)
          (port-folds-case! input-port #t))

         ((no-fold-case)
          (port-folds-case! input-port #f))

         ; FIXME: these compiler switches might not be defined in all heaps.

         ;((slow)
         ; (set-switches compiler-switches 'slow))
         ;((fast)
         ; (set-switches compiler-switches 'fast-safe))
         ;((safe)
         ; (set-switches runtime-safety-checking #t
         ;               catch-undefined-globals #t))
         ;((unsafe)
         ; (set-switches compiler-switches 'fast-unsafe))

         (else #t))))

    ; This looks weird but saves code space.

    (define (set-port-switches port . settings)
      (do ((settings settings (cddr settings)))
          ((null? settings))
        ((car settings) port (cadr settings))))
  
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ;
    ; Character i/o, so to speak.
    ; Uses the input-port as input.
    ;
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  
    (define (scanChar)
      (peek-char input-port))

    ; Consumes the current character.  Returns unspecified values.
  
    (define (consumeChar)
      (if (< string_accumulator_length (string-length string_accumulator))
          (let ((c (read-char input-port)))
            (if (char? c)
                (begin
                 (string-set! string_accumulator
                              string_accumulator_length
                              c)
                 (set! string_accumulator_length
                       (+ string_accumulator_length 1)))))
          (begin (expand-accumulator) (consumeChar))))

    ; Doubles the size of string_accumulator while
    ; preserving its contents.

    (define (expand-accumulator)
      (let* ((n (string-length string_accumulator))
             (new (make-string (* 2 n))))
        (do ((i 0 (+ i 1)))
            ((= i n))
          (string-set! new i (string-ref string_accumulator i)))
        (set! string_accumulator new)))

    (define (record-source-location x start)
      (if keep-source-locations?
          (set! locations
                (cons (vector x start (make-source-location input-port))
                      locations)))
      x)
  
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ;
    ; Miscellaneous utility routines.
    ;
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

    ; Determines whether its argument is a <delimiter>.

    (define (delimiter? c)
      (case c
       ((#\( #\) #\[ #\] #\" #\; #\#)
        #t)
       (else
        (or (not (char? c))
            (char-whitespace? c)))))         

    ; Given the integer parsed from a hex escape,
    ; returns the corresponding Unicode character.

    (define (checked-integer->char n)
      (if (or (< n #xd800)
              (<= #xe000 n #x10ffff))
          (integer->char n)
          (scannerError errIllegalHexEscape)))

    ; Given a string and the index at the beginning of nonempty
    ; sequence of hexadecimal characters followed by a semicolon,
    ; returns two values:
    ;     the numerical value of the hex characters
    ;     the index following the semicolon

    (define (hex-escape s i)
      (let ((n (string-length s)))
        (define (loop i val)
          (if (>= i n)
              (scannerError errIllegalHexEscape)
              (let ((c (string-ref s i)))
                (case c
                 ((#\0 #\1 #\2 #\3 #\4 #\5 #\6 #\7 #\8 #\9)
                  (loop (+ i 1)
                        (+ (* 16 val)
                           (- (char->integer c) (char->integer #\0)))))
                 ((#\a #\b #\c #\d #\e #\f)
                  (loop (+ i 1)
                        (+ (* 16 val)
                           10
                           (- (char->integer c) (char->integer #\a)))))
                 ((#\A #\B #\C #\D #\E #\F)
                  (loop (+ i 1)
                        (+ (* 16 val)
                           10
                           (- (char->integer c) (char->integer #\A)))))
                 ((#\;)
                  (values val (+ i 1)))
                 (else (scannerError errIllegalHexEscape))))))
        (loop i 0)))
  
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ;
    ; Action procedures called by the parser.
    ;
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

    (define (emptyList) '())
  
    (define (identity x) x)

    (define (list2bytevector octets) (u8-list->bytevector octets))

    (define (list2proc vals)
      (if (io/port-allows-larceny-weirdness? input-port)
          (list->procedure vals)
          (parse-error '<datum> datum-starters)))

    (define (list2vector vals) (list->vector vals))
  
    (define (makeBool)
      (let ((x (case (string-ref tokenValue 1)
                ((#\t #\T) #t)
                ((#\f #\F) #f)
                (else (scannerError errBug)))))
        (record-source-location x locationStart)))
  
    (define (makeChar)
      (let* ((n (string-length tokenValue))
             (x (cond ((= n 3)
                       (string-ref tokenValue 2))
                      ((char=? #\x (string-ref tokenValue 2))
                       (checked-integer->char
                        (string->number (substring tokenValue 3 n) 16)))
                      (else
                       (let* ((s (substring tokenValue 2 n))
                              (s (if (port-folds-case? input-port)
                                     (string-foldcase s)
                                     s))
                              (sym (string->symbol s)))
                         (case sym
                          ((nul)               #\nul)
                          ((alarm)             char:alarm)
                          ((backspace)         #\backspace)
                          ((tab)               #\tab)
                          ((linefeed newline)  #\linefeed)
                          ((vtab)              #\vtab)
                          ((page)              #\page)
                          ((return)            #\return)
                          ((esc)               char:esc)
                          ((space)             #\space)
                          ((delete)            char:delete)
                          (else
                           (scannerError errIllegalNamedChar))))))))
        (record-source-location x locationStart)))

    ; #^B"..."
    ; Coding bytevectors as strings is inherently evil.
    ; Must keep this in sync with print-slashed-bytevector,
    ; which is defined in Lib/Common/print.sch.
    ; All characters represent bytes except for #\" and #\\.
    ; The #\" begins and terminates the sequence of bytes,
    ; and the #\\ is used only to escape the next character.
    ; Note: This code doesn't check for end of file, and
    ; shouldn't have to.

    (define (makeCodevector)
      (define (loop)
        (let ((c (scanChar)))
          ; The call to consumeChar puts the char in string_accumulator.
          (consumeChar)
          (case c
           ((#\")
            (let* ((n (- string_accumulator_length 1)) ; ignore closing #\"
                   (bv (make-bytevector n)))
              (do ((i 0 (+ i 1)))
                  ((= i n) bv)
                (bytevector-set! bv i (char->integer
                                       (string-ref string_accumulator i))))))
           ((#\\)
            ; Erase the escape character.
            (set! string_accumulator_length (- string_accumulator_length 1))
            (consumeChar)
            (loop))
           (else
            (loop)))))
      (if (io/port-allows-larceny-weirdness? input-port)
          (let ((c (scanChar)))
            (if (char=? c #\")
                (begin (consumeChar)
                       (set! string_accumulator_length 0)
                       (loop))
                (parse-error '<datum> datum-starters)))
          (parse-error '<datum> datum-starters)))
  
    ; #^Cxxxxxxxxxxxxxxxx
    ; Coding bits as characters is inherently evil.
    ; It forces .fasl files to be encoded as Latin-1.

    (define (makeCompnum)
      (define (loop bv i n)
        (if (< i n)
            (let* ((c (scanChar))
                   (b (char->integer c)))
              (consumeChar)
              (bytevector-set! bv i b)
              (loop bv (+ i 1) n))))
      (let ((z (make-bytevector 20)))
        (loop z 4 20)
        (typetag-set! z sys$tag.compnum-typetag)
        z))

    (define (makeEOF) (eof-object))

    (define (makeFlag)

      ; The draft R6RS allows implementation-specific extensions
      ; of the form #!..., which are processed here.
      ; Note that the #!r6rs flag is a comment, handled by accept,
      ; so that flag will never be seen here.

      (if (io/port-allows-flags? input-port)

          (let* ((n (string-length tokenValue))
                 (flag (string->symbol (substring tokenValue 2 n)))
                 (x (case flag
                     ((fold-case no-fold-case
                       err5rs r5rs larceny slow fast safe unsafe)
                      (set-mode! flag)
                      (unspecified))
                     ((fasl)
                      (set-mode! flag)
                      ((fasl-evaluator)))
                     ((unspecified) (unspecified))
                     ((undefined)   (undefined))
                     ((null)        '())
                     ((false)       #f)
                     ((true)        #t)
                     (else
                      (accept 'miscflag)
                      (parse-error '<miscflag> '(miscflag))))))
            (record-source-location x locationStart))

          (begin (accept 'miscflag)
                 (parse-error '<miscflag> '(miscflag)))))
  
    ; #^Fxxxxxxxx
    ; Coding bits as characters is inherently evil.
    ; It forces .fasl files to be encoded as Latin-1.

    (define (makeFlonum)
      (define (loop bv i n)
        (if (< i n)
            (let* ((c (scanChar))
                   (b (char->integer c)))
              (consumeChar)
              (bytevector-set! bv i b)
              (loop bv (+ i 1) n))))
      (let ((x (make-bytevector 12)))
        (loop x 4 12)
        (typetag-set! x sys$tag.flonum-typetag)
        x))

    (define (makeNum)
      (let ((x (string->number tokenValue)))
        (if x
            (record-source-location x locationStart)
            (begin (accept 'number)
                   (parse-error '<number> '(number))))))
  
    (define (makeOctet)
      (let ((n (string->number tokenValue)))
        (if (and (exact? n) (integer? n) (<= 0 n 255))
            (record-source-location n locationStart)
            (begin (accept 'octet)
                   (parse-error '<octet> '(octet))))))
  
    (define (makeString)

      ; Must strip off outer double quotes and deal with escapes.
      ;
      ; i is the next index into tokenValue
      ; n is the exclusive upper bound for i
      ; newstring is a string that might become the result
      ; j is the next index into newstring

      (define (loop i n newstring j)
        (if (>= i n)
            (if (= j (string-length newstring))
                newstring
                (substring newstring 0 j))
            (let ((c (string-ref tokenValue i)))
              (cond ((or (char=? c #\return)
                         (char=? c #\linefeed)
                         (char=? c char:nel)
                         (char=? c char:ls))
                     (string-set! newstring j #\linefeed)
                     (let* ((i+1 (+ i 1))
                            (i+1 (if (and (char=? c #\return)
                                          (< i+1 n))
                                     (let ((c2 (string-ref tokenValue i+1)))
                                       (if (or (char=? c2 #\linefeed)
                                               (char=? c2 char:nel))
                                           (+ i 2)
                                           i+1))
                                     i+1)))
                       (loop i+1 n newstring (+ j 1))))
                    ((char=? c #\\)
                     (if (< (+ i 1) n)
                         (let ((c2 (string-ref tokenValue (+ i 1))))
                           (case c2
                            ((#\a)
                             (string-set! newstring j char:alarm)
                             (loop (+ i 2) n newstring (+ j 1)))
                            ((#\b)
                             (string-set! newstring j #\backspace)
                             (loop (+ i 2) n newstring (+ j 1)))
                            ((#\t)
                             (string-set! newstring j #\tab)
                             (loop (+ i 2) n newstring (+ j 1)))
                            ((#\n)
                             (string-set! newstring j #\linefeed)
                             (loop (+ i 2) n newstring (+ j 1)))
                            ((#\v)
                             (string-set! newstring j #\vtab)
                             (loop (+ i 2) n newstring (+ j 1)))
                            ((#\f)
                             (string-set! newstring j #\page)
                             (loop (+ i 2) n newstring (+ j 1)))
                            ((#\r)
                             (string-set! newstring j #\return)
                             (loop (+ i 2) n newstring (+ j 1)))
                            ((#\" #\\)
                             (string-set! newstring j c2)
                             (loop (+ i 2) n newstring (+ j 1)))
                            ((#\x)
                             (call-with-values
                              (lambda () (hex-escape tokenValue (+ i 2)))
                              (lambda (sv i)
                                (string-set! newstring
                                             j
                                             (checked-integer->char sv))
                                (loop i n newstring (+ j 1)))))
                            (else
                             (ignore-escaped-line-ending (+ i 1)
                                                         n newstring j #f))))
                     (scannerError errIllegalString)))
                    (else
                     (string-set! newstring j c)
                     (loop (+ i 1) n newstring (+ j 1)))))))

      ; Ignores <intraline whitespace>* <line ending> <intraline whitespace>*
      ; after? is true iff the <line ending> has already been ignored.
      ; The other arguments are the same as for loop above.

      (define (ignore-escaped-line-ending i n newstring j after?)
        (cond ((< i n)
               (let ((c (string-ref tokenValue i)))
                 (cond ((or (char=? c #\tab)
                            (eq? 'Zs (char-general-category c)))
                        (ignore-escaped-line-ending (+ i 1)
                                                    n newstring j after?))
                       (after?
                        (loop i n newstring j))
                       ((or (char=? c #\return)
                            (char=? c #\linefeed)
                            (char=? c char:nel)
                            (char=? c char:ls))
                        (let* ((i+1 (+ i 1))
                               (i+1 (if (and (char=? c #\return)
                                             (< i+1 n))
                                        (let ((c2 (string-ref
                                                   tokenValue i+1)))
                                          (if (or (char=? c2 #\linefeed)
                                                  (char=? c2 char:nel))
                                              (+ i 2)
                                              i+1))
                                        i+1)))
                          (ignore-escaped-line-ending i+1 n newstring j #t)))
                       ((io/port-allows-larceny-weirdness? input-port)
                        (string-set! newstring j c)
                        (loop (+ i 1) n newstring (+ j 1)))
                       (else
                        (scannerError errIllegalString)))))
              (after?
               (loop i n newstring j))
              (else
               (scannerError errIllegalString))))

      (let* ((n (string-length tokenValue))
             (s (loop 1 (- n 1) (make-string (- n 2)) 0)))
        (record-source-location s locationStart)))

    (define (makeStructured loc0 x)
      (record-source-location x loc0))

    ; Several Larceny-specific extensions are handled here:
    ;     leading . or @ or +: or -:
    ;     vertical bars at beginning and end (which quote the interior)
    ;     vertical bars (embedded, which do not quote)
    ;     backslashes for other than hex escapes
    ;         (note: they disable *all* case folding)
    ;     MzScheme randomness
    ;     several peculiar identifiers

    (define (makeSym)
      (let ((n (string-length tokenValue)))
        (define (return sym)
          (let ((x (if (and (io/port-recognizes-javadot-symbols? input-port)
                            (javadot-syntax? sym))
                       (symbol->javadot-symbol! sym)
                       sym)))
            (record-source-location x locationStart)))
        (define (loop i)
          (if (= i n)
              (return (string->symbol (if (port-folds-case? input-port)
                                          (string-foldcase tokenValue)
                                          tokenValue)))
              (let ((c (string-ref tokenValue i)))
                (cond ((or (char=? c #\\)
                           (char=? c #\#))
                       (slow-loop i
                                  (reverse
                                   (string->list (substring tokenValue 0 i)))
                                  (port-folds-case? input-port)))
                      ((and (char=? c #\|)
                            (not
                             (io/port-allows-larceny-weirdness? input-port)))
                       (scannerError errIllegalSymbol))
                      (else
                       (loop (+ i 1)))))))
        (define (slow-loop i chars fold-case?)
          (if (= i n)
              (return (string->symbol (list->string (reverse chars))))
              (let ((c (string-ref tokenValue i)))
                (cond ((char=? c #\\)
                       (cond ((and (< (+ i 1) n)
                                   (char=? (string-ref tokenValue (+ i 1))
                                           #\x))
                              (call-with-values
                               (lambda () (hex-escape tokenValue (+ i 2)))
                               (lambda (sv i)
                                 (slow-loop i
                                            (cons (checked-integer->char sv)
                                                  chars)
                                            fold-case?))))
                             ((and (< (+ i 1) n)
                                   (io/port-allows-larceny-weirdness?
                                    input-port))
                              (slow-loop (+ i 2)
                                         (cons (string-ref tokenValue (+ i 1))
                                               chars)
                                         #f))
                             (else
                              (scannerError errIllegalSymbol))))
                      ((char=? c #\#)
                       (if (and (< (+ i 1) n)
                                (io/port-allows-mzscheme-weirdness? input-port)
                                (char=? (string-ref tokenValue (+ i 1))
                                        #\%))
                           (slow-loop (+ i 1) (cons c chars) fold-case?)
                           (scannerError errIllegalSymbol)))
                      (else (slow-loop (+ i 1) (cons c chars) fold-case?))))))
        (let ((c (string-ref tokenValue 0)))
          (cond ((or (char=? c #\.) (char=? c #\@))
                 (if (or (io/port-allows-larceny-weirdness? input-port)
                         (string=? "..." tokenValue))
                     (loop 0)
                     (scannerError errIllegalSymbol)))
                ((and (char=? c #\-)
                      (< 1 (string-length tokenValue))
                      (not (char=? (string-ref tokenValue 1) #\>)))
                 (if (and (io/port-allows-larceny-weirdness? input-port)
                          (or (member tokenValue '("--" "-1+"))
                              (char=? #\: (string-ref tokenValue 1))))
                     (loop 0)
                     (scannerError errIllegalSymbol)))
                ((and (char=? c #\+)
                      (< 1 (string-length tokenValue)))
                 (if (and (io/port-allows-larceny-weirdness? input-port)
                          (char=? #\: (string-ref tokenValue 1)))
                     (loop 0)
                     (scannerError errIllegalSymbol)))
                ((char=? c #\1)
                 (if (and (io/port-allows-larceny-weirdness? input-port)
                          (member tokenValue '("1+" "1-")))
                     (loop 0)
                     (scannerError errIllegalSymbol)))
                ((char=? c #\|)
                 (if (and (io/port-allows-traditional-weirdness? input-port)
                          (< 1 n)
                          (char=? (string-ref tokenValue (- n 1)) #\|))
                     ; |...| symbols
                     (return (string->symbol (substring tokenValue 1 (- n 1))))
                     (scannerError errIllegalSymbol)))
                (else
                 (loop 0))))))

    ; #"..." Ascii string syntax of MzScheme

    (define (makeXString)
      (if (io/port-allows-mzscheme-weirdness? input-port)
          (begin (set! tokenValue
                       (substring
                        tokenValue 0 (- (string-length tokenValue) 1)))
                 (makeString))
          (parse-error '<datum> datum-starters)))
  
    ; Like append, but allows the last argument to be a non-list.
  
    (define (pseudoAppend vals terminus)
      (if (null? vals)
          terminus
          (cons (car vals)
                (pseudoAppend (cdr vals) terminus))))

    ; #.(...) read-time evaluation

    (define (sharpDot x)
      (if (io/port-allows-traditional-weirdness? input-port)
          (eval x)
          (parse-error '<datum> datum-starters)))

    ; Returns the source location at the start of the previous token.

    (define (sourceLocation) locationStart)

    ; #^Gsym syntax used in .fasl files

    (define (sym2global sym)
      (if (io/port-allows-larceny-weirdness? input-port)
          ((global-name-resolver) sym)
          (parse-error '<datum> datum-starters)))

    ; Oh, dear.  There's no excuse, but see lib/Standard/box.sch

    (define (symBox)
      (if (and (io/port-allows-traditional-weirdness? input-port)
               (bound? box))
          (box (parse-datum))
          (parse-error '<datum> datum-starters)))
  
    (define (symBackquote) 'quasiquote)
    (define (symQuasisyntax) 'quasisyntax)
    (define (symQuote) 'quote)
    (define (symSplicing) 'unquote-splicing)
    (define (symSyntax) 'syntax)
    (define (symUnquote) 'unquote)
    (define (symUnsyntax) 'unsyntax)
    (define (symUnsyntax-splicing) 'unsyntax-splicing)
  
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ;
    ; Error procedure called by the parser.
    ;
    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  
    (define (parse-error nonterminal expected-terminals)
      (let* ((culprit (next-token))
             (culprit-as-string (symbol->string culprit))
             (culprit-as-string
              (if (memq culprit expected-terminals)
                  (string-append "illegal " culprit-as-string)
                  culprit-as-string))
             (msg (string-append
                   "Syntax error in line "
                   (number->string (+ 1 (port-lines-read input-port)))
                   " while parsing "
                   (symbol->string nonterminal)
                   (string #\newline)
                   "  Encountered "
                   culprit-as-string
                   " while expecting "
                   (case nonterminal
                    ((<datum> <outermost-datum> <data>)
                     "a datum")
                    (else
                     (string-append
                      (string #\newline)
                      "  "
                      (apply string-append
                             (map (lambda (terminal)
                                    (string-append " "
                                                   (symbol->string terminal)))
                                  expected-terminals)))))
                   (string #\newline))))
        (raise-r6rs-exception (make-lexical-violation)
                              'get-datum msg input-port)))

    ; The list of tokens that can start a datum in R6RS mode.

    (define datum-starters
      '(backquote
        boolean
        bvecstart
        character
        comma
        id
        lbracket
        lparen
        miscflag
        number
        quasisyntax
        quote
        splicing
        string
        syntax
        unsyntax
        unsyntaxsplicing
        vecstart))
  
    (if keep-source-locations?
        (let ((x (parse-outermost-datum)))
          (values x locations))
        (parse-outermost-datum))))

; eof
