;Generated from Scheme source by scm2cl, v. 0f,
;(c) Dorai Sitaram, http://www.cs.rice.edu/~dorai/scm2cl

(defun pregexp-compile (s)
  (let ((n (length s)))
    (let ((r 'nil) (i 0))
      (flet ((loop! (r i) (throw 'loop! (values r i))))
        (loop
          (multiple-value-setq (r i)
            (let ((r r) (i i))
              (catch 'loop!
                (return
                  (if (>= i n) (cons ':seq (reverse r))
                    (let ((vv (pregexp-read-chunk s i n)))
                      (loop! (cons (car vv) r) (cdr vv))
) ) ) ) ) ) ) ) ) ) )

(defun pregexp-read-num (s i)
  (let ((r 'nil) (k i))
    (flet ((loop! (r k) (throw 'loop! (values r k))))
      (loop
        (multiple-value-setq (r k)
          (let ((r r) (k k))
            (catch 'loop!
              (return
                (let ((c (char s k)))
                  (if (digit-char-p c) (loop! (cons c r) (+ k 1))
                    (cons
                      (let
                        ((|Scheme-to-CL-1| (concatenate 'string (reverse r))))
                        (if (position #\: |Scheme-to-CL-1| :test #'char=) nil
                          (let
                            ((|Scheme-to-CL-2|
                                (read-from-string |Scheme-to-CL-1|)
                            ))
                            (if (numberp |Scheme-to-CL-2|) |Scheme-to-CL-2| nil
                      ) ) ) )
                      k
) ) ) ) ) ) ) ) ) ) )

(defun pregexp-wrap-multiplier-if-any (s vv n)
  (let ((i (cdr vv)))
    (case (and (< i n) (char s i))
      ((#\*) (cons (list ':zero-or-more (car vv)) (+ i 1)))
      ((#\+) (cons (list ':one-or-more (car vv)) (+ i 1)))
      ((#\?) (cons (list ':zero-or-one (car vv)) (+ i 1)))
      ((#\\)
        (case (char s (+ i 1))
          ((#\{)
            (let ((m (pregexp-read-num s (+ i 2))))
              (let ((n (pregexp-read-num s (+ (cdr m) 1))))
                (cons (list ':between-nums (car vv) (car m) (car n))
                  (+ (cdr n) 2)
          ) ) ) )
          (t vv)
      ) )
      (t vv)
) ) )

(defun pregexp-invert-char-list (vv) (rplaca (car vv) ':none-of-chars) vv)

(defun pregexp-read-char-list (s i n)
  (let ((r 'nil) (i i))
    (flet ((loop! (r i) (throw 'loop! (values r i))))
      (loop
        (multiple-value-setq (r i)
          (let ((r r) (i i))
            (catch 'loop!
              (return
                (let ((c (char s i)))
                  (case c
                    ((#\]) (cons (cons ':one-of-chars (reverse r)) (+ i 1)))
                    ((#\\) (loop! (cons (char s (+ i 1)) r) (+ i 2)))
                    ((#\-)
                      (loop!
                        (cons (list ':char-range (car r) (char s (+ i 1)))
                          (cdr r)
                        )
                        (+ i 2)
                    ) )
                    (t (loop! (cons c r) (+ i 1)))
) ) ) ) ) ) ) ) ) )

(defun pregexp-read-chunk (s i n)
  (let ((c (char s i)))
    (case c ((#\^) (cons ':bos (+ i 1))) ((#\$) (cons ':eos (+ i 1)))
      ((#\.) (pregexp-wrap-multiplier-if-any s (cons ':any (+ i 1)) n))
      ((#\[)
        (pregexp-wrap-multiplier-if-any s
          (case (char s (+ i 1))
            ((#\^)
              (pregexp-invert-char-list (pregexp-read-char-list s (+ i 2) n))
            )
            (t (pregexp-read-char-list s (+ i 1) n))
          )
          n
      ) )
      ((#\\)
        (pregexp-wrap-multiplier-if-any s
          (let ((c (char s (+ i 1))))
            (case c ((#\() (pregexp-read-sub-pat s (+ i 2) n))
              (t (cons c (+ i 2)))
          ) )
          n
      ) )
      (t (pregexp-wrap-multiplier-if-any s (cons c (+ i 1)) n))
) ) )

(defun pregexp-read-sub-pat (s i n)
  (let ((r 'nil) (i i))
    (flet ((loop! (r i) (throw 'loop! (values r i))))
      (loop
        (multiple-value-setq (r i)
          (let ((r r) (i i))
            (catch 'loop!
              (return
                (case (char s i)
                  ((#\\)
                    (case (char s (+ i 1))
                      ((#\))
                        (cons (list ':sub (cons ':seq (reverse r))) (+ i 2))
                      )
                      (t
                        (let ((vv (pregexp-read-chunk s i n)))
                          (loop! (cons (car vv) r) (cdr vv))
                  ) ) ) )
                  (t
                    (let ((vv (pregexp-read-chunk s i n)))
                      (loop! (cons (car vv) r) (cdr vv))
) ) ) ) ) ) ) ) ) ) )

(defun pregexp-match (pat str)
  (pregexp-match-precompiled (if (stringp pat) (pregexp-compile pat) pat) str)
)

(defun pregexp-match-precompiled (re s)
  (let ((n (length s)))
    (let ((i 0))
      (flet ((loop! (i) (throw 'loop! (values i))))
        (loop
          (multiple-value-setq (i)
            (let ((i i))
              (catch 'loop!
                (return
                  (and (< i n)
                    (or (pregexp-match-anchoring-left re s i n) (loop! (+ i 1))
) ) ) ) ) ) ) ) ) ) )

(defun pregexp-match-anchoring-left (re s i n)
  (let ((sub-match-stk 'nil))
    (let ((collect-sub-matches? t))
      (let
        ((dcsm
            #'(lambda (th)
                (if collect-sub-matches?
                  (progn (setq collect-sub-matches? nil)
                    (let ((res (funcall th))) (setq collect-sub-matches? t) res
                  ) )
                  (if t (funcall th))
        ))    ) )
        (let
          ((k
              (labels
                ((recur (re i)
                    (if (not i) nil
                      (if (characterp re)
                        (and (< i n) (char= (char s i) re) (+ i 1))
                        (if (eql re ':bos) (and (= i 0) i)
                          (if (eql re ':eos) (and (>= i n) i)
                            (if (eql re ':any) (and (< i n) (+ i 1))
                              (if t
                                (case (car re)
                                  ((:seq)
                                    (labels
                                      ((seq-recur (res i)
                                          (if (not i) nil
                                            (if (null res) i
                                              (if t
                                                (let
                                                  ((re (car res))
                                                    (rest (cdr res))
                                                  )
                                                  (seq-recur rest
                                                    (if
                                                      (and (consp re)
                                                        (member (car re)
                                                          '(:zero-or-one
                                                             :zero-or-more
                                                             :one-or-more
                                                             :between-nums
                                                      ) )  )
                                                      (let
                                                        ((left-match-stk
                                                            sub-match-stk
                                                        ))
                                                        (setq sub-match-stk
                                                          'nil
                                                        )
                                                        (let
                                                          ((dir (car re))
                                                            (subre (cadr re))
                                                          )
                                                          (let
                                                            ((i
                                                                (case (car re)
                                                                  ((:zero-or-one)
                                                                    (let
                                                                      ((j
                                                                          (recur
                                                                            subre
                                                                            i
                                                                      ))  )
                                                                      (or
                                                                        (and j
                                                                          (funcall
                                                                            dcsm
                                                                            #'(lambda
                                                                                nil
                                                                                (seq-recur
                                                                                  rest
                                                                                  j
                                                                          )   ) )
                                                                          j
                                                                        )
                                                                        (and
                                                                          (funcall
                                                                            dcsm
                                                                            #'(lambda
                                                                                nil
                                                                                (seq-recur
                                                                                  rest
                                                                                  i
                                                                          )   ) )
                                                                          i
                                                                  ) ) ) )
                                                                  ((:zero-or-more)
                                                                    (labels
                                                                      ((mul-recur
                                                                          (i)
                                                                          (let
                                                                            ((j
                                                                                (recur
                                                                                  subre
                                                                                  i
                                                                            ))  )
                                                                            (or
                                                                              (and
                                                                                j
                                                                                (mul-recur
                                                                                  j
                                                                              ) )
                                                                              (and
                                                                                (funcall
                                                                                  dcsm
                                                                                  #'(lambda
                                                                                      nil
                                                                                      (seq-recur
                                                                                        rest
                                                                                        i
                                                                                )   ) )
                                                                                i
                                                                      ))  ) ) )
                                                                      (mul-recur
                                                                        i
                                                                  ) ) )
                                                                  ((:one-or-more)
                                                                    (labels
                                                                      ((mul-recur
                                                                          (i)
                                                                          (and
                                                                            i
                                                                            (let
                                                                              ((j
                                                                                  (recur
                                                                                    subre
                                                                                    i
                                                                              ))  )
                                                                              (or
                                                                                (and
                                                                                  j
                                                                                  (mul-recur
                                                                                    j
                                                                                ) )
                                                                                (and
                                                                                  (funcall
                                                                                    dcsm
                                                                                    #'(lambda
                                                                                        nil
                                                                                        (seq-recur
                                                                                          rest
                                                                                          i
                                                                                  )   ) )
                                                                                  i
                                                                      ))  ) ) ) )
                                                                      (mul-recur
                                                                        (recur
                                                                          subre
                                                                          i
                                                                  ) ) ) )
                                                                  ((:between-nums)
                                                                    (let
                                                                      ((m
                                                                          (or
                                                                            (caddr
                                                                              re
                                                                            )
                                                                            0
                                                                       )  )
                                                                        (n
                                                                          (cadddr
                                                                            re
                                                                      ) ) )
                                                                      (let
                                                                        ((i
                                                                            (let
                                                                              ((i
                                                                                  i
                                                                               )
                                                                                (k
                                                                                  0
                                                                              ) )
                                                                              (flet
                                                                                ((loopm
                                                                                    (i
                                                                                      k
                                                                                    )
                                                                                    (throw
                                                                                      'loopm
                                                                                      (values
                                                                                        i
                                                                                        k
                                                                                ))  ) )
                                                                                (loop
                                                                                  (multiple-value-setq
                                                                                    (i
                                                                                      k
                                                                                    )
                                                                                    (let
                                                                                      ((i
                                                                                          i
                                                                                       )
                                                                                        (k
                                                                                          k
                                                                                      ) )
                                                                                      (catch
                                                                                        'loopm
                                                                                        (return
                                                                                          (if
                                                                                            (=
                                                                                              k
                                                                                              m
                                                                                            )
                                                                                            i
                                                                                            (let
                                                                                              ((j
                                                                                                  (recur
                                                                                                    subre
                                                                                                    i
                                                                                              ))  )
                                                                                              (and
                                                                                                j
                                                                                                (loopm
                                                                                                  j
                                                                                                  (+
                                                                                                    k
                                                                                                    1
                                                                        ))  ) ) ) ) ) ) ) ) ) ) ) )
                                                                        (let
                                                                          ((n-m
                                                                              (and
                                                                                n
                                                                                (-
                                                                                  n
                                                                                  m
                                                                          ))  ) )
                                                                          (labels
                                                                            ((mul-recur
                                                                                (i
                                                                                  k
                                                                                )
                                                                                (and
                                                                                  (or
                                                                                    (not
                                                                                      n
                                                                                    )
                                                                                    (<=
                                                                                      k
                                                                                      n-m
                                                                                  ) )
                                                                                  (let
                                                                                    ((j
                                                                                        (recur
                                                                                          subre
                                                                                          i
                                                                                    ))  )
                                                                                    (or
                                                                                      (and
                                                                                        j
                                                                                        (mul-recur
                                                                                          j
                                                                                          (+
                                                                                            k
                                                                                            1
                                                                                      ) ) )
                                                                                      (and
                                                                                        (funcall
                                                                                          dcsm
                                                                                          #'(lambda
                                                                                              nil
                                                                                              (seq-recur
                                                                                                rest
                                                                                                i
                                                                                        )   ) )
                                                                                        i
                                                                            ))  ) ) ) )
                                                                            (mul-recur
                                                                              i
                                                                              0
                                                            ))  ) ) ) ) ) ) )
                                                            (setq sub-match-stk
                                                              (case
                                                                (list-length
                                                                  sub-match-stk
                                                                )
                                                                ((0)
                                                                  left-match-stk
                                                                )
                                                                ((1)
                                                                  (cons
                                                                    (car
                                                                      sub-match-stk
                                                                    )
                                                                    left-match-stk
                                                                ) )
                                                                (t
                                                                  (cons
                                                                    (cadr
                                                                      sub-match-stk
                                                                    )
                                                                    left-match-stk
                                                            ) ) ) )
                                                            i
                                                      ) ) )
                                                      (recur re i)
                                      ))  ) ) ) ) ) )
                                      (seq-recur (cdr re) i)
                                  ) )
                                  ((:char-range)
                                    (and (< i n)
                                      (let ((s_i (char s i)))
                                        (and (char<= (cadr re) s_i)
                                          (char<= s_i (caddr re))
                                      ) )
                                      (+ i 1)
                                  ) )
                                  ((:one-of-chars)
                                    (and (< i n)
                                      (let ((chars (cdr re)))
                                        (flet
                                          ((loopj (chars)
                                              (throw 'loopj (values chars))
                                          ))
                                          (loop
                                            (multiple-value-setq (chars)
                                              (let ((chars chars))
                                                (catch 'loopj
                                                  (return
                                                    (if (null chars) nil
                                                      (or (recur (car chars) i)
                                                        (if t
                                                          (loopj (cdr chars))
                                  ) ) ) ) ) ) ) ) ) ) ) )
                                  ((:none-of-chars)
                                    (and (< i n)
                                      (let ((chars (cdr re)))
                                        (flet
                                          ((loopj (chars)
                                              (throw 'loopj (values chars))
                                          ))
                                          (loop
                                            (multiple-value-setq (chars)
                                              (let ((chars chars))
                                                (catch 'loopj
                                                  (return
                                                    (if (null chars) (+ i 1)
                                                      (if (recur (car chars) i)
                                                        nil
                                                        (if t
                                                          (loopj (cdr chars))
                                  ) ) ) ) ) ) ) ) ) ) ) )
                                  ((:sub)
                                    (let ((j (recur (cadr re) i)))
                                      (if collect-sub-matches?
                                        (setq sub-match-stk
                                          (cons (and j (cons i j))
                                            sub-match-stk
                                      ) ) )
                                      j
                ))  ) ) ) ) ) ) ) ) )
                (recur re i)
          ))  )
          (and k (cons (cons i k) (reverse sub-match-stk)))
) ) ) ) )
