; Test suite for SRFI-87
;
; $Id: srfi-87-test.sps 6215 2009-05-06 00:19:51Z will $

(import (except (rnrs base) case)
        (rnrs io simple)
        (srfi :87 case))

(define (writeln . xs)
  (for-each display xs)
  (newline))

(define (fail token . more)
  (writeln "Error: test failed: " token)
  #f)

(or (equal? (case (length (map sqrt '(1 4 9 16)))
              ((true) #t)
              ((false) #f)
              (else => (lambda (x) x)))
            4)
    (fail 'srfi-87))

(or (equal? (case (* 2 3)
             ((2 3 5 7) 'prime)
             ((1 4 6 8 9) 'composite))
            'composite)
    (fail 'srfi-87:composite))

(or (equal? (case (car '(c d))
             ((a) 'a)
             ((b) 'b))
            (if #f #f))
    (fail 'srfi-87:unspecified))

(or (equal? (case (car '(c d))
             ((a e i o u) 'vowel)
             ((w y) 'semivowel)
             (else 'consonant))
            'consonant)
    (fail 'srfi-87:consonant))

(writeln "Done.")
