
import java.util.*;

// functional iterator to traverse an ArrayList structure
// traverses the ArrayList from the last element to the first
// so that the last item added is visited first in a manner
// similar to the traversal of recursively generated list
public class ArrayListRange implements IRange{
	ArrayList slist;
	int current;
	
	// constructor starting at the last item in the ArrayList
	ArrayListRange(ArrayList slist){
		this.slist = slist;
		this.current = 0;
	}
	
	// constructor starting at the given index
	ArrayListRange(ArrayList slist, int current){
		if ((0 <= current) && (current <= slist.size())){
			this.slist = slist;
			this.current = current;
		}
		else
			throw new NoSuchElementException(
					"Initializing StringRange with current " + current +
					" and ArrayList size " + slist.size() );
	}
	
    /* move the cursor one forward, assuming it is possible */
    public IRange next(){
    		if (this.hasMore())
    			return new ArrayListRange(this.slist, this.current + 1);
    		else
    			throw new NoSuchElementException("No next element available.");   			
    }
    
    /* select the item to which the cursor points */
    public Object current(){
    		if (this.hasMore())
    			return this.slist.get(this.current);
    		else
    			throw new NoSuchElementException();
    }
    
    /* test whether there are more items in the range */
    public boolean hasMore(){
    		return this.current < this.slist.size();
    }
	
}