/* Algorithms.java  16 April 2003 */

import edu.neu.ccs.*;
import edu.neu.ccs.util.*;
import edu.neu.ccs.console.*;

import java.awt.*;
import java.math.*;
import java.util.*;

public class Algorithms implements ConsoleAware{
      
	// orMap method implemented recursively
	public boolean orMap(IRange it, ISelect predicate){
		if (it.hasMore())
			if (predicate.select(it.current()))
				return true;
			else
				return orMap(it.next(), predicate);
		else
			return false;
	}
	
	
	// filter method implemented recursively
	public ArrayList filter(IRange it, ISelect predicate){
		return filterAcc(it, predicate, new ArrayList());
	}
	
	public ArrayList filterAcc(IRange it, ISelect predicate, ArrayList alist){
		if (it.hasMore()){
			if (predicate.select(it.current())) 
				alist.add(it.current());
			return filterAcc(it.next(), predicate, alist);
		}
		else 
			return alist;
	}
	
	// filter implemented with Java 'while' loop
	ArrayList filterWhile(IRange it, ISelect predicate){
		ArrayList acc = new ArrayList();
		while(it.hasMore()){
			if (predicate.select(it.current()))
				acc.add(it.current());
			it = it.next();
		}
		return acc;
	}
	
	
	/**-----------------------------------------------------------------------*/
	/** helper methods to generate sample data for our problems --------------*/
	
	/** string to ArrayList of words - using space as separator */
    public ArrayList makeArrayList(String message){
    		ArrayList slist = new ArrayList();
        try{
            /** set up the string tokenizer to extract individual words*/
            StringTokenizer st = new StringTokenizer(message, " ");
            while (st.hasMoreTokens())           	
            		slist.add(st.nextToken());
            
            return slist;         
        }
        catch(NoSuchElementException e){
            console.out.println(e.getMessage());
        }
        return slist;
    }


    // produce sample data for the decryption
    public ArrayList sampleData(){
		String message = "envision but grindstone oh charm beamish precious " + 
		             "nephew excessively beware of pitiful leisure the " +  
					"glorious day if your hunt charming snark pursuit " + 
					"be a glorious boojum endure hope for then remark " + 
					"you will heed heart softly and excessively care " + 
					"suddenly hope vanish hark laughter away contrive " + 
					"and never utter evening be pretend met unfrequented " + 
					"with face again";
		return this.makeArrayList(message);
    }
    
    public ArrayList allowedPrefixes(){
    		String prefixes = "a b d f i m n o s t v w y";
    		return this.makeArrayList(prefixes);
    }
    
 }

