/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.quick;

public final class StringObjectPair {
    private String string = null;
    private Object object = null;

    public StringObjectPair(String string, Object object) {
        if (string == null || object == null) {
            throw new NullPointerException("null data item in StringObjectPair(String, Object) constructor");
        }
        this.string = string;
        this.object = object;
    }

    public StringObjectPair(Object[] objectArray) {
        if (objectArray == null) {
            throw new NullPointerException("null data array in StringObjectPair(Object[]) constructor");
        }
        if (objectArray.length != 2) {
            throw new IllegalArgumentException("data length != 2 in StringObjectPair(Object[]) constructor");
        }
        if (objectArray[0] == null || objectArray[1] == null) {
            throw new NullPointerException("null data item in StringObjectPair(Object[]) constructor");
        }
        if (!(objectArray[0] instanceof String)) {
            throw new IllegalArgumentException("data[0] is not String in StringObjectPair(Object[]) constructor");
        }
        this.string = (String)objectArray[0];
        this.object = objectArray[1];
    }

    public String getString() {
        return this.string;
    }

    public Object getObject() {
        return this.object;
    }

    public boolean equals(Object object) {
        if (!(object instanceof StringObjectPair)) {
            return false;
        }
        StringObjectPair stringObjectPair = (StringObjectPair)object;
        return this.string.equals(stringObjectPair.getString()) && this.object.equals(stringObjectPair.getObject());
    }

    public int hashCode() {
        return this.string.hashCode() ^ this.object.hashCode();
    }

    public String toString() {
        return "(" + this.string + ", " + this.object.toString() + ")";
    }

    public Object[] toArray() {
        return new Object[]{this.string, this.object};
    }

    public static StringObjectPair makeStringObjectPair(Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        if (!(object instanceof String)) {
            return null;
        }
        return new StringObjectPair((String)object, object2);
    }

    public static StringObjectPair makeStringObjectPair(Object[] objectArray) {
        try {
            return new StringObjectPair(objectArray);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public static Object[][] toArray(StringObjectPair[] stringObjectPairArray) {
        if (stringObjectPairArray == null) {
            return null;
        }
        int n = stringObjectPairArray.length;
        Object[][] objectArray = new Object[n][];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = stringObjectPairArray[n2] == null ? null : stringObjectPairArray[n2].toArray();
            ++n2;
        }
        return objectArray;
    }

    public static StringObjectPair[] toArray(Object[][] objectArray) {
        if (objectArray == null) {
            return null;
        }
        int n = objectArray.length;
        StringObjectPair[] stringObjectPairArray = new StringObjectPair[n];
        int n2 = 0;
        while (n2 < n) {
            stringObjectPairArray[n2] = StringObjectPair.makeStringObjectPair(objectArray[n2]);
            ++n2;
        }
        return stringObjectPairArray;
    }

    public static String[] getStrings(StringObjectPair[] stringObjectPairArray) {
        if (stringObjectPairArray == null) {
            return null;
        }
        int n = stringObjectPairArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringObjectPairArray[n2] == null ? null : stringObjectPairArray[n2].getString();
            ++n2;
        }
        return stringArray;
    }

    public static Object[] getObjects(StringObjectPair[] stringObjectPairArray) {
        if (stringObjectPairArray == null) {
            return null;
        }
        int n = stringObjectPairArray.length;
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = stringObjectPairArray[n2] == null ? null : stringObjectPairArray[n2].getObject();
            ++n2;
        }
        return objectArray;
    }
}

