/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Colors;
import edu.neu.ccs.gui.SwatchNamePair;
import edu.neu.ccs.quick.StringObjectMap;
import edu.neu.ccs.util.DimensionUtilities;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class SwatchNameRenderer
implements ListCellRenderer {
    private StringObjectMap nameCellMap;
    private Dimension maxDimension = new Dimension(0, 0);

    public SwatchNameRenderer() {
        String[] stringArray = Colors.getColorNamesAsArray();
        int n = stringArray.length;
        Object[][] objectArray = new Object[n][2];
        int n2 = 0;
        while (n2 < n) {
            SwatchNamePair swatchNamePair = new SwatchNamePair(stringArray[n2]);
            objectArray[n2][0] = stringArray[n2];
            objectArray[n2][1] = swatchNamePair;
            this.maxDimension = DimensionUtilities.max(this.maxDimension, swatchNamePair.getPreferredSize());
            ++n2;
        }
        this.nameCellMap = new StringObjectMap(objectArray);
    }

    private SwatchNamePair getListCellFromMap(String string) {
        return (SwatchNamePair)this.nameCellMap.getObject(string);
    }

    public String[] getStrings() {
        return this.nameCellMap.getStrings();
    }

    public Dimension getMaximumPreferredSize() {
        return DimensionUtilities.createDimension(this.maxDimension);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (!(object instanceof String)) {
            return null;
        }
        String string = (String)object;
        SwatchNamePair swatchNamePair = this.getListCellFromMap(string);
        if (swatchNamePair == null) {
            return null;
        }
        if (bl) {
            swatchNamePair.setBackground(jList.getSelectionBackground());
            swatchNamePair.setForeground(jList.getSelectionForeground());
        } else {
            swatchNamePair.setBackground(jList.getBackground());
            swatchNamePair.setForeground(jList.getForeground());
        }
        return swatchNamePair;
    }
}

