/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.AbstractPaintable;
import edu.neu.ccs.gui.PaintMode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ShapePaintable
extends AbstractPaintable {
    public static final Paint DEFAULT_FILLPAINT = Color.black;
    public static final Paint DEFAULT_DRAWPAINT = Color.black;
    public static final Stroke DEFAULT_DRAWSTROKE = new BasicStroke(1.0f);
    public static final String SET_SHAPE = "set.shape";
    public static final String SET_PAINT_MODE = "set.paint.mode";
    public static final String SET_FILL_PAINT = "set.fill.paint";
    public static final String SET_DRAW_PAINT = "set.draw.paint";
    public static final String SET_DRAW_STROKE = "set.draw.stroke";
    private Shape shape = null;
    private PaintMode paintmode = PaintMode.FILL;
    private Paint fillpaint = DEFAULT_FILLPAINT;
    private Paint drawpaint = DEFAULT_DRAWPAINT;
    private Stroke drawstroke = DEFAULT_DRAWSTROKE;

    public ShapePaintable() {
        this(null, null, null, null, null);
    }

    public ShapePaintable(Shape shape) {
        this(shape, null, null, null, null);
    }

    public ShapePaintable(Shape shape, PaintMode paintMode) {
        this(shape, paintMode, null, null, null);
    }

    public ShapePaintable(Shape shape, PaintMode paintMode, Paint paint) {
        this(shape, paintMode, paint, null, null);
    }

    public ShapePaintable(Shape shape, PaintMode paintMode, Paint paint, Paint paint2) {
        this(shape, paintMode, paint, paint2, null);
    }

    public ShapePaintable(Shape shape, PaintMode paintMode, Paint paint, Paint paint2, Stroke stroke) {
        this.setShape(shape);
        this.setPaintMode(paintMode);
        this.setFillPaint(paint);
        this.setDrawPaint(paint2);
        this.setDrawStroke(stroke);
    }

    public final void paint(Graphics graphics) {
        if (graphics == null || !this.isVisible()) {
            return;
        }
        this.paintmode.paint(this, graphics);
    }

    public final Rectangle2D getBounds2D() {
        Rectangle2D rectangle2D = this.getDefaultBounds2D();
        if (rectangle2D != null) {
            return rectangle2D;
        }
        if (this.shape == null) {
            return new Rectangle2D.Double();
        }
        rectangle2D = this.paintmode.getBounds2D(this);
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        if (d3 <= 0.0 || d4 <= 0.0) {
            return new Rectangle2D.Double(d, d2, 0.0, 0.0);
        }
        return rectangle2D;
    }

    public final Point2D getCenter() {
        if (this.shape == null) {
            return new Point2D.Double();
        }
        Point2D point2D = this.getDefaultCenter();
        if (point2D != null) {
            return point2D;
        }
        return super.getCenter();
    }

    public final boolean contains(double d, double d2) {
        if (!this.possiblyContains(d, d2)) {
            return false;
        }
        return this.paintmode.contains(this, d, d2);
    }

    public final void setShape(Shape shape) {
        if (shape == this.shape) {
            return;
        }
        this.removeAndAddForwardingListener(this.shape, shape);
        this.shape = shape;
        this.firePropertyChange(SET_SHAPE, null, null);
    }

    public final Shape getShape() {
        return this.shape;
    }

    public final Shape getStrokedShape() {
        if (this.shape == null) {
            return null;
        }
        return this.drawstroke.createStrokedShape(this.shape);
    }

    public Shape getOutline() {
        return this.paintmode.getOutline(this);
    }

    public final void setFillPaint(Paint paint) {
        if (paint == null || paint.equals(this.fillpaint)) {
            return;
        }
        this.removeAndAddForwardingListener(this.fillpaint, paint);
        this.fillpaint = paint;
        this.firePropertyChange(SET_FILL_PAINT, null, null);
    }

    public final Paint getFillPaint() {
        return this.fillpaint;
    }

    public final void setDrawPaint(Paint paint) {
        if (paint == null || paint.equals(this.drawpaint)) {
            return;
        }
        this.removeAndAddForwardingListener(this.drawpaint, paint);
        this.drawpaint = paint;
        this.firePropertyChange(SET_DRAW_PAINT, null, null);
    }

    public final Paint getDrawPaint() {
        return this.drawpaint;
    }

    public final void setDrawStroke(Stroke stroke) {
        if (stroke == null || stroke.equals(this.drawstroke)) {
            return;
        }
        this.removeAndAddForwardingListener(this.drawstroke, stroke);
        this.drawstroke = stroke;
        this.firePropertyChange(SET_DRAW_STROKE, null, null);
    }

    public final Stroke getDrawStroke() {
        return this.drawstroke;
    }

    public final void setPaintMode(PaintMode paintMode) {
        if (paintMode == null || paintMode.equals(this.paintmode)) {
            return;
        }
        this.removeAndAddForwardingListener(this.paintmode, paintMode);
        this.paintmode = paintMode;
        this.firePropertyChange(SET_PAINT_MODE, null, null);
    }

    public final PaintMode getPaintMode() {
        return this.paintmode;
    }

    public final void setFillMode() {
        this.setPaintMode(PaintMode.FILL);
    }

    public final void setDrawMode() {
        this.setPaintMode(PaintMode.DRAW);
    }

    public final void setFillDrawMode() {
        this.setPaintMode(PaintMode.FILL_DRAW);
    }
}

