/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.Interval;
import edu.neu.ccs.gui.PlotMark;
import edu.neu.ccs.gui.Transform1D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class PlotTool
implements Cloneable,
Serializable {
    private static final int DEFAULT_WINDOW_SIZE = 400;
    private static final boolean DEFAULT_EQUALIZE = false;
    private static final int DEFAULT_INSET = 0;
    private static final int DEFAULT_AXES_SIZE = 3;
    private static final int MINIMUM_GRID_PIXELS = 20;
    private static final int MINIMUM_TICK_PIXELS = 8;
    private static final int DEFAULT_TICK_SIZE = 5;
    private static final Color DEFAULT_PLOT_COLOR = Color.black;
    private static final Color DEFAULT_AXES_COLOR = Color.black;
    private static final Color DEFAULT_GRID_COLOR = Color.gray;
    private static final Color DEFAULT_TICK_COLOR = Color.red;
    private static final BasicStroke DEFAULT_STROKE = new BasicStroke(1.0f);
    protected Rectangle2D.Double worldBounds = null;
    protected Rectangle2D.Double imageBounds = null;
    protected boolean preservesShape = false;
    protected int inset = 0;
    protected AffineTransform mapping = new AffineTransform();
    protected Transform1D xMapping = new Transform1D();
    protected Transform1D yMapping = new Transform1D();
    protected AffineTransform inverseMapping = new AffineTransform();
    protected Transform1D inverseXMapping = new Transform1D();
    protected Transform1D inverseYMapping = new Transform1D();
    protected Interval worldXRange = new Interval();
    protected Interval worldYRange = new Interval();
    protected Interval imageXRange = new Interval();
    protected Interval imageYRange = new Interval();
    protected Point2D.Double scale = new Point2D.Double();
    protected transient Point2D.Double P = new Point2D.Double();
    protected transient Point2D.Double Q = new Point2D.Double();
    protected transient Line2D.Double L = new Line2D.Double();

    public PlotTool() {
        this.setPlotTool(null, null, false, 0);
    }

    public PlotTool(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        this.setPlotTool(rectangle2D, rectangle2D2, false, 0);
    }

    public PlotTool(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl) {
        this.setPlotTool(rectangle2D, rectangle2D2, bl, 0);
    }

    public PlotTool(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl, int n) {
        this.setPlotTool(rectangle2D, rectangle2D2, bl, n);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.P = new Point2D.Double();
        this.Q = new Point2D.Double();
        this.L = new Line2D.Double();
    }

    public PlotTool setPlotTool(PlotTool plotTool) {
        if (plotTool != null) {
            return this.setPlotTool(plotTool.worldBounds, plotTool.imageBounds, plotTool.preservesShape, plotTool.inset);
        }
        return this;
    }

    public PlotTool setPlotTool(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl, int n) {
        this.storeWorldBounds(rectangle2D);
        this.storeImageBounds(rectangle2D2);
        this.storePreservesShape(bl);
        this.storeInset(n);
        return this.setTransforms();
    }

    public PlotTool setWorldBounds(Rectangle2D rectangle2D) {
        this.storeWorldBounds(rectangle2D);
        return this.setTransforms();
    }

    public Rectangle2D getWorldBounds() {
        return (Rectangle2D)this.worldBounds.clone();
    }

    public PlotTool setWorldBounds(Point2D[] point2DArray) {
        return this.setWorldBounds(PlotTool.makeBoundsRectangle2D(point2DArray));
    }

    public PlotTool setWorldBounds(Point2D[][] point2DArray) {
        return this.setWorldBounds(PlotTool.makeBoundsRectangle2D(point2DArray));
    }

    public static Rectangle2D makeBoundsRectangle2D(Point2D[] point2DArray) {
        Rectangle2D rectangle2D = null;
        boolean bl = true;
        if (point2DArray != null) {
            int n = point2DArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (point2DArray[n2] != null) {
                    double d = point2DArray[n2].getX();
                    double d2 = point2DArray[n2].getY();
                    if (bl) {
                        rectangle2D = new Rectangle2D.Double(d, d2, 0.0, 0.0);
                        bl = false;
                    } else {
                        rectangle2D.add(d, d2);
                    }
                }
                ++n2;
            }
        }
        return rectangle2D;
    }

    public static Rectangle2D makeBoundsRectangle2D(Point2D[][] point2DArray) {
        Rectangle2D rectangle2D = null;
        boolean bl = true;
        if (point2DArray != null) {
            int n = point2DArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (point2DArray[n2] != null) {
                    int n3 = point2DArray[n2].length;
                    int n4 = 0;
                    while (n4 < n3) {
                        if (point2DArray[n2][n4] != null) {
                            double d = point2DArray[n2][n4].getX();
                            double d2 = point2DArray[n2][n4].getY();
                            if (bl) {
                                rectangle2D = new Rectangle2D.Double(d, d2, 0.0, 0.0);
                                bl = false;
                            } else {
                                rectangle2D.add(d, d2);
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return rectangle2D;
    }

    public PlotTool setImageBounds(Rectangle2D rectangle2D) {
        this.storeImageBounds(rectangle2D);
        return this.setTransforms();
    }

    public Rectangle2D getImageBounds() {
        return (Rectangle2D)this.imageBounds.clone();
    }

    public PlotTool setPreservesShape(boolean bl) {
        this.storePreservesShape(bl);
        return this.setTransforms();
    }

    public boolean preservesShape() {
        return this.preservesShape;
    }

    public PlotTool setInset(int n) {
        this.storeInset(n);
        return this.setTransforms();
    }

    public int getInset() {
        return this.inset;
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.mapping);
    }

    public Transform1D getXTransform() {
        return new Transform1D(this.xMapping.getFactor(), this.xMapping.getOffset());
    }

    public Transform1D getYTransform() {
        return new Transform1D(this.yMapping.getFactor(), this.yMapping.getOffset());
    }

    public AffineTransform getInverseTransform() {
        return new AffineTransform(this.inverseMapping);
    }

    public Transform1D getInverseXTransform() {
        return new Transform1D(this.inverseXMapping.getFactor(), this.inverseXMapping.getOffset());
    }

    public Transform1D getInverseYTransform() {
        return new Transform1D(this.inverseYMapping.getFactor(), this.inverseYMapping.getOffset());
    }

    public Point2D scale(Point2D point2D, Point2D point2D2) {
        return this.mapping.transform(point2D, point2D2);
    }

    public Point2D scale(Point2D point2D) {
        return this.scale(point2D, null);
    }

    public double xScale(double d) {
        return this.xMapping.transform(d);
    }

    public double yScale(double d) {
        return this.yMapping.transform(d);
    }

    public Point2D inverseScale(Point2D point2D, Point2D point2D2) {
        return this.inverseMapping.transform(point2D, point2D2);
    }

    public Point2D inverseScale(Point2D point2D) {
        return this.inverseScale(point2D, null);
    }

    public double inverseXScale(double d) {
        return this.inverseXMapping.transform(d);
    }

    public double inverseYScale(double d) {
        return this.inverseYMapping.transform(d);
    }

    public void plotData(Graphics2D graphics2D, Point2D[] point2DArray, Paint paint) {
        this.plotData(graphics2D, point2DArray, paint, (Stroke)DEFAULT_STROKE);
    }

    public void plotData(Graphics2D graphics2D, Point2D[] point2DArray, Paint paint, Stroke stroke) {
        if (graphics2D == null || point2DArray == null) {
            return;
        }
        if (paint != null) {
            graphics2D.setPaint(paint);
        } else {
            graphics2D.setPaint(DEFAULT_PLOT_COLOR);
        }
        if (stroke != null) {
            graphics2D.setStroke(stroke);
        } else {
            graphics2D.setStroke(DEFAULT_STROKE);
        }
        int n = point2DArray.length;
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            if (point2DArray[n2] != null) {
                if (bl) {
                    this.scale(point2DArray[n2], this.P);
                    bl = false;
                } else {
                    this.scale(point2DArray[n2], this.Q);
                    this.L.setLine(this.P, this.Q);
                    graphics2D.draw(this.L);
                    this.P.setLocation(this.Q);
                }
            }
            ++n2;
        }
    }

    public void plotData(Graphics2D graphics2D, Point2D[][] point2DArray, Paint paint) {
        this.plotData(graphics2D, point2DArray, paint, (Stroke)DEFAULT_STROKE);
    }

    public void plotData(Graphics2D graphics2D, Point2D[][] point2DArray, Paint paint, Stroke stroke) {
        if (graphics2D == null || point2DArray == null) {
            return;
        }
        int n = point2DArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.plotData(graphics2D, point2DArray[n2], paint, stroke);
            ++n2;
        }
    }

    public void plotData(Graphics2D graphics2D, Point2D[][] point2DArray, Paint[] paintArray) {
        this.plotData(graphics2D, point2DArray, paintArray, (Stroke)DEFAULT_STROKE);
    }

    public void plotData(Graphics2D graphics2D, Point2D[][] point2DArray, Paint[] paintArray, Stroke stroke) {
        if (graphics2D == null || point2DArray == null) {
            return;
        }
        if (paintArray == null) {
            paintArray = new Paint[]{DEFAULT_PLOT_COLOR};
        }
        int n = point2DArray.length;
        int n2 = paintArray.length;
        int n3 = 0;
        while (n3 < n) {
            int n4 = n3 % n2;
            this.plotData(graphics2D, point2DArray[n3], paintArray[n4], stroke);
            ++n3;
        }
    }

    public void markData(Graphics2D graphics2D, Point2D[] point2DArray, Paint paint, PlotMark plotMark) {
        if (graphics2D == null || point2DArray == null || plotMark == null) {
            return;
        }
        if (paint != null) {
            graphics2D.setPaint(paint);
        } else {
            graphics2D.setPaint(DEFAULT_PLOT_COLOR);
        }
        graphics2D.setStroke(DEFAULT_STROKE);
        int n = point2DArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (point2DArray[n2] != null) {
                this.scale(point2DArray[n2], this.P);
                plotMark.mark(graphics2D, this.P);
            }
            ++n2;
        }
    }

    public void markData(Graphics2D graphics2D, Point2D[][] point2DArray, Paint paint, PlotMark plotMark) {
        if (graphics2D == null || point2DArray == null || plotMark == null) {
            return;
        }
        int n = point2DArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.markData(graphics2D, point2DArray[n2], paint, plotMark);
            ++n2;
        }
    }

    public void markData(Graphics2D graphics2D, Point2D[][] point2DArray, Paint[] paintArray, PlotMark plotMark) {
        if (graphics2D == null || point2DArray == null || plotMark == null) {
            return;
        }
        if (paintArray == null) {
            paintArray = new Paint[]{DEFAULT_PLOT_COLOR};
        }
        int n = point2DArray.length;
        int n2 = paintArray.length;
        int n3 = 0;
        while (n3 < n) {
            int n4 = n3 % n2;
            this.markData(graphics2D, point2DArray[n3], paintArray[n4], plotMark);
            ++n3;
        }
    }

    public void plotVGridLine(Graphics2D graphics2D, double d) {
        if (graphics2D == null) {
            return;
        }
        double d2 = this.xScale(d);
        this.L.setLine(d2, this.imageYRange.getMinimum(), d2, this.imageYRange.getMaximum());
        graphics2D.draw(this.L);
    }

    public void plotHGridLine(Graphics2D graphics2D, double d) {
        if (graphics2D == null) {
            return;
        }
        double d2 = this.yScale(d);
        this.L.setLine(this.imageXRange.getMinimum(), d2, this.imageXRange.getMaximum(), d2);
        graphics2D.draw(this.L);
    }

    public void plotVTickMark(Graphics2D graphics2D, double d, int n) {
        if (graphics2D == null) {
            return;
        }
        double d2 = this.xScale(d);
        double d3 = this.yScale(0.0);
        this.L.setLine(d2, d3 - (double)n, d2, d3 + (double)n);
        graphics2D.draw(this.L);
    }

    public void plotHTickMark(Graphics2D graphics2D, double d, int n) {
        if (graphics2D == null) {
            return;
        }
        double d2 = this.xScale(0.0);
        double d3 = this.yScale(d);
        this.L.setLine(d2 - (double)n, d3, d2 + (double)n, d3);
        graphics2D.draw(this.L);
    }

    public int xMinIndex(double d) {
        if (this.scale.x == 0.0 || d <= 0.0) {
            return 0;
        }
        double d2 = this.inverseXScale(this.imageXRange.getMinimum());
        return (int)Math.floor(d2 / d);
    }

    public int yMinIndex(double d) {
        if (this.scale.y == 0.0 || d <= 0.0) {
            return 0;
        }
        double d2 = this.inverseYScale(this.imageYRange.getMaximum());
        return (int)Math.floor(d2 / d);
    }

    public int xMaxIndex(double d) {
        if (this.scale.x == 0.0 || d <= 0.0) {
            return 0;
        }
        double d2 = this.inverseXScale(this.imageXRange.getMaximum());
        return (int)Math.ceil(d2 / d);
    }

    public int yMaxIndex(double d) {
        if (this.scale.y == 0.0 || d <= 0.0) {
            return 0;
        }
        double d2 = this.inverseYScale(this.imageYRange.getMinimum());
        return (int)Math.ceil(d2 / d);
    }

    public PlotTool plotVGridLines(Graphics2D graphics2D, Paint paint, double d) {
        if (graphics2D == null || this.scale.x == 0.0 || d == 0.0) {
            return this;
        }
        if (paint != null) {
            graphics2D.setPaint(paint);
        } else {
            graphics2D.setPaint(DEFAULT_GRID_COLOR);
        }
        graphics2D.setStroke(DEFAULT_STROKE);
        d = Math.abs(d);
        int n = this.xMinIndex(d);
        int n2 = this.xMaxIndex(d);
        int n3 = n;
        while (n3 <= n2) {
            this.plotVGridLine(graphics2D, (double)n3 * d);
            ++n3;
        }
        return this;
    }

    public PlotTool plotHGridLines(Graphics2D graphics2D, Paint paint, double d) {
        if (graphics2D == null || this.scale.y == 0.0 || d == 0.0) {
            return this;
        }
        if (paint != null) {
            graphics2D.setPaint(paint);
        } else {
            graphics2D.setPaint(DEFAULT_GRID_COLOR);
        }
        graphics2D.setStroke(DEFAULT_STROKE);
        d = Math.abs(d);
        int n = this.yMinIndex(d);
        int n2 = this.yMaxIndex(d);
        int n3 = n;
        while (n3 <= n2) {
            this.plotHGridLine(graphics2D, (double)n3 * d);
            ++n3;
        }
        return this;
    }

    public PlotTool plotGridLines(Graphics2D graphics2D, Paint paint, Point2D point2D) {
        if (graphics2D == null || point2D == null) {
            return this;
        }
        this.plotVGridLines(graphics2D, paint, point2D.getX());
        this.plotHGridLines(graphics2D, paint, point2D.getY());
        return this;
    }

    public PlotTool plotVTickMarks(Graphics2D graphics2D, Paint paint, double d, int n) {
        if (graphics2D == null || this.scale.x == 0.0 || d == 0.0) {
            return this;
        }
        if (paint != null) {
            graphics2D.setPaint(paint);
        } else {
            graphics2D.setPaint(DEFAULT_TICK_COLOR);
        }
        graphics2D.setStroke(DEFAULT_STROKE);
        d = Math.abs(d);
        int n2 = this.xMinIndex(d);
        int n3 = this.xMaxIndex(d);
        int n4 = n2;
        while (n4 <= n3) {
            this.plotVTickMark(graphics2D, (double)n4 * d, n);
            ++n4;
        }
        return this;
    }

    public PlotTool plotHTickMarks(Graphics2D graphics2D, Paint paint, double d, int n) {
        if (graphics2D == null || this.scale.y == 0.0 || d == 0.0) {
            return this;
        }
        if (paint != null) {
            graphics2D.setPaint(paint);
        } else {
            graphics2D.setPaint(DEFAULT_TICK_COLOR);
        }
        graphics2D.setStroke(DEFAULT_STROKE);
        d = Math.abs(d);
        int n2 = this.yMinIndex(d);
        int n3 = this.yMaxIndex(d);
        int n4 = n2;
        while (n4 <= n3) {
            this.plotHTickMark(graphics2D, (double)n4 * d, n);
            ++n4;
        }
        return this;
    }

    public PlotTool plotTickMarks(Graphics2D graphics2D, Paint paint, Point2D point2D, int n) {
        if (graphics2D == null || point2D == null) {
            return this;
        }
        this.plotVTickMarks(graphics2D, paint, point2D.getX(), n);
        this.plotHTickMarks(graphics2D, paint, point2D.getY(), n);
        return this;
    }

    public static double findSpacing(double d) {
        if (d == 0.0) {
            return 0.0;
        }
        d = Math.abs(d);
        double d2 = 1.0;
        double d3 = 10.0;
        while (d3 < d) {
            d2 = d3;
            d3 *= 10.0;
        }
        while (d2 >= d) {
            d3 = d2;
            d2 /= 10.0;
        }
        if (2.0 * d2 >= d) {
            return 2.0 * d2;
        }
        if (5.0 * d2 >= d) {
            return 5.0 * d2;
        }
        return d3;
    }

    public Point2D autoSpacing(int n) {
        n = Math.abs(n);
        Point2D.Double double_ = new Point2D.Double();
        double_.x = this.scale.x > 0.0 ? (double)n / this.scale.x : 0.0;
        double_.y = this.scale.y > 0.0 ? (double)n / this.scale.y : 0.0;
        double_.x = PlotTool.findSpacing(double_.x);
        double_.y = PlotTool.findSpacing(double_.y);
        if (this.preservesShape && double_.x != 0.0 && double_.y != 0.0) {
            if (double_.x < double_.y) {
                double_.x = double_.y;
            } else {
                double_.y = double_.x;
            }
        }
        return double_;
    }

    public PlotTool autoGridLines(Graphics2D graphics2D) {
        return this.plotGridLines(graphics2D, DEFAULT_GRID_COLOR, this.autoSpacing(20));
    }

    public PlotTool autoTickMarks(Graphics2D graphics2D) {
        return this.plotTickMarks(graphics2D, DEFAULT_TICK_COLOR, this.autoSpacing(8), 5);
    }

    public PlotTool plotAxes(Graphics2D graphics2D, Paint paint, int n) {
        if (graphics2D == null) {
            return this;
        }
        if (paint != null) {
            graphics2D.setPaint(paint);
        } else {
            graphics2D.setPaint(DEFAULT_AXES_COLOR);
        }
        graphics2D.setStroke(new BasicStroke(Math.abs(n)));
        this.plotVGridLine(graphics2D, 0.0);
        this.plotHGridLine(graphics2D, 0.0);
        graphics2D.setStroke(DEFAULT_STROKE);
        return this;
    }

    public PlotTool autoAxes(Graphics2D graphics2D) {
        return this.plotAxes(graphics2D, DEFAULT_AXES_COLOR, 3);
    }

    protected void storeWorldBounds(Rectangle2D rectangle2D) {
        this.worldBounds = rectangle2D != null ? new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight()) : new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
    }

    public void storeImageBounds(Rectangle2D rectangle2D) {
        this.imageBounds = rectangle2D != null ? new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight()) : new Rectangle2D.Double(0.0, 0.0, 400.0, 400.0);
    }

    protected void storePreservesShape(boolean bl) {
        this.preservesShape = bl;
    }

    protected void storeInset(int n) {
        this.inset = n > 0 ? n : 0;
    }

    protected PlotTool setTransforms() {
        this.worldXRange.setEndpoints(this.worldBounds.x, this.worldBounds.x + this.worldBounds.width);
        this.worldYRange.setEndpoints(this.worldBounds.y, this.worldBounds.y + this.worldBounds.height);
        this.imageXRange.setEndpoints(this.imageBounds.x, this.imageBounds.x + this.imageBounds.width);
        this.imageYRange.setEndpoints(this.imageBounds.y, this.imageBounds.y + this.imageBounds.height);
        this.scale.x = 0.0;
        this.scale.y = 0.0;
        double d = 0.0;
        if (this.worldXRange.getSize() != 0.0 && (d = this.imageXRange.getSize() - (double)(2 * this.inset)) > 0.0) {
            this.scale.x = d / this.worldXRange.getSize();
        }
        if (this.worldYRange.getSize() != 0.0 && (d = this.imageYRange.getSize() - (double)(2 * this.inset)) > 0.0) {
            this.scale.y = d / this.worldYRange.getSize();
        }
        if (this.preservesShape && this.scale.x != 0.0 && this.scale.y != 0.0) {
            if (this.scale.x > this.scale.y) {
                this.scale.x = this.scale.y;
            } else {
                this.scale.y = this.scale.x;
            }
        }
        double d2 = this.scale.x;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = -this.scale.y;
        double d6 = this.imageXRange.getMidpoint() - d2 * this.worldXRange.getMidpoint();
        double d7 = this.imageYRange.getMidpoint() - d5 * this.worldYRange.getMidpoint();
        this.mapping.setTransform(d2, d3, d4, d5, d6, d7);
        this.xMapping.setTransform(d2, d6);
        this.yMapping.setTransform(d5, d7);
        if (d2 != 0.0) {
            d2 = 1.0 / d2;
        }
        if (d5 != 0.0) {
            d5 = 1.0 / d5;
        }
        d6 = this.worldXRange.getMidpoint() - d2 * this.imageXRange.getMidpoint();
        d7 = this.worldYRange.getMidpoint() - d5 * this.imageYRange.getMidpoint();
        this.inverseMapping.setTransform(d2, d3, d4, d5, d6, d7);
        this.inverseXMapping.setTransform(d2, d6);
        this.inverseYMapping.setTransform(d5, d7);
        return this;
    }
}

