/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.AbstractPaintable;
import edu.neu.ccs.gui.Annotation;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.ImagePaintableLite;
import edu.neu.ccs.gui.JPTScrollPane;
import edu.neu.ccs.gui.MutatableWrapper;
import edu.neu.ccs.gui.TablePanel;
import edu.neu.ccs.gui.TransformFactory;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;

public class ImageViewerBase
extends DisplayPanel {
    protected String[] imageFileNames;
    protected ImagePaintableLite[] paintables;
    protected int X_MAX = 0;
    protected int Y_MAX = 0;
    protected int Y_MAX_SMALL = 0;

    protected ImageViewerBase() {
    }

    protected JPTScrollPane makeGUI(boolean bl) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.X_MAX = dimension.width - 150;
        this.Y_MAX = dimension.height - 150;
        this.Y_MAX_SMALL = this.Y_MAX - 2 * ImageViewerBase.getAnnotationHeight();
        int n = this.imageFileNames.length;
        TablePanel tablePanel = new TablePanel(n, 1, 0, 0, 0);
        int n2 = 0;
        while (n2 < n) {
            tablePanel.addObject((Object)this.makeInnerGUI(n2, bl), n2, 0);
            ++n2;
        }
        Dimension dimension2 = tablePanel.getPreferredSize();
        dimension2.width = dimension2.width <= this.X_MAX ? dimension2.width : this.X_MAX;
        dimension2.height = dimension2.height <= this.Y_MAX ? dimension2.height : this.Y_MAX;
        JPTScrollPane jPTScrollPane = new JPTScrollPane(tablePanel);
        jPTScrollPane.boundViewportPreferredSize(dimension2);
        return jPTScrollPane;
    }

    protected TablePanel makeInnerGUI(int n, boolean bl) {
        AbstractPaintable abstractPaintable = this.paintables[n];
        int n2 = this.paintables[n].getImageWidth();
        int n3 = this.paintables[n].getImageHeight();
        String string = this.imageFileNames[n];
        String string2 = "#" + n + ": " + n2 + " x " + n3;
        if (bl && (n2 > this.X_MAX || n3 > this.Y_MAX_SMALL)) {
            double d = (double)this.X_MAX / (double)n2;
            double d2 = (double)this.Y_MAX_SMALL / (double)n3;
            double d3 = Math.min(d, d2);
            AffineTransform affineTransform = TransformFactory.scale(0.0, 0.0, 0.0, d3, d3);
            abstractPaintable = new MutatableWrapper(abstractPaintable, affineTransform);
        }
        return new TablePanel(new Object[]{abstractPaintable, string, string2}, 1, 0, 0, 0);
    }

    protected static int getAnnotationHeight() {
        Annotation annotation = new Annotation("Xy");
        Dimension dimension = annotation.getPreferredSize();
        return dimension.height;
    }
}

