/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.Annotation;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.Displayable;
import edu.neu.ccs.util.JPTUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class Display
extends DisplayPanel {
    public static final String ANNOTATION_TEXT = "annotation.text";
    public static final String ANNOTATION_ALIGNMENT = "annotation.alignment";
    public static final String TITLE_TEXT = "title.text";
    public static final String TITLE_ALIGNMENT = "title.alignment";
    public static final String DISPLAY = "display";
    public static final String ANNOTATION = "annotation";
    public static final String DEFAULT_ANNOTATION_TEXT = null;
    public static final String DEFAULT_TITLE_TEXT = null;
    public static final int DEFAULT_ANNOTATION_ALIGNMENT = 2;
    public static final int DEFAULT_TITLE_ALIGNMENT = 1;
    protected String title = null;
    protected int aAlign = 2;
    protected int tAlign = 1;
    protected Displayable view = null;
    protected Annotation caption = null;

    public Display() {
        this(new DisplayPanel(), null, null, 2, 1);
    }

    public Display(Displayable displayable) {
        this(displayable, null, null, 2, 1);
    }

    public Display(Displayable displayable, String string, String string2) {
        this(displayable, string, string2, 2, 1);
    }

    public Display(Displayable displayable, String string, String string2, int n, int n2) {
        this.setLayout(new BorderLayout(5, 5));
        this.setDisplay(displayable);
        this.setAnnotation(new Annotation(string));
        this.setAnnotationAlignment(n);
        this.setTitleText(string2);
        this.setTitleAlignment(n2);
    }

    public Display(Displayable displayable, Settings settings) {
        this(displayable, settings != null ? settings.annotationText : null, settings != null ? settings.titleText : null, settings != null ? settings.annotationAlign : 2, settings != null ? settings.titleAlign : 1);
    }

    public void setViewState(String string) {
        this.view.setViewState(string);
        this.firePropertyChange("view.state", null, string);
    }

    public String getViewState() {
        return this.view.getViewState();
    }

    public void setDefaultViewState(String string) {
        this.view.setDefaultViewState(string);
        this.firePropertyChange("default.view.state", null, string);
    }

    public void setAnnotationText(String string) {
        String string2 = this.getAnnotationText();
        if (this.caption == null) {
            this.setAnnotation(new Annotation(string));
        } else {
            this.caption.setText(string);
        }
        if (this.getAnnotationText() != null && !this.getAnnotationText().equals(string2)) {
            this.firePropertyChange(ANNOTATION_TEXT, string2, string);
        }
    }

    public String getAnnotationText() {
        if (this.caption == null) {
            return null;
        }
        return this.caption.getText();
    }

    public void setAnnotationAlignment(int n) {
        int n2 = this.getAnnotationAlignment();
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.aAlign = n;
                break;
            }
            case -1: {
                this.aAlign = 2;
                break;
            }
            default: {
                return;
            }
        }
        this.revalidateAnnotationAndAlignment();
        if (this.getAnnotationAlignment() != n2) {
            this.firePropertyChange(ANNOTATION_ALIGNMENT, n2, this.getAnnotationAlignment());
        }
    }

    public int getAnnotationAlignment() {
        return this.aAlign;
    }

    public void setTitleText(String string) {
        String string2 = this.getTitleText();
        this.title = string;
        this.revalidateTitleAndAlignment();
        if (this.getTitleText() != null && !this.getTitleText().equals(string2)) {
            this.firePropertyChange(TITLE_TEXT, string2, this.getTitleText());
        }
    }

    public String getTitleText() {
        return this.title;
    }

    public void setTitleAlignment(int n) {
        int n2 = this.getTitleAlignment();
        switch (n) {
            case 1: 
            case 3: {
                this.tAlign = n;
                break;
            }
            case -1: {
                this.tAlign = 1;
                break;
            }
            default: {
                return;
            }
        }
        this.revalidateTitleAndAlignment();
        if (this.getTitleAlignment() != n2) {
            this.firePropertyChange(ANNOTATION_ALIGNMENT, n2, this.getTitleAlignment());
        }
    }

    public int getTitleAlignment() {
        return this.tAlign;
    }

    public void setDisplay(Displayable displayable) {
        Displayable displayable2 = this.getDisplay();
        if (displayable != displayable2) {
            if (this.view != null) {
                this.remove((Component)((Object)this.view));
            }
            if (displayable == null) {
                displayable = new DisplayPanel();
            }
            this.view = displayable;
            this.add((Component)((Object)this.view), "Center");
            this.revalidate();
            this.firePropertyChange(DISPLAY, displayable2, this.getDisplay());
        }
    }

    public Displayable getDisplay() {
        return this.view;
    }

    public void setAnnotation(Annotation annotation) {
        Annotation annotation2 = this.getAnnotation();
        if (this.caption != null) {
            super.remove(this.caption);
            this.caption = null;
        }
        if (annotation != null) {
            this.caption = annotation;
            super.add((Component)this.caption, JPTUtilities.getBorderLayoutLocation(this.aAlign));
        }
        this.revalidate();
        if (annotation != annotation2) {
            this.firePropertyChange(ANNOTATION, annotation2, this.getAnnotation());
        }
    }

    public Annotation getAnnotation() {
        return this.caption;
    }

    public void setSettings(Settings settings) {
        if (settings != null) {
            this.setAnnotationText(settings.annotationText);
            this.setTitleText(settings.titleText);
            this.setAnnotationAlignment(settings.annotationAlign);
            this.setTitleAlignment(settings.titleAlign);
        } else {
            this.setAnnotationText(null);
            this.setTitleText(null);
            this.setAnnotationAlignment(2);
            this.setTitleAlignment(1);
        }
    }

    public Settings getSettings() {
        return new Settings(this.getAnnotationText(), this.getTitleText(), this.getAnnotationAlignment(), this.getTitleAlignment());
    }

    protected void revalidateTitleAndAlignment() {
        if (this.title != null) {
            int n = this.tAlign == 1 ? 2 : 5;
            this.setBorder(new CompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(), " " + this.title + " ", 2, n), new EmptyBorder(5, 5, 5, 5)));
        } else {
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        this.revalidate();
    }

    protected void revalidateAnnotationAndAlignment() {
        if (this.caption != null) {
            super.remove(this.caption);
            super.add((Component)this.caption, JPTUtilities.getBorderLayoutLocation(this.aAlign));
        }
        this.revalidate();
    }

    public static class Settings
    implements Cloneable,
    Serializable {
        public String annotationText = null;
        public String titleText = null;
        public int annotationAlign = 2;
        public int titleAlign = 1;

        public Settings(String string, String string2, int n, int n2) {
            this.annotationText = string;
            this.titleText = string2;
            this.annotationAlign = n;
            this.titleAlign = n2;
        }
    }
}

