/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.Function;
import edu.neu.ccs.gui.Interval;
import java.awt.geom.Point2D;

public class DataTables2D {
    public static Point2D[] makeTable(Function.OneArg oneArg, Interval interval, int n) {
        if (oneArg == null || interval == null) {
            return null;
        }
        double d = interval.getMinimum();
        double d2 = interval.getMaximum();
        if (n < 1) {
            n = 1;
        }
        double d3 = (d2 - d) / (double)n;
        Point2D[] point2DArray = new Point2D[n + 1];
        int n2 = 0;
        while (n2 <= n) {
            double d4 = n2 < n ? d + (double)n2 * d3 : d2;
            double d5 = oneArg.evaluate(d4);
            point2DArray[n2] = new Point2D.Double(d4, d5);
            ++n2;
        }
        return point2DArray;
    }

    public static Point2D[] makeTable(Function.OneArg oneArg, double d, double d2, int n) {
        return DataTables2D.makeTable(oneArg, new Interval(d, d2), n);
    }

    public static Point2D[][] makeTable(Function.OneArg[] oneArgArray, Interval interval, int n) {
        if (oneArgArray == null || interval == null) {
            return null;
        }
        int n2 = oneArgArray.length;
        Point2D[][] point2DArray = new Point2D[n2][];
        int n3 = 0;
        while (n3 < n2) {
            point2DArray[n3] = DataTables2D.makeTable(oneArgArray[n3], interval, n);
            ++n3;
        }
        return point2DArray;
    }

    public static Point2D[][] makeTable(Function.OneArg[] oneArgArray, double d, double d2, int n) {
        return DataTables2D.makeTable(oneArgArray, new Interval(d, d2), n);
    }
}

