/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.AbstractPaintable;
import edu.neu.ccs.gui.Paintable;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ClippingWrapper
extends AbstractPaintable {
    public static final String SET_PAINTABLE = "set.paintable";
    public static final String SET_CLIPPING_SHAPE = "set.clipping.shape";
    private Paintable paintable = null;
    private Shape clippingshape = null;

    public ClippingWrapper() {
    }

    public ClippingWrapper(Paintable paintable) {
        this.setPaintable(paintable);
    }

    public ClippingWrapper(Paintable paintable, Shape shape) {
        this.setPaintable(paintable);
        this.setClippingShape(shape);
    }

    public final void paint(Graphics graphics) {
        if (this.paintable == null || graphics == null || !this.isVisible()) {
            return;
        }
        Graphics2D graphics2D = this.getPreparedGraphics2D(graphics);
        if (this.clippingshape != null) {
            graphics2D.clip(this.clippingshape);
        }
        this.paintable.paint(graphics2D);
    }

    public final void setPaintable(Paintable paintable) {
        if (paintable == this.paintable) {
            return;
        }
        this.removeAndAddForwardingListener(this.paintable, paintable);
        this.paintable = paintable;
        this.firePropertyChange(SET_PAINTABLE, null, null);
    }

    public final Paintable getPaintable() {
        return this.paintable;
    }

    public final void setClippingShape(Shape shape) {
        if (shape == this.clippingshape) {
            return;
        }
        this.removeAndAddForwardingListener(this.clippingshape, shape);
        this.clippingshape = shape;
        this.firePropertyChange(SET_CLIPPING_SHAPE, null, null);
    }

    public final Shape getClippingShape() {
        return this.clippingshape;
    }

    public final Rectangle2D getBounds2D() {
        Rectangle2D rectangle2D = this.getDefaultBounds2D();
        if (rectangle2D != null) {
            return rectangle2D;
        }
        if (this.paintable == null) {
            return new Rectangle2D.Double();
        }
        rectangle2D = this.paintable.getBounds2D();
        if (this.clippingshape != null) {
            Rectangle2D rectangle2D2 = this.clippingshape.getBounds2D();
            rectangle2D = rectangle2D.createIntersection(rectangle2D2);
            double d = rectangle2D.getX();
            double d2 = rectangle2D.getY();
            double d3 = rectangle2D.getWidth();
            double d4 = rectangle2D.getHeight();
            if (d3 <= 0.0 || d4 <= 0.0) {
                rectangle2D.setRect(d, d2, 0.0, 0.0);
            }
        }
        return rectangle2D;
    }

    public final Point2D getCenter() {
        if (this.paintable == null) {
            return new Point2D.Double();
        }
        Point2D point2D = this.getDefaultCenter();
        if (point2D != null) {
            return point2D;
        }
        return this.paintable.getCenter();
    }

    public final boolean contains(double d, double d2) {
        if (this.paintable == null || !this.possiblyContains(d, d2)) {
            return false;
        }
        if (this.clippingshape == null) {
            return this.paintable.contains(d, d2);
        }
        return this.paintable.contains(d, d2) && this.clippingshape.contains(d, d2);
    }
}

