/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.CenterLayout;
import edu.neu.ccs.gui.DisplayPanel;
import edu.neu.ccs.gui.KeyActionAdapter;
import edu.neu.ccs.gui.MouseActionAdapter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class BufferedPanel
extends DisplayPanel {
    public static final Color DEFAULT_BUFFER_BACKGROUND = Color.white;
    protected BufferedImage buffer = null;
    protected Painter painter = null;
    protected Paint bufferBackground = DEFAULT_BUFFER_BACKGROUND;
    protected MouseActionAdapter mouseActions = null;
    protected KeyActionAdapter keyActions = null;

    public BufferedPanel(int n, int n2) {
        this(n, n2, DEFAULT_BUFFER_BACKGROUND);
    }

    public BufferedPanel(Dimension dimension) {
        this(dimension == null ? 1 : dimension.width, dimension == null ? 1 : dimension.height, DEFAULT_BUFFER_BACKGROUND);
    }

    public BufferedPanel(int n, int n2, Paint paint) {
        super(new CenterLayout());
        this.setBufferBackground(paint);
        this.setBufferSize(n, n2);
        this.painter = new Painter(this);
        this.add(this.painter);
        this.mouseActions = new MouseActionAdapter(this.painter);
        this.keyActions = new KeyActionAdapter(this.painter);
    }

    public BufferedPanel(Dimension dimension, Paint paint) {
        this(dimension == null ? 1 : dimension.width, dimension == null ? 1 : dimension.height, paint);
    }

    public Graphics2D getBufferGraphics() {
        return this.buffer.createGraphics();
    }

    public BufferedImage getBuffer() {
        return this.buffer;
    }

    public DisplayPanel getInnerPanel() {
        return this.painter;
    }

    public void quickRepaint() {
        DisplayPanel displayPanel = this.getInnerPanel();
        Graphics graphics = displayPanel.getGraphics();
        if (graphics == null) {
            return;
        }
        displayPanel.paint(graphics);
    }

    public void setBufferBackground(Paint paint) {
        if (paint == null) {
            return;
        }
        this.bufferBackground = paint;
    }

    public Paint getBufferBackground() {
        return this.bufferBackground;
    }

    public void clearPanel() {
        this.fillPanel(this.getBufferBackground());
    }

    public void fillPanel(Paint paint) {
        if (paint == null) {
            return;
        }
        Graphics2D graphics2D = this.getBufferGraphics();
        graphics2D.setPaint(paint);
        graphics2D.fillRect(0, 0, this.getBufferWidth(), this.getBufferHeight());
    }

    public void setBackground(Color color) {
        if (this.painter != null) {
            this.painter.setBackground(color);
        }
        super.setBackground(color);
    }

    public synchronized void setBufferSize(Dimension dimension) {
        if (dimension == null) {
            return;
        }
        this.setBufferSize(dimension.width, dimension.height);
    }

    public synchronized void setBufferSize(int n, int n2) {
        n = Math.max(n, 1);
        n2 = Math.max(n2, 1);
        BufferedImage bufferedImage = this.buffer;
        this.buffer = new BufferedImage(n, n2, 1);
        this.clearPanel();
        if (bufferedImage != null) {
            Graphics2D graphics2D = this.getBufferGraphics();
            graphics2D.drawImage((Image)bufferedImage, 0, 0, this);
        }
        this.refreshComponent();
    }

    public int getBufferWidth() {
        return this.buffer.getWidth();
    }

    public int getBufferHeight() {
        return this.buffer.getHeight();
    }

    public void setMouseActionAdapter(MouseActionAdapter mouseActionAdapter) {
        if (mouseActionAdapter == null) {
            return;
        }
        this.painter.removeMouseListener(this.mouseActions);
        this.painter.removeMouseMotionListener(this.mouseActions);
        this.mouseActions = mouseActionAdapter;
        this.painter.addMouseListener(this.mouseActions);
        this.painter.addMouseMotionListener(this.mouseActions);
    }

    public MouseActionAdapter getMouseActionAdapter() {
        return this.mouseActions;
    }

    public void setKeyActionAdapter(KeyActionAdapter keyActionAdapter) {
        if (keyActionAdapter == null) {
            return;
        }
        this.painter.removeKeyListener(this.keyActions);
        this.keyActions = keyActionAdapter;
        this.painter.addKeyListener(this.keyActions);
    }

    public KeyActionAdapter getKeyActionAdapter() {
        return this.keyActions;
    }

    public void paintOver(Graphics2D graphics2D) {
    }

    protected static class Painter
    extends DisplayPanel {
        protected BufferedPanel panel = null;

        protected Painter(BufferedPanel bufferedPanel) {
            this.panel = bufferedPanel;
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.panel.getBufferWidth(), this.panel.getBufferHeight());
        }

        protected void paintComponent(Graphics graphics) {
            Insets insets = this.getInsets();
            graphics.drawImage(this.panel.getBuffer(), insets.left, insets.top, this);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Insets insets = this.getInsets();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.transform(AffineTransform.getTranslateInstance(insets.left, insets.top));
            this.panel.paintOver(graphics2D);
        }
    }
}

