/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.AbstractPaintable;
import edu.neu.ccs.gui.MutatablePaintable;
import edu.neu.ccs.gui.Mutator;
import edu.neu.ccs.gui.TransformFactory;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class AbstractMutatablePaintable
extends AbstractPaintable
implements MutatablePaintable {
    public static final String SET_MUTATOR = "set.mutator";
    private AffineTransform mutator = new AffineTransform();
    private AffineTransform inverse = new AffineTransform();

    public Rectangle2D getBounds2D() {
        Rectangle2D rectangle2D = this.getOriginalBounds2D();
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D.getMinY();
        double d3 = rectangle2D.getMaxX();
        double d4 = rectangle2D.getMaxY();
        double[] dArray = new double[]{d, d2, d3, d2, d3, d4, d, d4};
        double[] dArray2 = new double[8];
        this.mutator.transform(dArray, 0, dArray2, 0, 4);
        d = Math.min(dArray2[0], Math.min(dArray2[2], Math.min(dArray2[4], dArray2[6])));
        d2 = Math.min(dArray2[1], Math.min(dArray2[3], Math.min(dArray2[5], dArray2[7])));
        d3 = Math.max(dArray2[0], Math.max(dArray2[2], Math.max(dArray2[4], dArray2[6])));
        d4 = Math.max(dArray2[1], Math.max(dArray2[3], Math.max(dArray2[5], dArray2[7])));
        return new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
    }

    public Point2D getCenter() {
        Point2D point2D = this.getOriginalCenter();
        return this.mutator.transform(point2D, point2D);
    }

    public abstract Rectangle2D getOriginalBounds2D();

    public abstract Point2D getOriginalCenter();

    public void setMutator(AffineTransform affineTransform) {
        if (affineTransform == null || affineTransform.equals(this.mutator)) {
            return;
        }
        try {
            AffineTransform affineTransform2 = affineTransform.createInverse();
            this.mutator = affineTransform;
            this.inverse = affineTransform2;
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return;
        }
        this.firePropertyChange(SET_MUTATOR, null, null);
    }

    public final void addPreMutation(AffineTransform affineTransform) {
        if (affineTransform == null) {
            return;
        }
        this.setMutator(TransformFactory.compose(this.getMutator(), affineTransform));
    }

    public void addPreMutation(Mutator.Strategy strategy) {
        if (strategy == null) {
            return;
        }
        this.addPreMutation(strategy.mutator(this.getOriginalCenter()));
    }

    public final void addPostMutation(AffineTransform affineTransform) {
        if (affineTransform == null) {
            return;
        }
        this.setMutator(TransformFactory.compose(affineTransform, this.getMutator()));
    }

    public void addPostMutation(Mutator.Strategy strategy) {
        if (strategy == null) {
            return;
        }
        this.addPostMutation(strategy.mutator(this.getCenter()));
    }

    public final AffineTransform getMutator() {
        return new AffineTransform(this.mutator);
    }

    public final AffineTransform getMutatorInverse() {
        return new AffineTransform(this.inverse);
    }

    public final void move(double d, double d2) {
        this.addPostMutation(TransformFactory.translate(d, d2));
    }

    public final void move(Point2D point2D) {
        if (point2D == null) {
            return;
        }
        this.move(point2D.getX(), point2D.getY());
    }
}

