/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.console;

import edu.neu.ccs.console.ConsoleAware;
import edu.neu.ccs.console.ConsoleTextPane;
import edu.neu.ccs.gui.JPTFrame;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.util.FileExistsException;
import edu.neu.ccs.util.FileUtilities;
import edu.neu.ccs.util.JPTConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

final class ConsoleWindow
extends JPTFrame
implements ConsoleAware,
JPTConstants,
Serializable {
    public static final int OUT = 0;
    public static final int ERR = 1;
    public static final int IN = 2;
    private static int minFontSize = 10;
    private static int maxFontSize = 72;
    private static int widthDeduction = 100;
    private static int heightDeduction = 150;
    private Hashtable actions = null;
    private Action save = null;
    private Action transcript = null;
    private transient FileOutputStream scriptStream = null;
    private File scriptFile = null;
    private JScrollPane scroll = null;
    private ConsoleTextPane tablet = null;
    private Object inputmode_mutex = new Object();

    public ConsoleWindow() {
        super("Text console");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new 1());
        this.tablet = new ConsoleTextPane(this);
        this.actions = this.createActionsTable();
        this.setJMenuBar(this.createMenuBar());
        this.save.setEnabled(false);
        this.scroll = new JScrollPane(this.tablet);
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.scroll.setVerticalScrollBarPolicy(22);
        this.setContentPane(this.scroll);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width - widthDeduction;
        int n2 = dimension.height - heightDeduction;
        ((Component)this).setSize(n, n2);
        this.setResizable(true);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.scriptStream = new FileOutputStream(this.scriptFile);
        }
        catch (Exception exception) {
            this.scriptFile = null;
            this.scriptStream = null;
            this.transcript.putValue("Name", "Start transcript");
        }
    }

    public void consoleInputPerformed(String string) {
        this.save.setEnabled(true);
        this.fireConsoleInputPerformed(string);
    }

    public void consoleOutputPerformed(String string, int n) {
        block2: {
            this.save.setEnabled(true);
            this.tablet.append(string, n);
            if (this.scriptStream == null) break block2;
            try {
                this.scriptStream.write(string.getBytes());
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, "There was an error writing to the transcript file.", "Warning!", 2);
            }
        }
    }

    public void setInputMode(boolean bl) {
        Object object = this.inputmode_mutex;
        synchronized (object) {
            if (bl) {
                this.tablet.setStream(2);
            } else {
                this.tablet.setStream(0);
            }
        }
    }

    public void setInputColor(Color color) {
        this.tablet.setInputColor(color);
    }

    public Color getInputColor() {
        return this.tablet.getInputColor();
    }

    public void setOutputColor(Color color) {
        this.tablet.setOutputColor(color);
    }

    public Color getOutputColor() {
        return this.tablet.getOutputColor();
    }

    public void setErrorColor(Color color) {
        this.tablet.setErrorColor(color);
    }

    public Color getErrorColor() {
        return this.tablet.getErrorColor();
    }

    public final String getFontFamilyName() {
        return this.tablet.getFontFamilyName();
    }

    public final int getFontSize() {
        return this.tablet.getFontSize();
    }

    public static final int getMinimumFontSize() {
        return minFontSize;
    }

    public static final int getMaximumFontSize() {
        return maxFontSize;
    }

    public final void setFontSize(int n) {
        this.tablet.setFontSize(n);
    }

    public void close() {
        if (this.save.isEnabled() && JOptionPane.showConfirmDialog(this, "Do you want to save a transcript of the console contents?", "Save contents", 0) == 0) {
            this.save();
        }
        ConsoleAware.console.setActivated(false);
        ((Component)this).setVisible(false);
        this.dispose();
        if (JPTFrame.getJPTFrameCount() == 0) {
            System.exit(0);
        }
    }

    ConsoleTextPane getTextPane() {
        return this.tablet;
    }

    private void fireConsoleInputPerformed(String string) {
        Object object = this.inputmode_mutex;
        synchronized (object) {
            ConsoleAware.console.consoleInputPerformed(string);
        }
    }

    private Hashtable createActionsTable() {
        Hashtable<String, Action> hashtable = new Hashtable<String, Action>();
        Action[] actionArray = this.tablet.getActions();
        int n = 0;
        while (n < actionArray.length) {
            hashtable.put((String)actionArray[n].getValue("Name"), actionArray[n]);
            ++n;
        }
        return hashtable;
    }

    private Action getAction(String string) {
        return (Action)this.actions.get(string);
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.createFileMenu());
        jMenuBar.add(this.createEditMenu());
        jMenuBar.add(this.createFontMenu());
        return jMenuBar;
    }

    private JMenu createFileMenu() {
        JMenu jMenu = new JMenu("File");
        this.save = new 2("Save contents");
        jMenu.add(this.save);
        this.transcript = new 3("Start transcript");
        jMenu.add(this.transcript);
        jMenu.addSeparator();
        jMenu.add(new 4("Close window"));
        return jMenu;
    }

    private JMenu createEditMenu() {
        JMenu jMenu = new JMenu("Edit");
        jMenu.add(new 5("Cut"));
        jMenu.add(new 6("Copy"));
        jMenu.add(new 7("Paste"));
        jMenu.addSeparator();
        jMenu.add(new 8("Select all"));
        return jMenu;
    }

    private JMenu createFontMenu() {
        JMenu jMenu = new JMenu("Font size");
        int n = 10;
        while (n <= 36) {
            jMenu.add(this.setFontAction(n));
            n += 2;
        }
        int n2 = 48;
        while (n2 <= 72) {
            jMenu.add(this.setFontAction(n2));
            n2 += 12;
        }
        return jMenu;
    }

    private SimpleAction setFontAction(int n) {
        return new 9(n, this, String.valueOf(n) + " point");
    }

    private void save() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Save contents");
        jFileChooser.setFileFilter(new 10());
        while (jFileChooser.showSaveDialog(this) == 0) {
            try {
                try {
                    FileUtilities.writeFile(jFileChooser.getSelectedFile(), this.tablet.getText(), false);
                    this.save.setEnabled(false);
                }
                catch (FileExistsException fileExistsException) {
                    int n = JOptionPane.showConfirmDialog(null, "A file with that name already exists.  Do you want to overwrite it?", "Warning!", 1, 2);
                    if (n == 0) {
                        FileUtilities.writeFile(jFileChooser.getSelectedFile(), this.tablet.getText(), true);
                        this.save.setEnabled(false);
                        break;
                    }
                    if (n != 2) continue;
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "The file could not be saved.", "Error!", 0);
            }
            break;
        }
    }

    private void transcript() {
        if (this.scriptStream == null) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("Start transcript");
            jFileChooser.setFileFilter(new 11());
            while (jFileChooser.showDialog(this, "Select") == 0) {
                File file = jFileChooser.getSelectedFile();
                if (file.exists() && JOptionPane.showConfirmDialog(null, "A file with that name already exists.  Do you want to overwrite it?", "Warning!", 1, 2) != 0) continue;
                try {
                    this.scriptFile = jFileChooser.getSelectedFile();
                    this.scriptStream = new FileOutputStream(this.scriptFile);
                    this.transcript.putValue("Name", "Stop transcript");
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, "The transcript could not be opened.", "Error!", 0);
                }
                break;
            }
        } else if (JOptionPane.showConfirmDialog(null, "Do you want to close the transcript file?", "Stop transcript", 0) == 0) {
            try {
                try {
                    this.scriptStream.close();
                }
                catch (IOException iOException) {
                }
                Object var2_4 = null;
                this.scriptFile = null;
                this.scriptStream = null;
                this.transcript.putValue("Name", "Start transcript");
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                this.scriptFile = null;
                this.scriptStream = null;
                this.transcript.putValue("Name", "Start transcript");
                throw throwable;
            }
        }
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ConsoleWindow.this.close();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends SimpleAction {
        public void perform() {
            ConsoleWindow.this.save();
        }

        /* synthetic */ 2(String string) {
            super(string);
        }
    }

    private final class 3
    extends SimpleAction {
        public void perform() {
            ConsoleWindow.this.transcript();
        }

        /* synthetic */ 3(String string) {
            super(string);
        }
    }

    private final class 4
    extends SimpleAction {
        public void perform() {
            ConsoleWindow.this.close();
        }

        /* synthetic */ 4(String string) {
            super(string);
        }
    }

    private final class 5
    extends SimpleAction {
        public void perform() {
            ConsoleWindow.this.getTextPane().cut();
        }

        /* synthetic */ 5(String string) {
            super(string);
        }
    }

    private final class 6
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Action action = ConsoleWindow.this.getAction("copy-to-clipboard");
            if (action != null) {
                action.actionPerformed(actionEvent);
            }
        }

        /* synthetic */ 6(String string) {
            super(string);
        }
    }

    private final class 7
    extends SimpleAction {
        public void perform() {
            ConsoleWindow.this.getTextPane().paste();
        }

        /* synthetic */ 7(String string) {
            super(string);
        }
    }

    private final class 8
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Action action = ConsoleWindow.this.getAction("select-all");
            if (action != null) {
                action.actionPerformed(actionEvent);
            }
        }

        /* synthetic */ 8(String string) {
            super(string);
        }
    }

    private static final class 9
    extends SimpleAction {
        private final /* synthetic */ ConsoleWindow this$0;
        private final /* synthetic */ int val$size;

        public void perform() {
            this.this$0.setFontSize(this.val$size);
        }

        /* synthetic */ 9(int n, ConsoleWindow consoleWindow, String string) {
            super(string);
            this.val$size = n;
            this.this$0 = consoleWindow;
        }
    }

    private final class 10
    extends FileFilter {
        public boolean accept(File file) {
            return true;
        }

        public String getDescription() {
            return "All files (*.*)";
        }

        /* synthetic */ 10() {
        }
    }

    private final class 11
    extends FileFilter {
        public boolean accept(File file) {
            return true;
        }

        public String getDescription() {
            return "All files (*.*)";
        }

        /* synthetic */ 11() {
        }
    }
}

