/*
 * @(#)GUIBalloonInput.java  17 March 2004
 *
 * @author Viera K. Proulx
 */

import java.awt.*;

import edu.neu.ccs.console.*;
import edu.neu.ccs.gui.*;

/** An input channel to return Balloon object from GUI input. */
class GUIBalloonInput implements BalloonInput, ConsoleAware{
    
    /*--------------------------------------------------------------
     Member data
     *------------------------------------------------------------*/

    BalloonInputView bGUI;
    
    /*--------------------------------------------------------------
     Constructor
     *------------------------------------------------------------*/
    GUIBalloonInput(){		
		
		// build the GUI for input of one Balloon object
		this.bGUI = new BalloonInputView();
		GeneralDialog.showOKDialog(this.bGUI, "Balloon Input");
  }
    
    /*--------------------------------------------------------------
     Methods
     *------------------------------------------------------------*/

    /* read values for one balloon from the GUI */
    public Balloon requestBalloon() throws CancelledException{
		return this.bGUI.requestBalloon();
    }
     
    public Balloon demandBalloon(){
    	return this.bGUI.demandBalloon();
    }
    
}
