/*
 * @(#)ConsoleBalloonInput.java  17 March 2004
 *
 * @author Viera K. Proulx
 */

import java.awt.*;
import edu.neu.ccs.console.*;
import edu.neu.ccs.gui.*;
import edu.neu.ccs.filter.*;

/** An input channel to return Balloon object from console input. */
class ConsoleBalloonInput implements BalloonInput, ConsoleAware{
    
    public ConsoleBalloonInput(){
    }
    
    /*--------------------------------------------------------------
     Methods
     *------------------------------------------------------------*/
	public Balloon requestBalloon () throws CancelledException{
		return new Balloon(
			console.in.requestInt("x: "),
			console.in.requestInt("y: "),
			console.in.requestInt("radius: "),
			new Color(requestShade("red shade: " ),
					  requestShade("green shade: "),
					  requestShade("blue shade: ")));
	}
    
    /* read values for one balloon from the console */
    public Balloon demandBalloon(){
        return new Balloon
            (console.in.demandInt("x: "),
             console.in.demandInt("y: "),
             console.in.demandInt("radius: "),
             new Color(demandShade("red shade: " ),
                       demandShade("green shade: "),
                       demandShade("blue shade: ")));
    }
    
    /* demand shade value in the valid range from the console */
    protected int demandShade(String s){
       return console.in.demandInt(s, 0, new RangeFilter.Long(0, 255));
    }
    
	/* demand shade value in the valid range from the console */
	protected int requestShade(String s) throws CancelledException{
	   return console.in.requestInt(s, new RangeFilter.Long(0, 255));
	}
    

}
