/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.quick;

import edu.neu.ccs.quick.QuickHashMap;
import edu.neu.ccs.quick.QuickTreeMap;
import edu.neu.ccs.quick.QuickVector;
import edu.neu.ccs.quick.StringObjectPair;

public final class StringObjectMap {
    private QuickTreeMap stringToObjectMap = new QuickTreeMap();
    private QuickHashMap objectToStringMap = new QuickHashMap();
    private QuickVector pairList = new QuickVector();

    public StringObjectMap() {
    }

    public StringObjectMap(Object[][] objectArray) {
        this.addPairs(objectArray);
    }

    public StringObjectMap(StringObjectPair[] stringObjectPairArray) {
        this.addPairs(stringObjectPairArray);
    }

    public boolean addPair(String string, Object object) {
        return this.addPair(StringObjectPair.makeStringObjectPair(string, object));
    }

    public boolean addPair(StringObjectPair stringObjectPair) {
        if (stringObjectPair == null) {
            return false;
        }
        String string = stringObjectPair.getString();
        if (this.containsString(string)) {
            return false;
        }
        Object object = stringObjectPair.getObject();
        if (this.containsObject(object)) {
            return false;
        }
        this.stringToObjectMap.put(string, object);
        this.objectToStringMap.put(object, string);
        this.pairList.add(stringObjectPair);
        return true;
    }

    public boolean addPair(int n, String string, Object object) {
        return this.addPair(n, StringObjectPair.makeStringObjectPair(string, object));
    }

    public boolean addPair(int n, StringObjectPair stringObjectPair) {
        if (n < 0 || n > this.size()) {
            return false;
        }
        if (stringObjectPair == null) {
            return false;
        }
        String string = stringObjectPair.getString();
        if (this.containsString(string)) {
            return false;
        }
        Object object = stringObjectPair.getObject();
        if (this.containsObject(object)) {
            return false;
        }
        this.stringToObjectMap.put(string, object);
        this.objectToStringMap.put(object, string);
        this.pairList.add(n, stringObjectPair);
        return true;
    }

    public void addPairs(Object[][] objectArray) {
        this.addPairs(StringObjectPair.toArray(objectArray));
    }

    public void addPairs(StringObjectPair[] stringObjectPairArray) {
        if (stringObjectPairArray == null) {
            return;
        }
        int n = stringObjectPairArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.addPair(stringObjectPairArray[n2]);
            ++n2;
        }
    }

    public void setPairs(Object[][] objectArray) {
        this.clear();
        this.addPairs(objectArray);
    }

    public void setPairs(StringObjectPair[] stringObjectPairArray) {
        this.clear();
        this.addPairs(stringObjectPairArray);
    }

    public StringObjectPair remove(int n) {
        if (n < 0 || n >= this.size()) {
            return null;
        }
        StringObjectPair stringObjectPair = this.getPair(n);
        String string = stringObjectPair.getString();
        Object object = stringObjectPair.getObject();
        this.stringToObjectMap.remove(string);
        this.objectToStringMap.remove(object);
        this.pairList.remove(n);
        return stringObjectPair;
    }

    public StringObjectPair removeByString(String string) {
        if (!this.containsString(string)) {
            return null;
        }
        Object object = this.getObject(string);
        StringObjectPair stringObjectPair = new StringObjectPair(string, object);
        this.stringToObjectMap.remove(string);
        this.objectToStringMap.remove(object);
        this.pairList.remove(stringObjectPair);
        return stringObjectPair;
    }

    public StringObjectPair removeByObject(Object object) {
        if (!this.containsObject(object)) {
            return null;
        }
        String string = this.getString(object);
        StringObjectPair stringObjectPair = new StringObjectPair(string, object);
        this.stringToObjectMap.remove(string);
        this.objectToStringMap.remove(object);
        this.pairList.remove(stringObjectPair);
        return stringObjectPair;
    }

    public void clear() {
        this.stringToObjectMap.clear();
        this.objectToStringMap.clear();
        this.pairList.clear();
    }

    public int size() {
        return this.pairList.size();
    }

    public String getString(Object object) {
        if (object == null) {
            return null;
        }
        return (String)this.objectToStringMap.get(object);
    }

    public Object getObject(String string) {
        if (string == null) {
            return null;
        }
        return this.stringToObjectMap.get(string);
    }

    public StringObjectPair getPair(int n) {
        if (n < 0 || n >= this.size()) {
            return null;
        }
        return (StringObjectPair)this.pairList.get(n);
    }

    public String getString(int n) {
        StringObjectPair stringObjectPair = this.getPair(n);
        if (stringObjectPair == null) {
            return null;
        }
        return stringObjectPair.getString();
    }

    public Object getObject(int n) {
        StringObjectPair stringObjectPair = this.getPair(n);
        if (stringObjectPair == null) {
            return null;
        }
        return stringObjectPair.getObject();
    }

    public StringObjectPair[] getStringObjectPairs() {
        return this.pairList.toArray(new StringObjectPair[0]);
    }

    public String[] getStrings() {
        return StringObjectPair.getStrings(this.getStringObjectPairs());
    }

    public Object[] getObjects() {
        return StringObjectPair.getObjects(this.getStringObjectPairs());
    }

    public StringObjectPair[] getSortedStringObjectPairs() {
        String[] stringArray = this.getSortedStrings();
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        StringObjectPair[] stringObjectPairArray = new StringObjectPair[n];
        int n2 = 0;
        while (n2 < n) {
            stringObjectPairArray[n2] = new StringObjectPair(stringArray[n2], this.getObject(stringArray[n2]));
            ++n2;
        }
        return stringObjectPairArray;
    }

    public String[] getSortedStrings() {
        return this.stringToObjectMap.keySet().toArray(new String[0]);
    }

    public Object[] getSortedObjects() {
        String[] stringArray = this.getSortedStrings();
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = this.getObject(stringArray[n2]);
            ++n2;
        }
        return objectArray;
    }

    public boolean containsString(String string) {
        if (string == null) {
            return false;
        }
        return this.stringToObjectMap.containsKey(string);
    }

    public boolean containsObject(Object object) {
        if (object == null) {
            return false;
        }
        return this.objectToStringMap.containsKey(object);
    }
}

