/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.parser;

import edu.neu.ccs.XBigInteger;
import edu.neu.ccs.XDouble;
import edu.neu.ccs.XNumber;
import edu.neu.ccs.parser.Parser;
import edu.neu.ccs.util.JPTError;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractParser
implements Parser {
    protected static final Operation OPERATION_PREFIX = new Operation();
    protected static final int INTEGRAL = 100;
    protected static final int FLOATING = 101;
    protected String NESTED_EXPRESSION_START = "(";
    protected String NESTED_EXPRESSION_END = ")";
    protected String ARGUMENT_LIST_START = "(";
    protected String ARGUMENT_LIST_END = ")";
    protected String RADIX_POINT = ".";
    protected String ARGUMENT_SEPARATOR = ",";
    protected char UNDERSCORE = (char)95;
    protected Hashtable environment = new Hashtable();
    protected Hashtable constants = new Hashtable();
    protected Hashtable procedures = new Hashtable();
    protected Hashtable operations = new Hashtable();
    protected Hashtable prefixes = new Hashtable();
    protected Vector precedence = new Vector();
    protected final Operation identity = new 1("");
    protected String data;
    protected int next;

    public AbstractParser() {
        this.precedence.add(new Hashtable());
        this.addOperation(this.identity, 0);
        this.data = null;
        this.next = 0;
        this.addOperations();
        this.addProcedures();
        this.addConstants();
    }

    public abstract Object parse(String var1) throws ParseException;

    public void addConstant(String string, Object object) {
        if (this.constants.containsKey(string)) {
            throw new JPTError("Constant name " + string + " already in use");
        }
        this.assign(string, object);
        this.constants.put(string, object);
    }

    public void addProcedure(Procedure procedure) {
        if (this.procedures.containsKey(procedure.name)) {
            throw new JPTError("Procedure name " + procedure.name + "already in use");
        }
        this.procedures.put(procedure.name, procedure);
    }

    public Operation addOperationAtPrecedenceOf(Operation operation, Operation operation2) {
        int n = this.precedenceOf(operation);
        if (n == -1) {
            throw new JPTError("Operation at comparable precedence not recognized.");
        }
        this.addOperation(operation2, n);
        return operation2;
    }

    public Operation addOperationBeforePrecedenceOf(Operation operation, Operation operation2) {
        int n = this.precedenceOf(operation);
        if (n == -1) {
            throw new JPTError("Operation at comparable precedence not recognized.");
        }
        if (n == 0) {
            throw new JPTError("Operation cannot be added at a precedence before the identity operation.");
        }
        this.precedence.insertElementAt(new Hashtable(), n - 1);
        this.addOperation(operation2, n);
        return operation2;
    }

    public Operation addOperationAfterPrecedenceOf(Operation operation, Operation operation2) {
        int n = this.precedenceOf(operation);
        if (n == -1) {
            throw new JPTError("Operation at comparable precedence not recognized.");
        }
        this.precedence.insertElementAt(new Hashtable(), ++n);
        this.addOperation(operation2, n);
        return operation2;
    }

    protected abstract ObjectOperationPair parseExpression(ObjectOperationPair var1) throws ParseException;

    protected void addOperations() {
    }

    protected void addProcedures() {
    }

    protected void addConstants() {
    }

    protected void setLeftParenthesisToken(String string) {
        if (string != null && string.length() > 0) {
            this.ARGUMENT_LIST_START = string;
        }
    }

    protected void setRightParenthesisToken(String string) {
        if (string != null && string.length() > 0) {
            this.ARGUMENT_LIST_END = string;
        }
    }

    protected void setRadixPointToken(String string) {
        if (string != null && string.length() > 0) {
            this.RADIX_POINT = string;
        }
    }

    protected void setArgumentSeparatorToken(String string) {
        if (string != null && string.length() > 0) {
            this.ARGUMENT_SEPARATOR = string;
        }
    }

    protected void assign(String string, Object object) {
        if (this.environment.containsKey(string)) {
            this.environment.remove(string);
        }
        this.environment.put(string, object);
    }

    protected void addOperation(Operation operation, int n) {
        if (this.operations.containsKey(operation.symbol)) {
            throw new JPTError("Operation symbol " + operation.symbol + " already in use");
        }
        this.operations.put(operation.symbol, operation);
        ((Hashtable)this.precedence.get(n)).put(operation.symbol, operation);
        int n2 = operation.symbol.length() - 1;
        int n3 = 1;
        while (n3 <= n2) {
            String string = operation.symbol.substring(0, n2);
            if (!this.prefixes.containsKey(string)) {
                this.prefixes.put(string, string);
            }
            ++n3;
        }
    }

    protected Operation isOperationOrPrefix(String string) {
        if (this.operations.containsKey(string)) {
            return (Operation)this.operations.get(string);
        }
        if (this.prefixes.containsKey(string)) {
            return OPERATION_PREFIX;
        }
        return null;
    }

    protected Operation nextOperation() {
        this.skipWhitespace();
        int n = this.next;
        Operation operation = null;
        Operation operation2 = null;
        while (n < this.data.length()) {
            if ((operation = this.isOperationOrPrefix(this.data.substring(this.next, ++n))) == null) break;
            if (operation == OPERATION_PREFIX) continue;
            operation2 = operation;
        }
        if (operation2 != null) {
            this.next += operation2.symbol.length();
        }
        return operation2;
    }

    protected int precedenceOf(Operation operation) {
        if (operation == null) {
            return -1;
        }
        int n = 0;
        while (n < this.precedence.size()) {
            if (((Hashtable)this.precedence.get(n)).containsKey(operation.symbol)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected boolean nextTokenIs(String string) {
        this.skipWhitespace();
        return this.nextTokenIs(string, this.next);
    }

    protected boolean nextTokenIs(String string, int n) {
        if (string == null || string.length() == 0 || n + string.length() > this.data.length()) {
            return false;
        }
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) != this.data.charAt(n + n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean startsNumber() {
        this.skipWhitespace();
        if (this.next >= this.data.length()) {
            return false;
        }
        return Character.isDigit(this.data.charAt(this.next)) || this.nextTokenIs(this.RADIX_POINT);
    }

    protected boolean startsIdentifier() {
        this.skipWhitespace();
        if (this.next >= this.data.length()) {
            return false;
        }
        char c = this.data.charAt(this.next);
        return Character.isLetter(c) || c == this.UNDERSCORE;
    }

    protected boolean withinIdentifier() {
        if (this.next >= this.data.length()) {
            return false;
        }
        char c = this.data.charAt(this.next);
        return Character.isLetter(c) || Character.isDigit(c) || c == this.UNDERSCORE;
    }

    protected String parseIdentifier() {
        if (!this.startsIdentifier()) {
            return "";
        }
        int n = this.next++;
        while (this.withinIdentifier()) {
            ++this.next;
        }
        return this.data.substring(n, this.next);
    }

    protected Object[] parseArgumentList() throws ParseException {
        Vector<Object> vector = new Vector<Object>();
        this.skipWhitespace();
        if (!this.nextTokenIs(this.ARGUMENT_LIST_START)) {
            throw new ParseException("Expected start of argument list", this.next);
        }
        this.next += this.ARGUMENT_LIST_START.length();
        this.skipWhitespace();
        boolean bl = this.nextTokenIs(this.ARGUMENT_LIST_END) ^ true;
        while (bl) {
            ObjectOperationPair objectOperationPair = new ObjectOperationPair(null, this.identity);
            vector.add(this.parseExpression((ObjectOperationPair)objectOperationPair).value);
            this.skipWhitespace();
            if (this.nextTokenIs(this.ARGUMENT_SEPARATOR)) {
                this.next += this.ARGUMENT_SEPARATOR.length();
            } else {
                bl = false;
            }
            this.skipWhitespace();
        }
        if (!this.nextTokenIs(this.ARGUMENT_LIST_END)) {
            throw new ParseException("Expected end of argument list", this.next);
        }
        this.next += this.ARGUMENT_LIST_END.length();
        this.skipWhitespace();
        return vector.toArray();
    }

    protected Object parseNumber() throws ParseException {
        this.skipWhitespace();
        int n = this.next;
        int n2 = 100;
        if (this.isSignAt(this.next)) {
            if (this.data.charAt(this.next) == '+') {
                ++this.next;
            }
            ++n;
        }
        if (this.nextTokenIs(this.RADIX_POINT, n = this.afterDigits(n))) {
            n2 = 101;
            n += this.RADIX_POINT.length();
            n = this.afterDigits(n);
        }
        if (this.isExponentAt(n)) {
            n2 = 101;
            ++n;
            n = this.afterSign(n);
            n = this.afterDigits(n);
        }
        String string = this.data.substring(this.next, n);
        this.next = n;
        if (n2 == 100) {
            try {
                BigInteger bigInteger = new BigInteger(string);
                return new XBigInteger(bigInteger);
            }
            catch (NumberFormatException numberFormatException) {
                return new ParseException("Expected valid numeric value: " + string + " " + numberFormatException.getMessage(), this.next);
            }
        }
        try {
            Double d = new Double(string);
            return new XDouble(d);
        }
        catch (NumberFormatException numberFormatException) {
            return new ParseException("Expected valid numeric value: " + string + " " + numberFormatException.getMessage(), this.next);
        }
    }

    protected int afterSign(int n) {
        return this.isSignAt(n) ? n + 1 : n;
    }

    protected boolean isSignAt(int n) {
        if (n >= this.data.length()) {
            return false;
        }
        char c = this.data.charAt(n);
        return c == '+' || c == '-';
    }

    protected boolean isExponentAt(int n) {
        if (n >= this.data.length()) {
            return false;
        }
        char c = this.data.charAt(n);
        return c == 'E' || c == 'e';
    }

    protected int afterDigits(int n) {
        while (n < this.data.length()) {
            char c = this.data.charAt(n);
            if (!Character.isDigit(c)) break;
            ++n;
        }
        return n;
    }

    protected void skipWhitespace() {
        while (this.next < this.data.length() && Character.isWhitespace(this.data.charAt(this.next))) {
            ++this.next;
        }
    }

    private final class 1
    extends Operation {
        public Object performOperation(Object object, Object object2) throws ParseException {
            return object2;
        }

        /* synthetic */ 1(String string) {
            super(string);
        }
    }

    public static class ObjectOperationPair {
        public Object value = null;
        public Operation operation = null;

        public ObjectOperationPair(Object object, Operation operation) {
            this.value = object;
            this.operation = operation;
        }
    }

    public static class Operation {
        public String symbol = "\u0000";
        public boolean isUnary = true;
        public boolean isBinary = true;

        public Operation() {
        }

        public Operation(String string) {
            if (this.symbol != null) {
                this.symbol = string;
            }
        }

        public Operation(String string, boolean bl, boolean bl2) {
            if (this.symbol != null) {
                this.symbol = string;
            }
            this.isUnary = bl;
            this.isBinary = bl2;
        }

        public Object performOperation(Object object, Object object2) throws ParseException {
            return null;
        }

        public boolean isUnary() {
            return this.isUnary;
        }

        public boolean isBinary() {
            return this.isBinary;
        }

        protected void checkUnary() throws ParseException {
            if (!this.isUnary) {
                throw new ParseException("Operation " + this.symbol + " expects 2 arguments.", 0);
            }
        }

        protected void checkBinary() throws ParseException {
            if (!this.isBinary) {
                throw new ParseException("Operation " + this.symbol + " expects 1 argument.", 0);
            }
        }
    }

    public static abstract class Procedure {
        public String name = "UnnamedProcedure";
        public int arguments = 1;

        public Procedure(String string, int n) {
            if (string != null && string.length() > 0) {
                this.name = string;
            }
            this.arguments = n;
        }

        public abstract Object procedureCall(Object[] var1) throws ParseException;

        protected void checkArgs(Object[] objectArray) throws ParseException {
            if (objectArray == null) {
                throw new ParseException("Null arguments to procedure " + this.name + ".", 0);
            }
            if (objectArray.length != this.arguments) {
                throw new ParseException("Procedure " + this.name + " expects " + this.arguments + " arguments.", 0);
            }
        }

        protected void checkArgsAsNumeric(Object[] objectArray) throws ParseException {
            this.checkArgs(objectArray);
            int n = 0;
            while (n < this.arguments) {
                if (!(objectArray[n] instanceof XNumber)) {
                    throw new ParseException("Procedure " + this.name + " expects numeric argument in position " + n + ".", 0);
                }
                ++n;
            }
        }
    }
}

