/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.AbstractPaintable;
import edu.neu.ccs.gui.TextAnchor;
import edu.neu.ccs.gui.TextBounds;
import edu.neu.ccs.gui.TransformFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;

public class TextPaintable
extends AbstractPaintable {
    public static final String SET_STRING = "set.string";
    public static final String SET_FONT = "set.font";
    public static final String SET_FILL_PAINT = "set.fill.paint";
    public static final String SET_ANCHOR_LOCATOR = "set.anchor.locator";
    public static final String SET_ANCHOR_POSITION = "set.anchor.position";
    public static final String SET_BOUNDS_STRATEGY = "set.bounds.strategy";
    public static final FontRenderContext standardFRC = new FontRenderContext(null, true, false);
    private String string = "";
    private Font font = null;
    private Paint fillpaint = null;
    private TextBounds.Strategy strategy = null;
    private TextAnchor.Locator locator = null;
    private float anchorX = 0.0f;
    private float anchorY = 0.0f;
    private TextLayout textLayout = null;

    public TextPaintable() {
        this(null, null, null, null, null, 0.0f, 0.0f);
    }

    public TextPaintable(String string) {
        this(string, null, null, null, null, 0.0f, 0.0f);
    }

    public TextPaintable(String string, Font font) {
        this(string, font, null, null, null, 0.0f, 0.0f);
    }

    public TextPaintable(String string, Font font, Paint paint) {
        this(string, font, paint, null, null, 0.0f, 0.0f);
    }

    public TextPaintable(String string, Font font, Paint paint, TextBounds.Strategy strategy) {
        this(string, font, paint, strategy, null, 0.0f, 0.0f);
    }

    public TextPaintable(String string, Font font, Paint paint, TextBounds.Strategy strategy, TextAnchor.Locator locator) {
        this(string, font, paint, strategy, locator, 0.0f, 0.0f);
    }

    public TextPaintable(String string, Font font, Paint paint, TextBounds.Strategy strategy, TextAnchor.Locator locator, float f, float f2) {
        this.setFont(font);
        this.setString(string);
        this.setFillPaint(paint);
        this.setBoundsStrategy(strategy);
        this.setAnchorLocator(locator);
        this.setAnchorPosition(f, f2);
        this.resetTextLayout();
    }

    public final void paint(Graphics graphics) {
        if (this.string.length() == 0 || graphics == null || !this.isVisible()) {
            return;
        }
        Graphics2D graphics2D = this.getPreparedGraphics2D(graphics);
        graphics2D.setFont(this.font);
        graphics2D.setPaint(this.fillpaint);
        this.textLayout.draw(graphics2D, this.getLeftX(), this.getBaseLineY());
    }

    public TextLayout getTextLayout() {
        return this.textLayout;
    }

    public final Rectangle2D getStringBounds() {
        if (this.string.length() == 0) {
            return new Rectangle2D.Double(this.anchorX, this.anchorY, 0.0, 0.0);
        }
        return this.locator.getBounds2D(this.string, this.font, this.anchorX, this.anchorY);
    }

    public final Rectangle2D getTightBounds() {
        if (this.string.length() == 0) {
            return new Rectangle2D.Double(this.anchorX, this.anchorY, 0.0, 0.0);
        }
        Rectangle2D rectangle2D = this.textLayout.getBounds();
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return new Rectangle2D.Double(this.anchorX, this.anchorY, 0.0, 0.0);
        }
        float f5 = this.getLeftX();
        float f6 = this.getBaseLineY();
        rectangle2D.setRect(f + f5, f2 + f6, f3, f4);
        return rectangle2D;
    }

    public final Rectangle2D getLooseBounds() {
        Rectangle2D rectangle2D = this.getStringBounds();
        rectangle2D.add(this.getTightBounds());
        return rectangle2D;
    }

    public final Rectangle2D getBounds2D() {
        Rectangle2D rectangle2D = this.getDefaultBounds2D();
        if (rectangle2D != null) {
            return rectangle2D;
        }
        if (this.string.length() == 0) {
            return new Rectangle2D.Double(this.anchorX, this.anchorY, 0.0, 0.0);
        }
        return this.strategy.getBounds2D(this);
    }

    public final Point2D getCenter() {
        if (this.string.length() == 0) {
            return new Point2D.Double(this.anchorX, this.anchorY);
        }
        return this.locator.getCenter(this.string, this.font, this.anchorX, this.anchorY);
    }

    public Shape getOutline() {
        return this.string.length() == 0 ? new GeneralPath() : this.textLayout.getOutline(TransformFactory.translate(this.getLeftX(), this.getBaseLineY()));
    }

    public boolean contains(double d, double d2) {
        if (!this.possiblyContains(d, d2)) {
            return false;
        }
        return this.getOutline().contains(d, d2);
    }

    public final void setString(String string) {
        if (string == null) {
            string = "";
        }
        if (string.equals(this.string)) {
            return;
        }
        this.string = string;
        this.resetTextLayout();
        this.firePropertyChange(SET_STRING, null, null);
    }

    public final String getString() {
        return this.string;
    }

    public final void setFont(Font font) {
        if (font == null) {
            font = TextPaintable.getDefaultFont();
        }
        if (font.equals(this.font)) {
            return;
        }
        this.removeAndAddForwardingListener(this.font, font);
        this.font = font;
        this.resetTextLayout();
        this.firePropertyChange(SET_FONT, null, null);
    }

    public final Font getFont() {
        return this.font;
    }

    public final void setFillPaint(Paint paint) {
        if (paint == null) {
            paint = Color.black;
        }
        if (paint.equals(this.fillpaint)) {
            return;
        }
        this.removeAndAddForwardingListener(this.fillpaint, paint);
        this.fillpaint = paint;
        this.firePropertyChange(SET_FILL_PAINT, null, null);
    }

    public final Paint getFillPaint() {
        return this.fillpaint;
    }

    public final void setBoundsStrategy(TextBounds.Strategy strategy) {
        if (strategy == null) {
            strategy = TextBounds.LOOSE;
        }
        if (strategy.equals(this.strategy)) {
            return;
        }
        this.strategy = strategy;
        this.firePropertyChange(SET_BOUNDS_STRATEGY, null, null);
    }

    public final TextBounds.Strategy getBoundsStrategy() {
        return this.strategy;
    }

    public final void setAnchorLocator(TextAnchor.Locator locator) {
        if (locator == null) {
            locator = TextAnchor.LEFT_BASELINE;
        }
        if (locator.equals(this.locator)) {
            return;
        }
        this.locator = locator;
        this.firePropertyChange(SET_ANCHOR_LOCATOR, null, null);
    }

    public final TextAnchor.Locator getAnchorLocator() {
        return this.locator;
    }

    public final void setAnchorPosition(float f, float f2) {
        if (f == this.anchorX && f2 == this.anchorY) {
            return;
        }
        this.anchorX = f;
        this.anchorY = f2;
        this.firePropertyChange(SET_ANCHOR_POSITION, null, null);
    }

    public final void setAnchorPosition(float[] fArray) {
        if (fArray == null || fArray.length != 2) {
            return;
        }
        this.setAnchorPosition(fArray[0], fArray[1]);
    }

    public final float[] getAnchorPosition() {
        return new float[]{this.anchorX, this.anchorY};
    }

    public final float getLeftX() {
        if (this.string.length() == 0) {
            return this.anchorX;
        }
        return this.locator.getLeftX(this.string, this.font, this.anchorX);
    }

    public final float getRightX() {
        if (this.string.length() == 0) {
            return this.anchorX;
        }
        return this.locator.getRightX(this.string, this.font, this.anchorX);
    }

    public final float getCenterX() {
        if (this.string.length() == 0) {
            return this.anchorX;
        }
        return this.locator.getCenterX(this.string, this.font, this.anchorX);
    }

    public final float getBaseLineY() {
        if (this.string.length() == 0) {
            return this.anchorY;
        }
        return this.locator.getBaseLineY(this.string, this.font, this.anchorY);
    }

    public final float getAscentLineY() {
        if (this.string.length() == 0) {
            return this.anchorY;
        }
        return this.locator.getAscentLineY(this.string, this.font, this.anchorY);
    }

    public final float getDescentLineY() {
        if (this.string.length() == 0) {
            return this.anchorY;
        }
        return this.locator.getDescentLineY(this.string, this.font, this.anchorY);
    }

    public final float getLeadingLineY() {
        if (this.string.length() == 0) {
            return this.anchorY;
        }
        return this.locator.getLeadingLineY(this.string, this.font, this.anchorY);
    }

    public final float getWidth() {
        return (float)this.getBounds2D().getWidth();
    }

    public final float getHeight() {
        return (float)this.getBounds2D().getHeight();
    }

    public static Font getDefaultFont() {
        JLabel jLabel = new JLabel();
        return jLabel.getFont();
    }

    private void resetTextLayout() {
        this.textLayout = this.string.length() == 0 ? null : new TextLayout(this.string, this.font, standardFRC);
    }
}

