/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Colors;
import edu.neu.ccs.gui.PaintSwatch;
import edu.neu.ccs.gui.TablePanel;
import java.awt.Color;
import java.awt.Paint;
import javax.swing.JLabel;

public class SwatchNamePair
extends TablePanel {
    private Paint paint;
    private String name;
    private PaintSwatch swatch;
    private JLabel label;

    public SwatchNamePair(String string) {
        if (string == null) {
            throw new NullPointerException("Null color name passed to SwatchNamePair constructor");
        }
        Color color = Colors.getColorFromName(string);
        if (color == null) {
            throw new NullPointerException("Invalid color name passed to SwatchNamePair constructor");
        }
        this.initialize(color, string);
    }

    public SwatchNamePair(Paint paint, String string) {
        if (string == null) {
            throw new NullPointerException("Null paint name passed to SwatchNamePair constructor");
        }
        if (paint == null) {
            throw new NullPointerException("Null paint passed to SwatchNamePair constructor");
        }
        this.initialize(paint, string);
    }

    private void initialize(Paint paint, String string) {
        this.paint = paint;
        this.name = string;
        this.swatch = new PaintSwatch(paint);
        this.label = new JLabel(string);
        this.setOpaque(true);
        this.setRows(1);
        this.setColumns(2);
        this.setHorizontalGap(6);
        this.setTableAlignment(0);
        this.addObject((Object)this.swatch, 0, 0);
        this.addObject((Object)this.label, 0, 1);
    }

    public Paint toPaint() {
        return this.paint;
    }

    public String toString() {
        return this.name;
    }

    public PaintSwatch toSwatch() {
        return this.swatch;
    }
}

