/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.ClosureMode;
import edu.neu.ccs.gui.PaintMode;
import edu.neu.ccs.gui.WindingRule;
import edu.neu.ccs.util.FloatArray;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;

public class Path {
    public static final Strategy POLYGON = new 1();
    public static final Strategy POLYGON_DOTS = new 2();
    public static final Strategy BEZIER_CUBIC = new 3();
    public static final Strategy BEZIER_FRAME = new 4();
    public static final Strategy BEZIER_TANGENT_SEGMENTS = new 5();

    private Path() {
    }

    public static float[][] closedBezierFrame(float[][] fArray, float[][] fArray2) {
        if (!FloatArray.checkArrayPair(fArray, fArray2, 2)) {
            return new float[0][2];
        }
        int n = fArray.length;
        int n2 = 3 * n;
        int n3 = n - 1;
        float[][] fArray3 = new float[n2][2];
        int n4 = 0;
        while (n4 < n) {
            int n5 = n4 < n3 ? n4 : 0;
            int n6 = 3 * n4;
            int n7 = n6 + 1;
            int n8 = n6 + 2;
            fArray3[n6][0] = fArray[n4][0];
            fArray3[n6][1] = fArray[n4][1];
            fArray3[n7][0] = fArray[n4][0] + fArray2[n4][0];
            fArray3[n7][1] = fArray[n4][1] + fArray2[n4][1];
            fArray3[n8][0] = fArray[n5][0] - fArray2[n5][0];
            fArray3[n8][1] = fArray[n5][1] - fArray2[n5][1];
            ++n4;
        }
        return fArray3;
    }

    public static float[][] openBezierFrame(float[][] fArray, float[][] fArray2) {
        if (!FloatArray.checkArrayPair(fArray, fArray2, 2)) {
            return new float[0][2];
        }
        int n = fArray.length;
        if (n == 0) {
            return new float[0][2];
        }
        int n2 = 3 * n - 2;
        int n3 = n - 1;
        float[][] fArray3 = new float[n2][2];
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n4 + 1;
            int n6 = 3 * n4;
            int n7 = n6 + 1;
            int n8 = n6 + 2;
            fArray3[n6][0] = fArray[n4][0];
            fArray3[n6][1] = fArray[n4][1];
            fArray3[n7][0] = fArray[n4][0] + fArray2[n4][0];
            fArray3[n7][1] = fArray[n4][1] + fArray2[n4][1];
            fArray3[n8][0] = fArray[n5][0] - fArray2[n5][0];
            fArray3[n8][1] = fArray[n5][1] - fArray2[n5][1];
            ++n4;
        }
        fArray3[n2 - 1][0] = fArray[n3][0];
        fArray3[n2 - 1][1] = fArray[n3][1];
        return fArray3;
    }

    public static float[][] bezierTangentSegments(float[][] fArray, float[][] fArray2) {
        if (!FloatArray.checkArrayPair(fArray, fArray2, 2)) {
            return new float[0][2];
        }
        int n = fArray.length;
        int n2 = 2 * n;
        float[][] fArray3 = new float[n2][2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 2 * n3;
            int n5 = n4 + 1;
            fArray3[n4][0] = fArray[n3][0] - fArray2[n3][0];
            fArray3[n4][1] = fArray[n3][1] - fArray2[n3][1];
            fArray3[n5][0] = fArray[n3][0] + fArray2[n3][0];
            fArray3[n5][1] = fArray[n3][1] + fArray2[n3][1];
            ++n3;
        }
        return fArray3;
    }

    public static GeneralPath append(GeneralPath generalPath, Shape[] shapeArray, boolean[] blArray) {
        if (generalPath == null) {
            generalPath = new GeneralPath();
        }
        if (shapeArray == null) {
            return generalPath;
        }
        int n = shapeArray.length;
        if (blArray == null) {
            blArray = new boolean[n + 1];
        } else if (blArray.length != n + 1) {
            return generalPath;
        }
        int n2 = 0;
        while (n2 < n) {
            if (shapeArray[n2] != null) {
                generalPath.append(shapeArray[n2], blArray[n2]);
            }
            ++n2;
        }
        if (blArray[n]) {
            generalPath.closePath();
        }
        return generalPath;
    }

    public static GeneralPath append(GeneralPath generalPath, Shape[] shapeArray, boolean bl) {
        if (shapeArray == null) {
            return generalPath;
        }
        int n = shapeArray.length;
        boolean[] blArray = new boolean[n + 1];
        int n2 = 0;
        while (n2 <= n) {
            blArray[n2] = bl;
            ++n2;
        }
        return Path.append(generalPath, shapeArray, blArray);
    }

    public static void dot(Graphics graphics, double d, double d2, Color color) {
        if (graphics == null) {
            return;
        }
        if (color == null) {
            color = Color.red;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d - 2.0, d2 - 2.0, 4.0, 4.0);
        PaintMode.fill(graphics, double_, color);
    }

    public static void line(Graphics graphics, double d, double d2, double d3, double d4, Color color) {
        if (graphics == null) {
            return;
        }
        if (color == null) {
            color = Color.green;
        }
        Line2D.Double double_ = new Line2D.Double(d, d2, d3, d4);
        PaintMode.draw(graphics, double_, color, new BasicStroke(2.0f));
    }

    public static void showShapeFrame(Graphics graphics, Shape shape, Color color) {
        if (graphics == null || shape == null) {
            return;
        }
        if (color == null) {
            color = Color.green;
        }
        PathIterator pathIterator = shape.getPathIterator(null);
        double[] dArray = new double[6];
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    d = dArray[0];
                    d2 = dArray[1];
                    d3 = d;
                    d4 = d2;
                    bl = true;
                    break;
                }
                case 1: {
                    if (bl) {
                        Path.line(graphics, d, d2, dArray[0], dArray[1], color);
                    }
                    d = dArray[0];
                    d2 = dArray[1];
                    bl = true;
                    break;
                }
                case 2: {
                    if (bl) {
                        Path.line(graphics, d, d2, dArray[0], dArray[1], color);
                    }
                    Path.line(graphics, dArray[0], dArray[1], dArray[2], dArray[3], color);
                    d = dArray[2];
                    d2 = dArray[3];
                    bl = true;
                    break;
                }
                case 3: {
                    if (bl) {
                        Path.line(graphics, d, d2, dArray[0], dArray[1], color);
                    }
                    Path.line(graphics, dArray[0], dArray[1], dArray[2], dArray[3], color);
                    Path.line(graphics, dArray[2], dArray[3], dArray[4], dArray[5], color);
                    d = dArray[4];
                    d2 = dArray[5];
                    bl = true;
                    break;
                }
                case 4: {
                    if (bl) {
                        Path.line(graphics, d, d2, d3, d4, color);
                    }
                    d = d3;
                    d2 = d4;
                    break;
                }
            }
            pathIterator.next();
        }
    }

    public static void showShapeDots(Graphics graphics, Shape shape, Color color) {
        if (graphics == null || shape == null) {
            return;
        }
        if (color == null) {
            color = Color.red;
        }
        PathIterator pathIterator = shape.getPathIterator(null);
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    Path.dot(graphics, dArray[0], dArray[1], color);
                    break;
                }
                case 1: {
                    Path.dot(graphics, dArray[0], dArray[1], color);
                    break;
                }
                case 2: {
                    Path.dot(graphics, dArray[2], dArray[3], color);
                    break;
                }
                case 3: {
                    Path.dot(graphics, dArray[4], dArray[5], color);
                    break;
                }
            }
            pathIterator.next();
        }
    }

    public static void showShapeFrameDots(Graphics graphics, Shape shape, Color color) {
        if (graphics == null || shape == null) {
            return;
        }
        if (color == null) {
            color = Color.orange;
        }
        PathIterator pathIterator = shape.getPathIterator(null);
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    Path.dot(graphics, dArray[0], dArray[1], color);
                    break;
                }
                case 1: {
                    Path.dot(graphics, dArray[0], dArray[1], color);
                    break;
                }
                case 2: {
                    Path.dot(graphics, dArray[0], dArray[1], color);
                    Path.dot(graphics, dArray[2], dArray[3], color);
                    break;
                }
                case 3: {
                    Path.dot(graphics, dArray[0], dArray[1], color);
                    Path.dot(graphics, dArray[2], dArray[3], color);
                    Path.dot(graphics, dArray[4], dArray[5], color);
                    break;
                }
            }
            pathIterator.next();
        }
    }

    public static void showShapeStructure(Graphics graphics, Shape shape, Color color, Color color2, Color color3, Color color4) {
        if (graphics == null || shape == null) {
            return;
        }
        if (color == null) {
            color = Color.black;
        }
        if (color2 == null) {
            color2 = Color.green;
        }
        if (color3 == null) {
            color3 = Color.red;
        }
        if (color4 == null) {
            color4 = Color.orange;
        }
        PaintMode.fill(graphics, shape, color);
        Path.showShapeFrame(graphics, shape, color2);
        Path.showShapeFrameDots(graphics, shape, color4);
        Path.showShapeDots(graphics, shape, color3);
        PaintMode.draw(graphics, shape, color3, new BasicStroke(2.0f));
    }

    public static void showShapeStructure(Graphics graphics, Shape shape) {
        Path.showShapeStructure(graphics, shape, null, null, null, null);
    }

    public static String shapeToString(Shape shape) {
        if (shape == null) {
            return "Null shape\n\n";
        }
        StringBuffer stringBuffer = new StringBuffer();
        PathIterator pathIterator = shape.getPathIterator(null);
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    stringBuffer.append("SEG_MOVETO\n");
                    stringBuffer.append("x: " + dArray[0] + " y: " + dArray[1] + "\n");
                    stringBuffer.append("\n");
                    break;
                }
                case 1: {
                    stringBuffer.append("SEG_LINETO\n");
                    stringBuffer.append("x: " + dArray[0] + " y: " + dArray[1] + "\n");
                    stringBuffer.append("\n");
                    break;
                }
                case 2: {
                    stringBuffer.append("SEG_QUADTO\n");
                    stringBuffer.append("x: " + dArray[0] + " y: " + dArray[1] + "\n");
                    stringBuffer.append("x: " + dArray[2] + " y: " + dArray[3] + "\n");
                    stringBuffer.append("\n");
                    break;
                }
                case 3: {
                    stringBuffer.append("SEG_CUBICTO\n");
                    stringBuffer.append("x: " + dArray[0] + " y: " + dArray[1] + "\n");
                    stringBuffer.append("x: " + dArray[2] + " y: " + dArray[3] + "\n");
                    stringBuffer.append("x: " + dArray[4] + " y: " + dArray[5] + "\n");
                    stringBuffer.append("\n");
                    break;
                }
                case 4: {
                    stringBuffer.append("SEG_CLOSE\n");
                    stringBuffer.append("\n");
                    break;
                }
                default: {
                    stringBuffer.append("Error: Unknown path type\n");
                    stringBuffer.append("\n");
                }
            }
            pathIterator.next();
        }
        return stringBuffer.toString();
    }

    public static interface Strategy {
        public GeneralPath makePath(float[][] var1, float[][] var2, ClosureMode var3, WindingRule var4);
    }

    private final class 1
    implements Strategy {
        public GeneralPath makePath(float[][] fArray, float[][] fArray2, ClosureMode closureMode, WindingRule windingRule) {
            int n;
            GeneralPath generalPath = new GeneralPath(windingRule.rule());
            if (FloatArray.checkArray(fArray, 2) && (n = fArray.length) > 0) {
                generalPath.moveTo(fArray[0][0], fArray[0][1]);
                int n2 = closureMode.limit(n);
                int n3 = 1;
                while (n3 <= n2) {
                    int n4 = n3 < n ? n3 : 0;
                    generalPath.lineTo(fArray[n4][0], fArray[n4][1]);
                    ++n3;
                }
                if (closureMode == ClosureMode.CLOSED) {
                    generalPath.closePath();
                }
            }
            return generalPath;
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements Strategy {
        public GeneralPath makePath(float[][] fArray, float[][] fArray2, ClosureMode closureMode, WindingRule windingRule) {
            GeneralPath generalPath = new GeneralPath(windingRule.rule());
            if (FloatArray.checkArray(fArray, 2)) {
                int n = fArray.length;
                int n2 = 0;
                while (n2 < n) {
                    generalPath.moveTo(fArray[n2][0], fArray[n2][1]);
                    generalPath.lineTo(fArray[n2][0], fArray[n2][1]);
                    ++n2;
                }
            }
            return generalPath;
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements Strategy {
        public GeneralPath makePath(float[][] fArray, float[][] fArray2, ClosureMode closureMode, WindingRule windingRule) {
            int n;
            GeneralPath generalPath = new GeneralPath(windingRule.rule());
            if (FloatArray.checkArrayPair(fArray, fArray2, 2) && (n = fArray.length) > 0) {
                generalPath.moveTo(fArray[0][0], fArray[0][1]);
                int n2 = closureMode.limit(n);
                int n3 = 1;
                while (n3 <= n2) {
                    int n4 = n3 - 1;
                    int n5 = n3 < n ? n3 : 0;
                    float f = fArray[n4][0] + fArray2[n4][0];
                    float f2 = fArray[n4][1] + fArray2[n4][1];
                    float f3 = fArray[n5][0] - fArray2[n5][0];
                    float f4 = fArray[n5][1] - fArray2[n5][1];
                    float f5 = fArray[n5][0];
                    float f6 = fArray[n5][1];
                    generalPath.curveTo(f, f2, f3, f4, f5, f6);
                    ++n3;
                }
                if (closureMode == ClosureMode.CLOSED) {
                    generalPath.closePath();
                }
            }
            return generalPath;
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements Strategy {
        public GeneralPath makePath(float[][] fArray, float[][] fArray2, ClosureMode closureMode, WindingRule windingRule) {
            if (closureMode == ClosureMode.CLOSED) {
                return POLYGON.makePath(Path.closedBezierFrame(fArray, fArray2), null, closureMode, windingRule);
            }
            return POLYGON.makePath(Path.openBezierFrame(fArray, fArray2), null, closureMode, windingRule);
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements Strategy {
        public GeneralPath makePath(float[][] fArray, float[][] fArray2, ClosureMode closureMode, WindingRule windingRule) {
            int n;
            GeneralPath generalPath = new GeneralPath(windingRule.rule());
            if (FloatArray.checkArrayPair(fArray, fArray2, 2) && (n = fArray.length) > 0) {
                float[][] fArray3 = Path.bezierTangentSegments(fArray, fArray2);
                int n2 = 0;
                while (n2 < n) {
                    int n3 = 2 * n2;
                    int n4 = n3 + 1;
                    generalPath.moveTo(fArray3[n3][0], fArray3[n3][1]);
                    generalPath.lineTo(fArray3[n4][0], fArray3[n4][1]);
                    ++n2;
                }
            }
            return generalPath;
        }

        /* synthetic */ 5() {
        }
    }
}

