/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.AbstractMutatablePaintable;
import edu.neu.ccs.gui.MutatablePaintable;
import edu.neu.ccs.gui.Mutator;
import edu.neu.ccs.gui.Paintable;
import edu.neu.ccs.gui.PaintableTools;
import edu.neu.ccs.gui.TransformFactory;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class PaintableSequence
extends AbstractMutatablePaintable {
    public static String SET_PAINTABLE = "set.paintable";
    public static String REMOVE_PAINTABLE = "remove.paintable";
    private Vector paintablesequence = new Vector(16);
    private Mutator.StrategyUsage usage = Mutator.MUTATE_AS_ITEMS;

    public PaintableSequence() {
        this(null, null);
    }

    public PaintableSequence(Paintable[] paintableArray) {
        this(paintableArray, null);
    }

    public PaintableSequence(Paintable[] paintableArray, Mutator.StrategyUsage strategyUsage) {
        this.appendSequence(paintableArray);
        this.setMutatorStrategyUsage(strategyUsage);
    }

    public final void clear() {
        int n = this.paintablesequence.size();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            this.removeForwardingListener(this.paintablesequence.get(n2));
            ++n2;
        }
        this.paintablesequence.clear();
        this.firePropertyChange(REMOVE_PAINTABLE, null, null);
    }

    public final void setSequence(Paintable[] paintableArray) {
        int n;
        if (paintableArray == null) {
            this.clear();
            return;
        }
        int n2 = this.paintablesequence.size();
        if (n2 == (n = paintableArray.length)) {
            boolean bl = true;
            int n3 = 0;
            while (n3 < n2 && bl) {
                bl = this.getMutatablePaintable(n3) == paintableArray[n3];
                ++n3;
            }
            if (bl) {
                return;
            }
        }
        this.clear();
        this.appendSequence(paintableArray);
    }

    public final void appendSequence(Paintable[] paintableArray) {
        if (paintableArray == null) {
            return;
        }
        int n = paintableArray.length;
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            MutatablePaintable mutatablePaintable = this.wrapPaintable(paintableArray[n2]);
            this.addForwardingListener(mutatablePaintable);
            this.paintablesequence.add(mutatablePaintable);
            ++n2;
        }
        this.firePropertyChange(SET_PAINTABLE, null, null);
    }

    public final void setPaintable(int n, Paintable paintable) {
        if (n < 0 || n >= this.paintablesequence.size()) {
            return;
        }
        MutatablePaintable mutatablePaintable = this.getMutatablePaintable(n);
        MutatablePaintable mutatablePaintable2 = this.wrapPaintable(paintable);
        if (mutatablePaintable2 == mutatablePaintable) {
            return;
        }
        this.removeAndAddForwardingListener(mutatablePaintable, mutatablePaintable2);
        this.paintablesequence.set(n, mutatablePaintable2);
        this.firePropertyChange(SET_PAINTABLE, null, null);
    }

    public final void addPaintable(int n, Paintable paintable) {
        if (n < 0 || n > this.paintablesequence.size()) {
            return;
        }
        MutatablePaintable mutatablePaintable = this.wrapPaintable(paintable);
        this.addForwardingListener(mutatablePaintable);
        this.paintablesequence.add(n, mutatablePaintable);
        this.firePropertyChange(SET_PAINTABLE, null, null);
    }

    public final void addPaintableAtTop(Paintable paintable) {
        this.addPaintable(0, paintable);
    }

    public final void appendPaintable(Paintable paintable) {
        this.addPaintable(this.paintablesequence.size(), paintable);
    }

    public final void removePaintable(int n) {
        if (n < 0 || n >= this.paintablesequence.size()) {
            return;
        }
        this.removeForwardingListener(this.paintablesequence.get(n));
        this.paintablesequence.remove(n);
        this.firePropertyChange(REMOVE_PAINTABLE, null, null);
    }

    public final void removePaintable(MutatablePaintable mutatablePaintable) {
        this.removePaintable(this.getIndex(mutatablePaintable));
    }

    public final MutatablePaintable getMutatablePaintable(int n) {
        if (n < 0 || n >= this.paintablesequence.size()) {
            return null;
        }
        return (MutatablePaintable)this.paintablesequence.get(n);
    }

    public final int getIndex(MutatablePaintable mutatablePaintable) {
        int n = -1;
        if (mutatablePaintable == null) {
            return n;
        }
        int n2 = this.length();
        int n3 = 0;
        while (n3 < n2) {
            if (mutatablePaintable == this.getMutatablePaintable(n3)) {
                n = n3;
                break;
            }
            ++n3;
        }
        return n;
    }

    public final int length() {
        return this.paintablesequence.size();
    }

    public final void shiftPaintable(int n, int n2) {
        int n3 = this.length();
        if (n < 0 || n >= n3) {
            return;
        }
        if (n2 < 0 || n2 >= n3) {
            return;
        }
        if (n == n2) {
            return;
        }
        if (n2 > n) {
            --n2;
        }
        MutatablePaintable mutatablePaintable = this.getMutatablePaintable(n);
        this.removePaintable(n);
        this.addPaintable(n2, mutatablePaintable);
    }

    public final void shiftPaintableToTop(int n) {
        this.shiftPaintable(n, 0);
    }

    public final void shiftPaintableToBottom(int n) {
        this.shiftPaintable(n, this.length() - 1);
    }

    public final void shiftPaintableUp(int n) {
        this.shiftPaintable(n, n - 1);
    }

    public final void shiftPaintableDown(int n) {
        this.shiftPaintable(n, n + 1);
    }

    public final void shiftPaintable(MutatablePaintable mutatablePaintable, int n) {
        this.shiftPaintable(this.getIndex(mutatablePaintable), n);
    }

    public final void shiftPaintableToTop(MutatablePaintable mutatablePaintable) {
        this.shiftPaintable(this.getIndex(mutatablePaintable), 0);
    }

    public final void shiftPaintableToBottom(MutatablePaintable mutatablePaintable) {
        this.shiftPaintable(this.getIndex(mutatablePaintable), this.length() - 1);
    }

    public final void shiftPaintableUp(MutatablePaintable mutatablePaintable) {
        int n = this.getIndex(mutatablePaintable);
        this.shiftPaintable(n, n - 1);
    }

    public final void shiftPaintableDown(MutatablePaintable mutatablePaintable) {
        int n = this.getIndex(mutatablePaintable);
        this.shiftPaintable(n, n + 1);
    }

    public final MutatablePaintable[] toArray() {
        return this.paintablesequence.toArray(new MutatablePaintable[0]);
    }

    public final void paint(Graphics graphics) {
        if (graphics == null || !this.isVisible()) {
            return;
        }
        int n = this.paintablesequence.size();
        if (n == 0) {
            return;
        }
        Graphics2D graphics2D = this.getPreparedGraphics2D(graphics);
        int n2 = n - 1;
        while (n2 >= 0) {
            MutatablePaintable mutatablePaintable = this.getMutatablePaintable(n2);
            if (mutatablePaintable != null) {
                mutatablePaintable.paint(graphics2D);
            }
            --n2;
        }
    }

    public final Rectangle2D getBounds2D() {
        Rectangle2D rectangle2D = this.getDefaultBounds2D();
        if (rectangle2D != null) {
            return rectangle2D;
        }
        return this.getOriginalBounds2D();
    }

    public final Point2D getCenter() {
        Point2D point2D = this.getDefaultCenter();
        if (point2D != null) {
            return point2D;
        }
        return this.getOriginalCenter();
    }

    public final Rectangle2D getOriginalBounds2D() {
        Rectangle2D rectangle2D = null;
        int n = this.paintablesequence.size();
        int n2 = 0;
        while (n2 < n) {
            Rectangle2D rectangle2D2;
            MutatablePaintable mutatablePaintable = this.getMutatablePaintable(n2);
            if (mutatablePaintable != null && !((rectangle2D2 = mutatablePaintable.getBounds2D()).getWidth() <= 0.0) && !(rectangle2D2.getHeight() <= 0.0)) {
                if (rectangle2D == null) {
                    rectangle2D = rectangle2D2;
                } else {
                    rectangle2D.add(rectangle2D2);
                }
            }
            ++n2;
        }
        if (rectangle2D == null) {
            return new Rectangle2D.Double();
        }
        return rectangle2D;
    }

    public final Point2D getOriginalCenter() {
        Rectangle2D rectangle2D = this.getOriginalBounds2D();
        double d = rectangle2D.getCenterX();
        double d2 = rectangle2D.getCenterY();
        return new Point2D.Double(d, d2);
    }

    public final void setMutator(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = this.getMutator();
        AffineTransform affineTransform3 = this.getMutatorInverse();
        if (affineTransform == null || affineTransform.equals(affineTransform2)) {
            return;
        }
        try {
            AffineTransform affineTransform4 = affineTransform.createInverse();
            AffineTransform affineTransform5 = TransformFactory.compose(affineTransform, affineTransform3);
            int n = this.paintablesequence.size();
            int n2 = 0;
            while (n2 < n) {
                MutatablePaintable mutatablePaintable = this.getMutatablePaintable(n2);
                if (mutatablePaintable != null) {
                    mutatablePaintable.addPostMutation(affineTransform5);
                }
                ++n2;
            }
            super.setMutator(affineTransform);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return;
        }
    }

    public final void addPreMutation(Mutator.Strategy strategy) {
        if (strategy == null) {
            return;
        }
        if (this.usage == Mutator.MUTATE_AS_ITEMS) {
            int n = this.paintablesequence.size();
            int n2 = 0;
            while (n2 < n) {
                MutatablePaintable mutatablePaintable = this.getMutatablePaintable(n2);
                if (mutatablePaintable != null) {
                    mutatablePaintable.addPreMutation(strategy);
                }
                ++n2;
            }
        } else {
            super.addPreMutation(strategy);
        }
    }

    public final void addPostMutation(Mutator.Strategy strategy) {
        if (strategy == null) {
            return;
        }
        if (this.usage == Mutator.MUTATE_AS_ITEMS) {
            int n = this.paintablesequence.size();
            int n2 = 0;
            while (n2 < n) {
                MutatablePaintable mutatablePaintable = this.getMutatablePaintable(n2);
                if (mutatablePaintable != null) {
                    mutatablePaintable.addPostMutation(strategy);
                }
                ++n2;
            }
        } else {
            super.addPostMutation(strategy);
        }
    }

    public final void setMutatorStrategyUsage(Mutator.StrategyUsage strategyUsage) {
        if (strategyUsage != null) {
            this.usage = strategyUsage;
        }
    }

    public final Mutator.StrategyUsage getMutatorStrategyUsage() {
        return this.usage;
    }

    public final void setMutateAsGroup() {
        this.usage = Mutator.MUTATE_AS_GROUP;
    }

    public final void setMutateAsItems() {
        this.usage = Mutator.MUTATE_AS_ITEMS;
    }

    public final boolean contains(double d, double d2) {
        return this.hitsItem(d, d2) != null;
    }

    public final MutatablePaintable hits(double d, double d2) {
        MutatablePaintable mutatablePaintable = this.hitsItem(d, d2);
        if (mutatablePaintable == null) {
            return null;
        }
        if (this.usage == Mutator.MUTATE_AS_ITEMS) {
            return mutatablePaintable;
        }
        return this;
    }

    public final MutatablePaintable hits(Point2D point2D) {
        if (point2D == null) {
            return null;
        }
        return this.hits(point2D.getX(), point2D.getY());
    }

    public final MutatablePaintable hitsItem(double d, double d2) {
        if (!this.possiblyContains(d, d2)) {
            return null;
        }
        int n = this.paintablesequence.size();
        int n2 = 0;
        while (n2 < n) {
            MutatablePaintable mutatablePaintable = this.getMutatablePaintable(n2);
            if (mutatablePaintable != null && mutatablePaintable.contains(d, d2)) {
                return mutatablePaintable;
            }
            ++n2;
        }
        return null;
    }

    public final MutatablePaintable hitsItem(Point2D point2D) {
        if (point2D == null) {
            return null;
        }
        return this.hits(point2D.getX(), point2D.getY());
    }

    protected MutatablePaintable wrapPaintable(Paintable paintable) {
        return PaintableTools.wrapPaintable(paintable);
    }
}

