/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.JPTComponent;
import edu.neu.ccs.gui.Paintable;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.SupportsPropertyChange;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.border.Border;

public class PaintableComponent
extends JPTComponent
implements Icon {
    public static final String SET_PAINTABLE = "set.paintable";
    private Paintable paintable;
    private RefreshListener listener = new RefreshListener();

    public PaintableComponent(Paintable paintable) {
        this(paintable, null, false, null);
    }

    public PaintableComponent(Paintable paintable, Color color) {
        this(paintable, color, false, null);
    }

    public PaintableComponent(Paintable paintable, Color color, boolean bl) {
        this(paintable, color, bl, null);
    }

    public PaintableComponent(Paintable paintable, Color color, boolean bl, Border border) {
        if (paintable == null) {
            throw new NullPointerException("Null Paintable passed to PaintableComponent constructor");
        }
        this.paintable = paintable;
        if (color != null) {
            this.setBackground(color);
        }
        this.setOpaque(bl);
        if (border != null) {
            this.setBorder(border);
        }
        this.refresh();
        this.addComponentRefreshListener();
    }

    public void setPaintable(Paintable paintable) {
        if (paintable == null || paintable == this.paintable) {
            return;
        }
        this.paintable = paintable;
        this.firePropertyChange(SET_PAINTABLE, null, null);
    }

    public Paintable getPaintable() {
        return this.paintable;
    }

    public Rectangle2D getDefaultBounds2D() {
        Rectangle2D rectangle2D = this.paintable.getBounds2D();
        int n = (int)rectangle2D.getMinX();
        int n2 = (int)rectangle2D.getMinY();
        int n3 = (int)rectangle2D.getWidth();
        int n4 = (int)rectangle2D.getHeight();
        Insets insets = this.getInsets();
        if (insets != null) {
            n -= insets.left;
            n2 -= insets.top;
            n3 += insets.left + insets.right;
            n4 += insets.top + insets.bottom;
        }
        rectangle2D.setRect(n, n2, n3, n4);
        return rectangle2D;
    }

    public Point getDefaultLocation() {
        Rectangle2D rectangle2D = this.getDefaultBounds2D();
        int n = (int)rectangle2D.getMinX();
        int n2 = (int)rectangle2D.getMinY();
        return new Point(n, n2);
    }

    public Dimension getPreferredSize() {
        Rectangle2D rectangle2D = this.getDefaultBounds2D();
        int n = (int)rectangle2D.getWidth();
        int n2 = (int)rectangle2D.getHeight();
        return new Dimension(n, n2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getSize() {
        return this.getPreferredSize();
    }

    public int getIconWidth() {
        return (int)this.paintable.getBounds2D().getWidth();
    }

    public int getIconHeight() {
        return (int)this.paintable.getBounds2D().getHeight();
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Color color;
        if (graphics == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Rectangle2D rectangle2D = this.paintable.getBounds2D();
        int n3 = n - (int)rectangle2D.getMinX();
        int n4 = n2 - (int)rectangle2D.getMinY();
        graphics2D.translate(n3, n4);
        if (component != null && component.isOpaque() && (color = component.getBackground()) != null) {
            graphics2D.setPaint(color);
            graphics2D.fill(rectangle2D);
        }
        this.paintable.paint(graphics2D);
        graphics2D.setPaint(paint);
        graphics2D.translate(-n3, -n4);
    }

    protected void paintComponent(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        Insets insets = this.getInsets();
        if (insets != null) {
            n = insets.left;
            n2 = insets.top;
        }
        this.paintIcon(this, graphics, n, n2);
    }

    public void refresh() {
        this.setDefaultSize();
        this.setDefaultLocation();
        this.refreshComponent();
    }

    private void addComponentRefreshListener() {
        this.addPropertyChangeListener(this.listener);
        if (this.paintable instanceof SupportsPropertyChange) {
            SupportsPropertyChange supportsPropertyChange = (SupportsPropertyChange)((Object)this.paintable);
            supportsPropertyChange.addPropertyChangeListener(this.listener);
        }
    }

    private void setDefaultSize() {
        this.setSize(this.getPreferredSize());
    }

    private void setDefaultLocation() {
        this.setLocation(this.getDefaultLocation());
    }

    private class RefreshListener
    extends SimpleAction {
        public void perform() {
            PaintableComponent.this.refresh();
        }

        RefreshListener() {
        }
    }
}

