/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.Paintable;
import edu.neu.ccs.gui.PaintableComponent;
import edu.neu.ccs.gui.Refresh;
import edu.neu.ccs.gui.SimpleAction;
import edu.neu.ccs.gui.SupportsPropertyChange;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;

public class PaintableButton
extends JButton {
    public static final String SET_PAINTABLE = "set.paintable";
    private static final Insets DEFAULT_INSETS = new Insets(2, 2, 2, 2);
    private Paintable paintable = null;
    private Icon icon = null;
    private RefreshListener listener = new RefreshListener();

    public PaintableButton(Paintable paintable) {
        this(paintable, null, null, null);
    }

    public PaintableButton(Paintable paintable, Action action) {
        this(paintable, action, null, null);
    }

    public PaintableButton(Paintable paintable, Action action, Color color) {
        this(paintable, action, color, null);
    }

    public PaintableButton(Paintable paintable, Action action, Color color, Insets insets) {
        if (paintable == null) {
            throw new NullPointerException("Null Paintable passed to PaintableButton constructor");
        }
        this.setPaintable(paintable);
        if (action != null) {
            this.setAction(action);
        }
        if (color != null) {
            this.setBackground(color);
        }
        if (insets == null) {
            insets = DEFAULT_INSETS;
        }
        this.setMargin(insets);
        this.refresh();
        this.addComponentRefreshListener();
    }

    public void setPaintable(Paintable paintable) {
        if (paintable == null || paintable == this.paintable) {
            return;
        }
        this.paintable = paintable;
        this.icon = new PaintableComponent(paintable);
        this.setIcon(this.icon);
        this.firePropertyChange(SET_PAINTABLE, null, null);
    }

    public Paintable getPaintable() {
        return this.paintable;
    }

    public void setAction(Action action) {
        super.setAction(action);
        this.setText(null);
        this.setIcon(this.icon);
    }

    public Rectangle2D getDefaultBounds2D() {
        Rectangle2D rectangle2D = this.paintable.getBounds2D();
        int n = (int)rectangle2D.getMinX();
        int n2 = (int)rectangle2D.getMinY();
        int n3 = (int)rectangle2D.getWidth();
        int n4 = (int)rectangle2D.getHeight();
        Insets insets = this.getInsets();
        if (insets != null) {
            n -= insets.left;
            n2 -= insets.top;
            n3 += insets.left + insets.right;
            n4 += insets.top + insets.bottom;
        }
        rectangle2D.setRect(n, n2, n3, n4);
        return rectangle2D;
    }

    public Point getDefaultLocation() {
        Rectangle2D rectangle2D = this.getDefaultBounds2D();
        int n = (int)rectangle2D.getMinX();
        int n2 = (int)rectangle2D.getMinY();
        return new Point(n, n2);
    }

    public Dimension getPreferredSize() {
        Rectangle2D rectangle2D = this.getDefaultBounds2D();
        int n = (int)rectangle2D.getWidth();
        int n2 = (int)rectangle2D.getHeight();
        return new Dimension(n, n2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getSize() {
        return this.getPreferredSize();
    }

    public void refresh() {
        this.setDefaultSize();
        this.setDefaultLocation();
        this.refreshComponent();
    }

    public void refreshComponent() {
        Refresh.packParentWindow(this);
    }

    private void addComponentRefreshListener() {
        this.addChangeListener(this.listener);
        this.addPropertyChangeListener(this.listener);
        if (this.paintable instanceof SupportsPropertyChange) {
            SupportsPropertyChange supportsPropertyChange = (SupportsPropertyChange)((Object)this.paintable);
            supportsPropertyChange.addPropertyChangeListener(this.listener);
        }
    }

    private void setDefaultSize() {
        this.setSize(this.getPreferredSize());
    }

    private void setDefaultLocation() {
        this.setLocation(this.getDefaultLocation());
    }

    private class RefreshListener
    extends SimpleAction {
        public void perform() {
            PaintableButton.this.refresh();
        }

        RefreshListener() {
        }
    }
}

