/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.Colors;
import edu.neu.ccs.gui.JPTComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.border.Border;

public class PaintSwatch
extends JPTComponent
implements Icon {
    public static final String SET_PAINT = "set.paint";
    public static final String SET_SIZE = "set.size";
    public static final String SET_BORDER = "set.border";
    public static final int DEFAULT_SWATCH_SIZE = 20;
    public static final int BORDER_SIZE = 2;
    public static final Border BLACK_BORDER = BorderFactory.createLineBorder(Colors.Black, 2);
    public static final Border WHITE_BORDER = BorderFactory.createLineBorder(Colors.White, 2);
    public static final Border TRANSPARENT_BORDER = BorderFactory.createLineBorder(Colors.Transparent, 2);
    private Paint paint = Colors.transparent;
    private int xSize = 0;
    private int ySize = 0;
    private Rectangle2D area;

    public PaintSwatch() {
        this(null, 20, 20, BLACK_BORDER);
    }

    public PaintSwatch(Paint paint) {
        this(paint, 20, 20, BLACK_BORDER);
    }

    public PaintSwatch(Paint paint, int n, int n2) {
        this(paint, n, n2, BLACK_BORDER);
    }

    public PaintSwatch(Paint paint, Border border) {
        this(paint, 20, 20, border);
    }

    public PaintSwatch(Paint paint, int n, int n2, Border border) {
        this.setPaint(paint);
        this.setSize(n, n2);
        this.setBorder(border);
    }

    public Dimension getPreferredSize() {
        int n = this.xSize;
        int n2 = this.ySize;
        Insets insets = this.getInsets();
        if (insets != null) {
            n += insets.left + insets.right;
            n2 += insets.top + insets.bottom;
        }
        return new Dimension(n, n2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getSize() {
        return this.getPreferredSize();
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            paint = Colors.transparent;
        }
        if (this.paint == paint) {
            return;
        }
        this.paint = paint;
        this.repaint();
        this.firePropertyChange(SET_PAINT, null, null);
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setSize(int n, int n2) {
        n = n >= 1 ? n : 1;
        int n3 = n2 = n2 >= 1 ? n2 : 1;
        if (this.xSize == n && this.ySize == n2) {
            return;
        }
        this.xSize = n;
        this.ySize = n2;
        this.area = new Rectangle2D.Double(0.0, 0.0, n, n2);
        this.refreshComponent();
        this.firePropertyChange(SET_SIZE, null, null);
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }

    public void setBorder(Border border) {
        if (border == null || this.getBorder() == border) {
            return;
        }
        super.setBorder(border);
        this.refreshComponent();
        this.firePropertyChange(SET_BORDER, null, null);
    }

    public int getIconWidth() {
        return this.xSize;
    }

    public int getIconHeight() {
        return this.ySize;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Color color;
        if (graphics == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        graphics2D.translate(n, n2);
        if (component != null && component.isOpaque() && (color = component.getBackground()) != null) {
            graphics2D.setPaint(color);
            graphics2D.fill(this.area);
        }
        graphics2D.setPaint(this.paint);
        graphics2D.fill(this.area);
        graphics2D.setPaint(paint);
        graphics2D.translate(-n, -n2);
    }

    protected void paintComponent(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        Insets insets = this.getInsets();
        if (insets != null) {
            n = insets.left;
            n2 = insets.top;
        }
        this.paintIcon(this, graphics, n, n2);
    }
}

