/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.ShapePaintable;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class PaintMode {
    public static final PaintMode FILL = new 1();
    public static final PaintMode DRAW = new 2();
    public static final PaintMode FILL_DRAW = new 3();

    public abstract void paint(ShapePaintable var1, Graphics var2);

    public abstract Rectangle2D getBounds2D(ShapePaintable var1);

    public abstract Shape getOutline(ShapePaintable var1);

    public abstract boolean contains(ShapePaintable var1, double var2, double var4);

    public abstract boolean contains(ShapePaintable var1, Point2D var2);

    public static void fill(Graphics graphics, Shape shape, Paint paint) {
        ShapePaintable shapePaintable = new ShapePaintable(shape, FILL, paint);
        shapePaintable.paint(graphics);
    }

    public static void draw(Graphics graphics, Shape shape, Paint paint) {
        ShapePaintable shapePaintable = new ShapePaintable(shape, DRAW, null, paint);
        shapePaintable.paint(graphics);
    }

    public static void draw(Graphics graphics, Shape shape, Paint paint, Stroke stroke) {
        ShapePaintable shapePaintable = new ShapePaintable(shape, DRAW, null, paint, stroke);
        shapePaintable.paint(graphics);
    }

    public static void filldraw(Graphics graphics, Shape shape, Paint paint, Paint paint2) {
        ShapePaintable shapePaintable = new ShapePaintable(shape, FILL_DRAW, paint, paint2);
        shapePaintable.paint(graphics);
    }

    public static void filldraw(Graphics graphics, Shape shape, Paint paint, Paint paint2, Stroke stroke) {
        ShapePaintable shapePaintable = new ShapePaintable(shape, FILL_DRAW, paint, paint2, stroke);
        shapePaintable.paint(graphics);
    }

    private final class 1
    extends PaintMode {
        public void paint(ShapePaintable shapePaintable, Graphics graphics) {
            if (shapePaintable == null || graphics == null) {
                return;
            }
            Shape shape = shapePaintable.getShape();
            if (shape == null) {
                return;
            }
            Graphics2D graphics2D = shapePaintable.getPreparedGraphics2D(graphics);
            graphics2D.setPaint(shapePaintable.getFillPaint());
            graphics2D.fill(shape);
        }

        public Rectangle2D getBounds2D(ShapePaintable shapePaintable) {
            if (shapePaintable == null) {
                return new Rectangle2D.Double();
            }
            Shape shape = shapePaintable.getShape();
            if (shape == null) {
                return new Rectangle2D.Double();
            }
            return shape.getBounds2D();
        }

        public Shape getOutline(ShapePaintable shapePaintable) {
            if (shapePaintable == null) {
                return null;
            }
            return shapePaintable.getShape();
        }

        public boolean contains(ShapePaintable shapePaintable, double d, double d2) {
            if (shapePaintable == null) {
                return false;
            }
            Shape shape = shapePaintable.getShape();
            if (shape == null) {
                return false;
            }
            return shape.contains(d, d2);
        }

        public boolean contains(ShapePaintable shapePaintable, Point2D point2D) {
            if (point2D == null) {
                return false;
            }
            return this.contains(shapePaintable, point2D.getX(), point2D.getY());
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends PaintMode {
        public void paint(ShapePaintable shapePaintable, Graphics graphics) {
            if (shapePaintable == null || graphics == null) {
                return;
            }
            Shape shape = shapePaintable.getStrokedShape();
            if (shape == null) {
                return;
            }
            Graphics2D graphics2D = shapePaintable.getPreparedGraphics2D(graphics);
            graphics2D.setPaint(shapePaintable.getDrawPaint());
            graphics2D.fill(shape);
        }

        public Rectangle2D getBounds2D(ShapePaintable shapePaintable) {
            if (shapePaintable == null) {
                return new Rectangle2D.Double();
            }
            Shape shape = shapePaintable.getStrokedShape();
            if (shape == null) {
                return new Rectangle2D.Double();
            }
            return shape.getBounds2D();
        }

        public Shape getOutline(ShapePaintable shapePaintable) {
            if (shapePaintable == null) {
                return null;
            }
            return shapePaintable.getStrokedShape();
        }

        public boolean contains(ShapePaintable shapePaintable, double d, double d2) {
            if (shapePaintable == null) {
                return false;
            }
            Shape shape = shapePaintable.getStrokedShape();
            if (shape == null) {
                return false;
            }
            return shape.contains(d, d2);
        }

        public boolean contains(ShapePaintable shapePaintable, Point2D point2D) {
            if (point2D == null) {
                return false;
            }
            return this.contains(shapePaintable, point2D.getX(), point2D.getY());
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends PaintMode {
        public void paint(ShapePaintable shapePaintable, Graphics graphics) {
            if (shapePaintable == null || graphics == null) {
                return;
            }
            Shape shape = shapePaintable.getShape();
            if (shape == null) {
                return;
            }
            Shape shape2 = shapePaintable.getStrokedShape();
            if (shape2 == null) {
                return;
            }
            Graphics2D graphics2D = shapePaintable.getPreparedGraphics2D(graphics);
            graphics2D.setPaint(shapePaintable.getFillPaint());
            graphics2D.fill(shape);
            graphics2D.setPaint(shapePaintable.getDrawPaint());
            graphics2D.fill(shape2);
        }

        public Rectangle2D getBounds2D(ShapePaintable shapePaintable) {
            if (shapePaintable == null) {
                return new Rectangle2D.Double();
            }
            Shape shape = shapePaintable.getShape();
            if (shape == null) {
                return new Rectangle2D.Double();
            }
            Shape shape2 = shapePaintable.getStrokedShape();
            if (shape2 == null) {
                return new Rectangle2D.Double();
            }
            Rectangle2D rectangle2D = shape.getBounds2D();
            Rectangle2D rectangle2D2 = shape2.getBounds2D();
            rectangle2D.add(rectangle2D2);
            return rectangle2D;
        }

        public Shape getOutline(ShapePaintable shapePaintable) {
            if (shapePaintable == null) {
                return null;
            }
            Shape shape = shapePaintable.getShape();
            if (shape == null) {
                return null;
            }
            Shape shape2 = shapePaintable.getStrokedShape();
            if (shape2 == null) {
                return null;
            }
            Area area = new Area(shape);
            Area area2 = new Area(shape2);
            area.add(area2);
            return area;
        }

        public boolean contains(ShapePaintable shapePaintable, double d, double d2) {
            if (shapePaintable == null) {
                return false;
            }
            Shape shape = shapePaintable.getShape();
            if (shape == null) {
                return false;
            }
            Shape shape2 = shapePaintable.getStrokedShape();
            if (shape2 == null) {
                return false;
            }
            return shape.contains(d, d2) || shape2.contains(d, d2);
        }

        public boolean contains(ShapePaintable shapePaintable, Point2D point2D) {
            if (point2D == null) {
                return false;
            }
            return this.contains(shapePaintable, point2D.getX(), point2D.getY());
        }

        /* synthetic */ 3() {
        }
    }
}

