/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.gui;

import edu.neu.ccs.gui.AbstractMutatablePaintable;
import edu.neu.ccs.gui.Mutator;
import edu.neu.ccs.gui.Paintable;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class MutatableWrapper
extends AbstractMutatablePaintable {
    public static final String SET_PAINTABLE = "set.paintable";
    private Paintable paintable = null;

    public MutatableWrapper() {
    }

    public MutatableWrapper(Paintable paintable) {
        this.setPaintable(paintable);
    }

    public MutatableWrapper(Paintable paintable, AffineTransform affineTransform) {
        this.setPaintable(paintable);
        this.setMutator(affineTransform);
    }

    public final void paint(Graphics graphics) {
        if (this.paintable == null || graphics == null || !this.isVisible()) {
            return;
        }
        Graphics2D graphics2D = this.getPreparedGraphics2D(graphics);
        graphics2D.transform(this.getMutator());
        this.paintable.paint(graphics2D);
    }

    public final void setPaintable(Paintable paintable) {
        if (paintable == this.paintable) {
            return;
        }
        this.removeAndAddForwardingListener(this.paintable, paintable);
        this.paintable = paintable;
        this.firePropertyChange(SET_PAINTABLE, null, null);
    }

    public final Paintable getPaintable() {
        return this.paintable;
    }

    public final Rectangle2D getBounds2D() {
        Rectangle2D rectangle2D = this.getDefaultBounds2D();
        if (rectangle2D != null) {
            return rectangle2D;
        }
        if (this.paintable == null) {
            return new Rectangle2D.Double();
        }
        return super.getBounds2D();
    }

    public final Point2D getCenter() {
        if (this.paintable == null) {
            return new Point2D.Double();
        }
        Point2D point2D = this.getDefaultCenter();
        if (point2D != null) {
            return point2D;
        }
        return super.getCenter();
    }

    public final Rectangle2D getOriginalBounds2D() {
        if (this.paintable == null) {
            return new Rectangle2D.Double();
        }
        return this.paintable.getBounds2D();
    }

    public final Point2D getOriginalCenter() {
        if (this.paintable == null) {
            return new Point2D.Double();
        }
        return this.paintable.getCenter();
    }

    public final void addPreMutation(Mutator.Strategy strategy) {
        if (this.paintable == null) {
            return;
        }
        super.addPreMutation(strategy);
    }

    public final void addPostMutation(Mutator.Strategy strategy) {
        if (this.paintable == null) {
            return;
        }
        super.addPostMutation(strategy);
    }

    public final boolean contains(double d, double d2) {
        if (this.paintable == null) {
            return false;
        }
        if (!this.possiblyContains(d, d2)) {
            return false;
        }
        Point2D.Double double_ = new Point2D.Double(d, d2);
        this.getMutatorInverse().transform(double_, double_);
        return this.paintable.contains(double_);
    }
}

